/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file.parameters;

import com.smartling.api.sdk.file.FileType;
import com.smartling.api.sdk.file.parameters.ParameterBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class FileUploadParameterBuilder
implements ParameterBuilder {
    private FileType fileType;
    private String fileUri;
    private Boolean approveContent;
    private String callbackUrl;
    private List<String> localesToApprove;
    private Boolean overwriteApprovedLocales;
    private Map<String, String> directives;

    public FileUploadParameterBuilder directives(Map<String, String> directives) {
        this.directives = directives;
        return this;
    }

    public FileUploadParameterBuilder overwriteApprovedLocales(Boolean overwriteApprovedLocales) {
        this.overwriteApprovedLocales = overwriteApprovedLocales;
        return this;
    }

    public FileUploadParameterBuilder localesToApprove(List<String> localesToApprove) {
        this.localesToApprove = localesToApprove;
        return this;
    }

    public List<String> getLocalesToApprove() {
        return null != this.localesToApprove ? this.localesToApprove : new ArrayList<String>();
    }

    public FileUploadParameterBuilder callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public FileUploadParameterBuilder approveContent(Boolean approveContent) {
        this.approveContent = approveContent;
        return this;
    }

    public FileUploadParameterBuilder fileUri(String fileUri) {
        this.fileUri = fileUri;
        return this;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public FileUploadParameterBuilder fileType(FileType fileType) {
        this.fileType = fileType;
        return this;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    @Override
    public List<NameValuePair> getNameValueList() {
        LinkedList<NameValuePair> paramsList = new LinkedList<NameValuePair>();
        paramsList.add((NameValuePair)new BasicNameValuePair("fileUri", this.fileUri));
        paramsList.add((NameValuePair)new BasicNameValuePair("fileType", this.fileType.getIdentifier()));
        paramsList.add((NameValuePair)new BasicNameValuePair("approved", null == this.approveContent ? null : Boolean.toString(this.approveContent)));
        paramsList.add((NameValuePair)new BasicNameValuePair("callbackUrl", this.callbackUrl));
        if (this.localesToApprove != null && !this.localesToApprove.isEmpty()) {
            paramsList.addAll(this.convertLocalesBasedApproveParams("localesToApprove", this.localesToApprove));
        }
        if (this.overwriteApprovedLocales != null) {
            paramsList.add((NameValuePair)new BasicNameValuePair("overwriteApprovedLocales", this.overwriteApprovedLocales.toString()));
        }
        paramsList.addAll(this.convertMapParams(this.directives));
        return paramsList;
    }

    private List<NameValuePair> convertLocalesBasedApproveParams(String prefix, List<String> values) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (int index = 0; index < values.size(); ++index) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(prefix + "[" + index + "]", values.get(index)));
        }
        return nameValuePairs;
    }

    private List<NameValuePair> convertMapParams(Map<String, String> paramMap) {
        if (paramMap != null && !paramMap.isEmpty()) {
            LinkedList<NameValuePair> nameValuePairs = new LinkedList<NameValuePair>();
            for (String key : paramMap.keySet()) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair(key, paramMap.get(key)));
            }
            return nameValuePairs;
        }
        return Collections.emptyList();
    }
}

