/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.sdk.file.commandline;

import com.smartling.api.sdk.file.FileApiClientAdapterImpl;
import com.smartling.api.sdk.file.FileApiException;
import com.smartling.api.sdk.file.commandline.RetrieveFileParams;
import com.smartling.api.sdk.file.response.StringResponse;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class RetrieveFile {
    private static final Log logger = LogFactory.getLog((String)"com.smartling.api.sdk.file.commandline.RetrieveFile");
    private static final String LOCALE_SEPERATOR = "-";
    private static final String LOCALE_FILENAME_SEPERATOR = "_";
    private static final String PROPERTY_FILE_EXT = ".properties";
    private static final String RESULT = "New file created: %s";

    public static void main(String[] args) throws IOException, FileApiException {
        File translatedFile = RetrieveFile.retrieve(args);
        logger.info((Object)String.format(RESULT, translatedFile.getName()));
    }

    protected static File retrieve(String[] args) throws FileApiException, IOException {
        RetrieveFileParams retrieveFileParams = RetrieveFile.getParameters(args);
        File file = new File(retrieveFileParams.getPathToFile());
        FileApiClientAdapterImpl smartlingFAPI = new FileApiClientAdapterImpl(retrieveFileParams.isProductionMode(), retrieveFileParams.getApiKey(), retrieveFileParams.getProjectId());
        StringResponse response = smartlingFAPI.getFile(file.getName(), retrieveFileParams.getLocale(), null);
        File translatedFile = new File(RetrieveFile.getTranslatedFilePath(file, retrieveFileParams.getLocale(), retrieveFileParams.getPathToStoreFile()));
        FileUtils.writeStringToFile((File)translatedFile, (String)response.getContents(), (String)response.getEncoding());
        return translatedFile;
    }

    private static RetrieveFileParams getParameters(String[] args) {
        Assert.isTrue((args.length == 6 ? 1 : 0) != 0, (String)"Invalid number of arguments");
        RetrieveFileParams retrieveFileParams = new RetrieveFileParams();
        retrieveFileParams.setProductionMode(Boolean.valueOf(args[0]));
        retrieveFileParams.setApiKey(args[1]);
        retrieveFileParams.setProjectId(args[2]);
        retrieveFileParams.setPathToFile(args[3]);
        retrieveFileParams.setLocale(args[4]);
        retrieveFileParams.setPathToStoreFile(args[5]);
        return retrieveFileParams;
    }

    private static String getTranslatedFilePath(File file, String localeString, String pathToStoreFile) {
        StringBuilder stringBuilder = new StringBuilder(pathToStoreFile);
        String locale = StringUtils.isNotBlank((String)localeString) ? localeString.replace(LOCALE_SEPERATOR, LOCALE_FILENAME_SEPERATOR) : "";
        stringBuilder.append(file.getName().replace(PROPERTY_FILE_EXT, LOCALE_FILENAME_SEPERATOR + locale + PROPERTY_FILE_EXT));
        return stringBuilder.toString();
    }
}

