/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.tests.wiremock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class SmartlingWireMock
extends WireMock {
    private static final String RESPONSE_TEMPLATE = "{\n  \"response\": {\n    \"code\": \"\"  }\n}";
    private static final ObjectMapper mapper = new ObjectMapper();

    private static JsonNode readTree(String object) {
        try {
            return mapper.readTree(object);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't create json response", e);
        }
    }

    private static ObjectNode responseTemplate() {
        return (ObjectNode)SmartlingWireMock.readTree(RESPONSE_TEMPLATE);
    }

    public static MappingBuilder postJson(UrlPattern urlPattern) {
        return SmartlingWireMock.post((UrlPattern)urlPattern).withHeader("Content-Type", SmartlingWireMock.equalTo((String)"application/json"));
    }

    public static <T extends Enum<T>> ResponseDefinitionBuilder smartlingResponse(Enum<T> responseCode, String contentType, String data, String errors) {
        ObjectNode response = SmartlingWireMock.responseTemplate();
        ((ObjectNode)response.get("response")).put("code", responseCode.name());
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            ((ObjectNode)response.get("response")).set("data", SmartlingWireMock.readTree(data));
        }
        if (StringUtils.isNotEmpty((CharSequence)errors)) {
            ((ObjectNode)response.get("response")).set("errors", SmartlingWireMock.readTree(errors));
        }
        return SmartlingWireMock.aResponse().withHeader("Content-Type", new String[]{contentType}).withJsonBody((JsonNode)response);
    }

    public static <T extends Enum<T>> ResponseDefinitionBuilder smartlingResponse(Enum<T> responseCode, String data, String errors) {
        return SmartlingWireMock.smartlingResponse(responseCode, "application/json", data, errors);
    }

    public static ResponseDefinitionBuilder success(String data) {
        return SmartlingWireMock.smartlingResponse(ResponseCode.SUCCESS, data, null);
    }

    public static <T extends Enum<T>> ResponseDefinitionBuilder error(Enum<T> responseCode, String errors) {
        return SmartlingWireMock.smartlingResponse(responseCode, null, errors);
    }

    public static enum ResponseCode {
        SUCCESS;

    }
}

