/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.client.context;

public class HttpClientSettings {
    private Proxy proxy = Proxy.NONE;

    public void setProxy(Proxy proxy) {
        this.proxy = HttpClientSettings.validateNotNull(proxy, "Proxy configuration can not be null");
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    private static void validatePortRange(int port) {
        if (port <= 0 || port >= 65535) {
            throw new IllegalArgumentException("Port is out of range");
        }
    }

    private static void validateNotEmpty(String value, String message) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private static <T> T validateNotNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static class Proxy {
        public static final Proxy NONE = new Proxy(null, 0, null, null);
        private final String host;
        private final int port;
        private final String user;
        private final String password;

        private Proxy(String host, int port, String user, String password) {
            this.host = host;
            this.port = port;
            this.user = user;
            this.password = password;
        }

        public static Proxy anonymous(String host, int port) {
            HttpClientSettings.validateNotEmpty(host, "Host must not be empty");
            HttpClientSettings.validatePortRange(port);
            return new Proxy(host, port, null, null);
        }

        public static Proxy withAuthentication(String host, int port, String user, String password) {
            HttpClientSettings.validateNotEmpty(host, "Host must not be empty");
            HttpClientSettings.validatePortRange(port);
            HttpClientSettings.validateNotEmpty(user, "User must not be empty");
            HttpClientSettings.validateNotEmpty(password, "Password must not be empty");
            return new Proxy(host, port, user, password);
        }

        public static Proxy newProxy(String host, Integer port, String user, String password) {
            if (host == null || host.isEmpty() || port == null) {
                return NONE;
            }
            if (user == null || user.isEmpty()) {
                return Proxy.anonymous(host, port);
            }
            return Proxy.withAuthentication(host, port, user, password);
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

