/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client.exception;

import com.smartling.api.v2.client.exception.RestApiExceptionMapper;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import com.smartling.api.v2.client.exception.client.AuthenticationErrorException;
import com.smartling.api.v2.client.exception.client.AuthorizationErrorException;
import com.smartling.api.v2.client.exception.client.ClientApiException;
import com.smartling.api.v2.client.exception.client.NotFoundErrorException;
import com.smartling.api.v2.client.exception.client.ResourceLockedErrorException;
import com.smartling.api.v2.client.exception.client.TooManyRequestsException;
import com.smartling.api.v2.client.exception.client.ValidationErrorException;
import com.smartling.api.v2.client.exception.server.MaintanenceModeErrorException;
import com.smartling.api.v2.client.exception.server.ServerApiException;
import com.smartling.api.v2.client.exception.server.ServiceBusyErrorException;
import com.smartling.api.v2.response.ErrorResponse;
import com.smartling.api.v2.response.ResponseCode;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestApiExceptionMapper
implements RestApiExceptionMapper {
    private static final Logger log = LoggerFactory.getLogger(DefaultRestApiExceptionMapper.class);

    @Override
    public RestApiRuntimeException toException(Throwable throwable, Response response, ErrorResponse errorResponse) {
        RestApiRuntimeException restApiRuntimeException;
        if (errorResponse != null && errorResponse.getCode() != null) {
            ResponseCode code = errorResponse.getCode();
            switch (code) {
                case AUTHORIZATION_ERROR: {
                    restApiRuntimeException = new AuthorizationErrorException(throwable, response, errorResponse);
                    break;
                }
                case AUTHENTICATION_ERROR: {
                    restApiRuntimeException = new AuthenticationErrorException(throwable, response, errorResponse);
                    break;
                }
                case NOT_FOUND_ERROR: {
                    restApiRuntimeException = new NotFoundErrorException(throwable, response, errorResponse);
                    break;
                }
                case VALIDATION_ERROR: {
                    restApiRuntimeException = this.toExceptionByStatus(throwable, response, errorResponse);
                    break;
                }
                case MAX_OPERATIONS_LIMIT_EXCEEDED: {
                    restApiRuntimeException = new TooManyRequestsException(throwable, response, errorResponse);
                    break;
                }
                case RESOURCE_LOCKED: {
                    restApiRuntimeException = new ResourceLockedErrorException(throwable, response, errorResponse);
                    break;
                }
                case MAINTENANCE_MODE_ERROR: {
                    restApiRuntimeException = new MaintanenceModeErrorException(throwable, response, errorResponse);
                    break;
                }
                case SERVICE_BUSY: {
                    restApiRuntimeException = new ServiceBusyErrorException(throwable, response, errorResponse);
                    break;
                }
                case GENERAL_ERROR: {
                    restApiRuntimeException = new ServerApiException(throwable, response, errorResponse);
                    break;
                }
                default: {
                    restApiRuntimeException = this.createGenericException(throwable, response, errorResponse);
                    break;
                }
            }
        } else {
            restApiRuntimeException = this.createGenericException(throwable, response, errorResponse);
        }
        return restApiRuntimeException;
    }

    private RestApiRuntimeException toExceptionByStatus(Throwable throwable, Response response, ErrorResponse errorResponse) {
        ClientApiException restApiRuntimeException;
        switch (response.getStatus()) {
            case 401: {
                restApiRuntimeException = new AuthenticationErrorException(throwable, response, errorResponse);
                break;
            }
            case 404: {
                restApiRuntimeException = new NotFoundErrorException(throwable, response, errorResponse);
                break;
            }
            default: {
                restApiRuntimeException = new ValidationErrorException(throwable, response, errorResponse);
            }
        }
        return restApiRuntimeException;
    }

    private RestApiRuntimeException createGenericException(Throwable throwable, Response response, ErrorResponse errorResponse) {
        int statusCode = response.getStatus();
        RestApiRuntimeException restApiRuntimeException = statusCode > 399 && statusCode < 500 ? new ClientApiException(throwable, response, errorResponse) : (statusCode > 499 && statusCode < 600 ? new ServerApiException(throwable, response, errorResponse) : new RestApiRuntimeException(throwable, response, errorResponse));
        return restApiRuntimeException;
    }
}

