/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay.hapiclient.http;

import com.damnhandy.uri.template.UriTemplate;
import com.slimpay.hapiclient.exception.HttpClientErrorException;
import com.slimpay.hapiclient.exception.HttpException;
import com.slimpay.hapiclient.exception.HttpRedirectionException;
import com.slimpay.hapiclient.exception.HttpServerErrorException;
import com.slimpay.hapiclient.exception.RelNotFoundException;
import com.slimpay.hapiclient.exception.UnparsableResponseException;
import com.slimpay.hapiclient.hal.RegisteredRel;
import com.slimpay.hapiclient.hal.Resource;
import com.slimpay.hapiclient.http.Follow;
import com.slimpay.hapiclient.http.Request;
import com.slimpay.hapiclient.http.auth.AuthenticationMethod;
import com.slimpay.hapiclient.util.EntityConverter;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HapiClient
implements Closeable {
    private final String apiUrl;
    private final String entryPointUrl;
    private final String profile;
    private final AuthenticationMethod authenticationMethod;
    private final CloseableHttpClient client;
    private Resource entryPointResource;

    private HapiClient(String apiUrl, String entryPointUrl, String profile, AuthenticationMethod authenticationMethod, CloseableHttpClient client) {
        this.apiUrl = apiUrl;
        this.entryPointUrl = entryPointUrl;
        this.profile = profile;
        this.authenticationMethod = authenticationMethod;
        this.client = client;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getEntryPointUrl() {
        return this.entryPointUrl;
    }

    public String getProfile() {
        return this.profile;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public Resource send(Request request) throws HttpException {
        String responseBody;
        HttpRequestBase httpRequest = this.createHttpRequest(request);
        CloseableHttpResponse httpResponse = this.executeHttpRequest((HttpUriRequest)httpRequest);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return Resource.fromJson(HapiClient.consumeResponse(httpResponse));
        }
        try {
            responseBody = HapiClient.consumeResponse(httpResponse);
        }
        catch (UnparsableResponseException ignored) {
            responseBody = null;
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new HttpRedirectionException(httpRequest, httpResponse, responseBody);
        }
        if (statusCode >= 400 && statusCode < 500) {
            throw new HttpClientErrorException(httpRequest, httpResponse, responseBody);
        }
        if (statusCode >= 500 && statusCode < 600) {
            throw new HttpServerErrorException(httpRequest, httpResponse, responseBody);
        }
        throw new HttpException(httpRequest, httpResponse, responseBody);
    }

    private static String consumeResponse(CloseableHttpResponse httpResponse) throws UnparsableResponseException {
        try {
            String string = EntityConverter.entityToString(httpResponse.getEntity());
            return string;
        }
        catch (Exception e) {
            throw new UnparsableResponseException("Couldn't parse response entity.", e);
        }
        finally {
            HapiClient.closeResponseQuietly(httpResponse);
        }
    }

    public Resource send(Follow follow) throws HttpException, RelNotFoundException {
        return this.send(follow, this.getEntryPointResource());
    }

    public Resource send(Follow follow, Resource resource) throws HttpException, RelNotFoundException {
        try {
            return resource.getEmbeddedResource(follow.getRel());
        }
        catch (RelNotFoundException relNotFoundException) {
            return this.send(((Request.Builder)((Request.Builder)new Request.Builder(follow.getUrl(resource)).setMethod(follow.getMethod()).setUrlVariables((Map)follow.getUrlVariables())).setMessageBody(follow.getMessageBody()).addHeaders((List)follow.getHeaders())).build());
        }
    }

    public Resource send(List<Follow> follow) throws HttpException, RelNotFoundException {
        return this.send(follow, this.getEntryPointResource());
    }

    public Resource send(List<Follow> follow, Resource resource) throws HttpException, RelNotFoundException {
        if (follow.size() == 0) {
            throw new IllegalArgumentException("The follow list is empty.");
        }
        Resource lastResource = resource;
        for (Follow hop : follow) {
            lastResource = this.send(hop, lastResource);
        }
        return lastResource;
    }

    public synchronized Resource getEntryPointResource() throws HttpException {
        if (this.entryPointResource == null) {
            this.entryPointResource = this.send(new Request.Builder(this.entryPointUrl).build());
        }
        return this.entryPointResource;
    }

    public Resource refresh(Resource resource) {
        try {
            String url = resource.getLink(RegisteredRel.SELF).getHref();
            return this.send(new Request.Builder(url).build());
        }
        catch (Exception ignored) {
            return resource;
        }
    }

    private HttpRequestBase createHttpRequest(Request request) {
        List<Header> headers;
        HttpGet httpRequest;
        URI uri;
        Map<String, Object> urlVariables;
        String url = request.getUrl().trim();
        if (url.startsWith("/")) {
            url = String.valueOf(this.apiUrl) + url;
        }
        if ((urlVariables = request.getUrlVariables()) != null && !urlVariables.isEmpty()) {
            url = UriTemplate.fromTemplate((String)url).set(urlVariables).expand();
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        switch (request.getMethod()) {
            case GET: {
                httpRequest = new HttpGet(uri);
                break;
            }
            case POST: {
                httpRequest = new HttpPost(uri);
                break;
            }
            case PUT: {
                httpRequest = new HttpPut(uri);
                break;
            }
            case PATCH: {
                httpRequest = new HttpPatch(uri);
                break;
            }
            case DELETE: {
                httpRequest = new HttpDelete(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Request Method not supported");
            }
        }
        HttpEntity messageBody = request.getMessageBody();
        if (messageBody != null && httpRequest instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(messageBody);
        }
        if ((headers = request.getHeaders()) != null) {
            for (Header header : headers) {
                httpRequest.addHeader(header);
            }
        }
        if (httpRequest.getFirstHeader("Accept") == null) {
            String accept = this.profile != null && !this.profile.isEmpty() ? "application/hal+json; profile=\"" + this.profile + "\"" : "application/json";
            httpRequest.addHeader("Accept", accept);
        }
        return httpRequest;
    }

    private CloseableHttpResponse executeHttpRequest(HttpUriRequest httpRequest) throws HttpException {
        try {
            CloseableHttpResponse httpResponse;
            if (this.authenticationMethod != null) {
                this.authenticationMethod.authorizeRequest(this, httpRequest);
            }
            if ((httpResponse = this.client.execute(httpRequest)).getStatusLine().getStatusCode() == 401 && this.authenticationMethod != null) {
                HapiClient.closeResponseQuietly(httpResponse);
                this.authenticationMethod.authorizeRequest(this, httpRequest);
                httpResponse = this.client.execute(httpRequest);
            }
            return httpResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void closeResponseQuietly(CloseableHttpResponse httpResponse) {
        try {
            httpResponse.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public void closeQuietly() {
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /* synthetic */ HapiClient(String string, String string2, String string3, AuthenticationMethod authenticationMethod, CloseableHttpClient closeableHttpClient, HapiClient hapiClient) {
        this(string, string2, string3, authenticationMethod, closeableHttpClient);
    }

    public static class Builder {
        private String apiUrl;
        private String entryPointUrl;
        private String profile;
        private AuthenticationMethod authenticationMethod;
        private HttpClientBuilder clientBuilder;
        private HttpClientConnectionManager connectionManager;

        public Builder setApiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder setEntryPointUrl(String entryPointUrl) {
            this.entryPointUrl = entryPointUrl;
            return this;
        }

        public Builder setProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public Builder setClientBuilder(HttpClientBuilder clientBuilder) {
            this.clientBuilder = clientBuilder;
            return this;
        }

        public Builder setConnectionManager(HttpClientConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        public HapiClient build() {
            if (this.entryPointUrl == null || this.entryPointUrl.trim().isEmpty()) {
                this.entryPointUrl = "/";
            }
            if (this.clientBuilder == null) {
                this.clientBuilder = HttpClients.custom();
                if (this.connectionManager == null) {
                    this.connectionManager = new PoolingHttpClientConnectionManager();
                    ((PoolingHttpClientConnectionManager)this.connectionManager).setMaxTotal(20);
                    ((PoolingHttpClientConnectionManager)this.connectionManager).setDefaultMaxPerRoute(5);
                    this.clientBuilder.setConnectionManager(this.connectionManager);
                }
            }
            return new HapiClient(this.apiUrl, this.entryPointUrl, this.profile, this.authenticationMethod, this.clientBuilder.build(), null);
        }
    }
}

