/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.response.admin.analytics;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.slack.api.methods.SlackApiBinaryResponse;
import com.slack.api.model.ResponseMetadata;
import com.slack.api.util.json.GsonFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminAnalyticsGetFileResponse
implements SlackApiBinaryResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminAnalyticsGetFileResponse.class);
    private boolean ok;
    private String error;
    private ResponseMetadata responseMetadata;
    private InputStream fileStream;
    private byte[] loadedBytes = new byte[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] asBytes() throws IOException {
        byte[] byArray = this.loadedBytes;
        synchronized (this.loadedBytes) {
            if (this.loadedBytes.length == 0) {
                try (InputStream is = this.getFileStream();){
                    if (is == null) {
                        throw new IOException("The byte stream has been already consumed.");
                    }
                    try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                        int readSize;
                        byte[] data = new byte[1024];
                        while ((readSize = is.read(data, 0, data.length)) != -1) {
                            buffer.write(data, 0, readSize);
                        }
                        buffer.flush();
                        this.loadedBytes = buffer.toByteArray();
                    }
                }
                finally {
                    this.setFileStream(null);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.loadedBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<AnalyticsData> handler) throws IOException {
        Gson gson = GsonFactory.createSnakeCase();
        InputStream is = this.getFileStream();
        if (this.loadedBytes.length > 0) {
            is = new ByteArrayInputStream(this.loadedBytes);
        }
        if (is == null) {
            throw new IOException("The byte stream has been already consumed.");
        }
        try (GZIPInputStream gis = new GZIPInputStream(is);
             InputStreamReader isr = new InputStreamReader(gis);
             BufferedReader br = new BufferedReader(isr);){
            String json;
            while ((json = br.readLine()) != null) {
                try {
                    AnalyticsData data = (AnalyticsData)gson.fromJson(json, AnalyticsData.class);
                    handler.accept(data);
                }
                catch (JsonSyntaxException e) {
                    log.error("Failed to parse a row in analytics data - error: {}, data: {}", new Object[]{e.getMessage(), json, e});
                }
            }
        }
        finally {
            this.setFileStream(null);
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Generated
    public AdminAnalyticsGetFileResponse() {
    }

    @Generated
    public boolean isOk() {
        return this.ok;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public ResponseMetadata getResponseMetadata() {
        return this.responseMetadata;
    }

    @Generated
    public InputStream getFileStream() {
        return this.fileStream;
    }

    @Generated
    public void setOk(boolean ok) {
        this.ok = ok;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public void setResponseMetadata(ResponseMetadata responseMetadata) {
        this.responseMetadata = responseMetadata;
    }

    @Generated
    public void setFileStream(InputStream fileStream) {
        this.fileStream = fileStream;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminAnalyticsGetFileResponse)) {
            return false;
        }
        AdminAnalyticsGetFileResponse other = (AdminAnalyticsGetFileResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOk() != other.isOk()) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        ResponseMetadata this$responseMetadata = this.getResponseMetadata();
        ResponseMetadata other$responseMetadata = other.getResponseMetadata();
        if (this$responseMetadata == null ? other$responseMetadata != null : !this$responseMetadata.equals(other$responseMetadata)) {
            return false;
        }
        InputStream this$fileStream = this.getFileStream();
        InputStream other$fileStream = other.getFileStream();
        if (this$fileStream == null ? other$fileStream != null : !this$fileStream.equals(other$fileStream)) {
            return false;
        }
        return Arrays.equals(this.loadedBytes, other.loadedBytes);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdminAnalyticsGetFileResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOk() ? 79 : 97);
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        ResponseMetadata $responseMetadata = this.getResponseMetadata();
        result = result * 59 + ($responseMetadata == null ? 43 : $responseMetadata.hashCode());
        InputStream $fileStream = this.getFileStream();
        result = result * 59 + ($fileStream == null ? 43 : $fileStream.hashCode());
        result = result * 59 + Arrays.hashCode(this.loadedBytes);
        return result;
    }

    @Generated
    public String toString() {
        return "AdminAnalyticsGetFileResponse(ok=" + this.isOk() + ", error=" + this.getError() + ", responseMetadata=" + this.getResponseMetadata() + ", fileStream=" + this.getFileStream() + ", loadedBytes=" + Arrays.toString(this.loadedBytes) + ")";
    }

    public static class AnalyticsData {
        private String date;
        private String enterpriseId;
        private String enterpriseUserId;
        private String emailAddress;
        private String enterpriseEmployeeNumber;
        private Boolean isGuest;
        private Boolean isBillableSeat;
        private Boolean isActive;
        private Boolean isActiveIos;
        private Boolean isActiveAndroid;
        private Boolean isActiveDesktop;
        private Integer reactionsAddedCount;
        private Integer messagesPostedCount;
        private Integer channelMessagesPostedCount;
        private Integer filesAddedCount;

        @Generated
        public AnalyticsData() {
        }

        @Generated
        public String getDate() {
            return this.date;
        }

        @Generated
        public String getEnterpriseId() {
            return this.enterpriseId;
        }

        @Generated
        public String getEnterpriseUserId() {
            return this.enterpriseUserId;
        }

        @Generated
        public String getEmailAddress() {
            return this.emailAddress;
        }

        @Generated
        public String getEnterpriseEmployeeNumber() {
            return this.enterpriseEmployeeNumber;
        }

        @Generated
        public Boolean getIsGuest() {
            return this.isGuest;
        }

        @Generated
        public Boolean getIsBillableSeat() {
            return this.isBillableSeat;
        }

        @Generated
        public Boolean getIsActive() {
            return this.isActive;
        }

        @Generated
        public Boolean getIsActiveIos() {
            return this.isActiveIos;
        }

        @Generated
        public Boolean getIsActiveAndroid() {
            return this.isActiveAndroid;
        }

        @Generated
        public Boolean getIsActiveDesktop() {
            return this.isActiveDesktop;
        }

        @Generated
        public Integer getReactionsAddedCount() {
            return this.reactionsAddedCount;
        }

        @Generated
        public Integer getMessagesPostedCount() {
            return this.messagesPostedCount;
        }

        @Generated
        public Integer getChannelMessagesPostedCount() {
            return this.channelMessagesPostedCount;
        }

        @Generated
        public Integer getFilesAddedCount() {
            return this.filesAddedCount;
        }

        @Generated
        public void setDate(String date) {
            this.date = date;
        }

        @Generated
        public void setEnterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @Generated
        public void setEnterpriseUserId(String enterpriseUserId) {
            this.enterpriseUserId = enterpriseUserId;
        }

        @Generated
        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Generated
        public void setEnterpriseEmployeeNumber(String enterpriseEmployeeNumber) {
            this.enterpriseEmployeeNumber = enterpriseEmployeeNumber;
        }

        @Generated
        public void setIsGuest(Boolean isGuest) {
            this.isGuest = isGuest;
        }

        @Generated
        public void setIsBillableSeat(Boolean isBillableSeat) {
            this.isBillableSeat = isBillableSeat;
        }

        @Generated
        public void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Generated
        public void setIsActiveIos(Boolean isActiveIos) {
            this.isActiveIos = isActiveIos;
        }

        @Generated
        public void setIsActiveAndroid(Boolean isActiveAndroid) {
            this.isActiveAndroid = isActiveAndroid;
        }

        @Generated
        public void setIsActiveDesktop(Boolean isActiveDesktop) {
            this.isActiveDesktop = isActiveDesktop;
        }

        @Generated
        public void setReactionsAddedCount(Integer reactionsAddedCount) {
            this.reactionsAddedCount = reactionsAddedCount;
        }

        @Generated
        public void setMessagesPostedCount(Integer messagesPostedCount) {
            this.messagesPostedCount = messagesPostedCount;
        }

        @Generated
        public void setChannelMessagesPostedCount(Integer channelMessagesPostedCount) {
            this.channelMessagesPostedCount = channelMessagesPostedCount;
        }

        @Generated
        public void setFilesAddedCount(Integer filesAddedCount) {
            this.filesAddedCount = filesAddedCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnalyticsData)) {
                return false;
            }
            AnalyticsData other = (AnalyticsData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isGuest = this.getIsGuest();
            Boolean other$isGuest = other.getIsGuest();
            if (this$isGuest == null ? other$isGuest != null : !((Object)this$isGuest).equals(other$isGuest)) {
                return false;
            }
            Boolean this$isBillableSeat = this.getIsBillableSeat();
            Boolean other$isBillableSeat = other.getIsBillableSeat();
            if (this$isBillableSeat == null ? other$isBillableSeat != null : !((Object)this$isBillableSeat).equals(other$isBillableSeat)) {
                return false;
            }
            Boolean this$isActive = this.getIsActive();
            Boolean other$isActive = other.getIsActive();
            if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
                return false;
            }
            Boolean this$isActiveIos = this.getIsActiveIos();
            Boolean other$isActiveIos = other.getIsActiveIos();
            if (this$isActiveIos == null ? other$isActiveIos != null : !((Object)this$isActiveIos).equals(other$isActiveIos)) {
                return false;
            }
            Boolean this$isActiveAndroid = this.getIsActiveAndroid();
            Boolean other$isActiveAndroid = other.getIsActiveAndroid();
            if (this$isActiveAndroid == null ? other$isActiveAndroid != null : !((Object)this$isActiveAndroid).equals(other$isActiveAndroid)) {
                return false;
            }
            Boolean this$isActiveDesktop = this.getIsActiveDesktop();
            Boolean other$isActiveDesktop = other.getIsActiveDesktop();
            if (this$isActiveDesktop == null ? other$isActiveDesktop != null : !((Object)this$isActiveDesktop).equals(other$isActiveDesktop)) {
                return false;
            }
            Integer this$reactionsAddedCount = this.getReactionsAddedCount();
            Integer other$reactionsAddedCount = other.getReactionsAddedCount();
            if (this$reactionsAddedCount == null ? other$reactionsAddedCount != null : !((Object)this$reactionsAddedCount).equals(other$reactionsAddedCount)) {
                return false;
            }
            Integer this$messagesPostedCount = this.getMessagesPostedCount();
            Integer other$messagesPostedCount = other.getMessagesPostedCount();
            if (this$messagesPostedCount == null ? other$messagesPostedCount != null : !((Object)this$messagesPostedCount).equals(other$messagesPostedCount)) {
                return false;
            }
            Integer this$channelMessagesPostedCount = this.getChannelMessagesPostedCount();
            Integer other$channelMessagesPostedCount = other.getChannelMessagesPostedCount();
            if (this$channelMessagesPostedCount == null ? other$channelMessagesPostedCount != null : !((Object)this$channelMessagesPostedCount).equals(other$channelMessagesPostedCount)) {
                return false;
            }
            Integer this$filesAddedCount = this.getFilesAddedCount();
            Integer other$filesAddedCount = other.getFilesAddedCount();
            if (this$filesAddedCount == null ? other$filesAddedCount != null : !((Object)this$filesAddedCount).equals(other$filesAddedCount)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                return false;
            }
            String this$enterpriseId = this.getEnterpriseId();
            String other$enterpriseId = other.getEnterpriseId();
            if (this$enterpriseId == null ? other$enterpriseId != null : !this$enterpriseId.equals(other$enterpriseId)) {
                return false;
            }
            String this$enterpriseUserId = this.getEnterpriseUserId();
            String other$enterpriseUserId = other.getEnterpriseUserId();
            if (this$enterpriseUserId == null ? other$enterpriseUserId != null : !this$enterpriseUserId.equals(other$enterpriseUserId)) {
                return false;
            }
            String this$emailAddress = this.getEmailAddress();
            String other$emailAddress = other.getEmailAddress();
            if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) {
                return false;
            }
            String this$enterpriseEmployeeNumber = this.getEnterpriseEmployeeNumber();
            String other$enterpriseEmployeeNumber = other.getEnterpriseEmployeeNumber();
            return !(this$enterpriseEmployeeNumber == null ? other$enterpriseEmployeeNumber != null : !this$enterpriseEmployeeNumber.equals(other$enterpriseEmployeeNumber));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AnalyticsData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isGuest = this.getIsGuest();
            result = result * 59 + ($isGuest == null ? 43 : ((Object)$isGuest).hashCode());
            Boolean $isBillableSeat = this.getIsBillableSeat();
            result = result * 59 + ($isBillableSeat == null ? 43 : ((Object)$isBillableSeat).hashCode());
            Boolean $isActive = this.getIsActive();
            result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
            Boolean $isActiveIos = this.getIsActiveIos();
            result = result * 59 + ($isActiveIos == null ? 43 : ((Object)$isActiveIos).hashCode());
            Boolean $isActiveAndroid = this.getIsActiveAndroid();
            result = result * 59 + ($isActiveAndroid == null ? 43 : ((Object)$isActiveAndroid).hashCode());
            Boolean $isActiveDesktop = this.getIsActiveDesktop();
            result = result * 59 + ($isActiveDesktop == null ? 43 : ((Object)$isActiveDesktop).hashCode());
            Integer $reactionsAddedCount = this.getReactionsAddedCount();
            result = result * 59 + ($reactionsAddedCount == null ? 43 : ((Object)$reactionsAddedCount).hashCode());
            Integer $messagesPostedCount = this.getMessagesPostedCount();
            result = result * 59 + ($messagesPostedCount == null ? 43 : ((Object)$messagesPostedCount).hashCode());
            Integer $channelMessagesPostedCount = this.getChannelMessagesPostedCount();
            result = result * 59 + ($channelMessagesPostedCount == null ? 43 : ((Object)$channelMessagesPostedCount).hashCode());
            Integer $filesAddedCount = this.getFilesAddedCount();
            result = result * 59 + ($filesAddedCount == null ? 43 : ((Object)$filesAddedCount).hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            String $enterpriseId = this.getEnterpriseId();
            result = result * 59 + ($enterpriseId == null ? 43 : $enterpriseId.hashCode());
            String $enterpriseUserId = this.getEnterpriseUserId();
            result = result * 59 + ($enterpriseUserId == null ? 43 : $enterpriseUserId.hashCode());
            String $emailAddress = this.getEmailAddress();
            result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
            String $enterpriseEmployeeNumber = this.getEnterpriseEmployeeNumber();
            result = result * 59 + ($enterpriseEmployeeNumber == null ? 43 : $enterpriseEmployeeNumber.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdminAnalyticsGetFileResponse.AnalyticsData(date=" + this.getDate() + ", enterpriseId=" + this.getEnterpriseId() + ", enterpriseUserId=" + this.getEnterpriseUserId() + ", emailAddress=" + this.getEmailAddress() + ", enterpriseEmployeeNumber=" + this.getEnterpriseEmployeeNumber() + ", isGuest=" + this.getIsGuest() + ", isBillableSeat=" + this.getIsBillableSeat() + ", isActive=" + this.getIsActive() + ", isActiveIos=" + this.getIsActiveIos() + ", isActiveAndroid=" + this.getIsActiveAndroid() + ", isActiveDesktop=" + this.getIsActiveDesktop() + ", reactionsAddedCount=" + this.getReactionsAddedCount() + ", messagesPostedCount=" + this.getMessagesPostedCount() + ", channelMessagesPostedCount=" + this.getChannelMessagesPostedCount() + ", filesAddedCount=" + this.getFilesAddedCount() + ")";
        }
    }
}

