/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.audit.impl;

import com.slack.api.audit.AuditConfig;
import com.slack.api.util.thread.ExecutorServiceFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;

public class ThreadPools {
    private static final ConcurrentMap<String, ExecutorService> ALL_DEFAULT = new ConcurrentHashMap<String, ExecutorService>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ExecutorService>> ENTERPRISE_CUSTOM = new ConcurrentHashMap<String, ConcurrentMap<String, ExecutorService>>();

    private ThreadPools() {
    }

    public static ExecutorService getDefault(AuditConfig config) {
        return ThreadPools.getOrCreate(config, null);
    }

    public static ExecutorService getOrCreate(AuditConfig config, String enterpriseId) {
        Integer customPoolSize;
        String executorName = config.getExecutorName();
        Integer n = customPoolSize = enterpriseId != null ? config.getCustomThreadPoolSizes().get(enterpriseId) : null;
        if (customPoolSize != null) {
            ExecutorService orgExecutor;
            ConcurrentHashMap<String, ExecutorService> allOrgs = (ConcurrentHashMap<String, ExecutorService>)ENTERPRISE_CUSTOM.get(executorName);
            if (allOrgs == null) {
                allOrgs = new ConcurrentHashMap<String, ExecutorService>();
                ENTERPRISE_CUSTOM.put(executorName, allOrgs);
            }
            if ((orgExecutor = (ExecutorService)allOrgs.get(enterpriseId)) == null) {
                String threadGroupName = "slack-audit-logs-" + config.getExecutorName() + "-" + enterpriseId;
                orgExecutor = ExecutorServiceFactory.createDaemonThreadPoolExecutor((String)threadGroupName, (int)customPoolSize);
                allOrgs.put(enterpriseId, orgExecutor);
            }
            return orgExecutor;
        }
        ExecutorService defaultExecutor = (ExecutorService)ALL_DEFAULT.get(executorName);
        if (defaultExecutor == null) {
            String threadGroupName = "slack-audit-logs-" + config.getExecutorName();
            int poolSize = config.getDefaultThreadPoolSize();
            defaultExecutor = ExecutorServiceFactory.createDaemonThreadPoolExecutor((String)threadGroupName, (int)poolSize);
            ALL_DEFAULT.put(config.getExecutorName(), defaultExecutor);
        }
        return defaultExecutor;
    }
}

