/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.RequestConfigurator;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.FunctionUtility;
import com.slack.api.bolt.context.SayUtility;
import com.slack.api.bolt.service.AssistantThreadContextService;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.request.assistant.threads.AssistantThreadsSetStatusRequest;
import com.slack.api.methods.request.assistant.threads.AssistantThreadsSetSuggestedPromptsRequest;
import com.slack.api.methods.request.assistant.threads.AssistantThreadsSetTitleRequest;
import com.slack.api.methods.request.chat.ChatPostMessageRequest;
import com.slack.api.methods.response.asssistant.threads.AssistantThreadsSetStatusResponse;
import com.slack.api.methods.response.asssistant.threads.AssistantThreadsSetSuggestedPromptsResponse;
import com.slack.api.methods.response.asssistant.threads.AssistantThreadsSetTitleResponse;
import com.slack.api.methods.response.chat.ChatPostMessageResponse;
import com.slack.api.model.Message;
import com.slack.api.model.assistant.AssistantThreadContext;
import com.slack.api.model.assistant.SuggestedPrompt;
import com.slack.api.model.block.LayoutBlock;
import java.io.IOException;
import java.util.List;
import lombok.Generated;

public class EventContext
extends Context
implements SayUtility,
FunctionUtility {
    private String channelId;
    private String threadTs;
    private AssistantThreadContext threadContext;
    private AssistantThreadContextService threadContextService;
    private boolean assistantThreadEvent;
    private Integer retryNum;
    private String retryReason;

    private Message.Metadata buildMetadata() {
        return Message.Metadata.builder().eventType("assistant_thread").eventPayload(this.getThreadContext() != null ? this.getThreadContext().toMap() : null).build();
    }

    @Override
    public ChatPostMessageResponse say(String text) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().chatPostMessage(r -> r.channel(this.getChannelId()).threadTs(this.getThreadTs()).text(text).metadata(this.buildMetadata()));
        }
        return SayUtility.super.say(text);
    }

    @Override
    public ChatPostMessageResponse say(List<LayoutBlock> blocks) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().chatPostMessage(r -> r.channel(this.getChannelId()).threadTs(this.getThreadTs()).blocks(blocks).metadata(this.buildMetadata()));
        }
        return SayUtility.super.say(blocks);
    }

    @Override
    public ChatPostMessageResponse say(String text, List<LayoutBlock> blocks) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().chatPostMessage(r -> r.channel(this.getChannelId()).threadTs(this.getThreadTs()).text(text).blocks(blocks).metadata(this.buildMetadata()));
        }
        return SayUtility.super.say(text, blocks);
    }

    @Override
    public ChatPostMessageResponse say(BuilderConfigurator<ChatPostMessageRequest.ChatPostMessageRequestBuilder> request) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            ChatPostMessageRequest params = request.configure(ChatPostMessageRequest.builder()).build();
            params.setChannel(this.getChannelId());
            params.setThreadTs(this.getThreadTs());
            params.setMetadata(this.buildMetadata());
            return this.client().chatPostMessage(params);
        }
        return super.say(request);
    }

    public AssistantThreadsSetStatusResponse setStatus(String status) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().assistantThreadsSetStatus(r -> r.channelId(this.getChannelId()).threadTs(this.getThreadTs()).status(status));
        }
        throw new IllegalStateException("This utility is only available for Assistant feature enabled app!");
    }

    public AssistantThreadsSetStatusResponse setStatus(String status, List<String> loadingMessages) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().assistantThreadsSetStatus(r -> r.channelId(this.getChannelId()).threadTs(this.getThreadTs()).status(status).loadingMessages(loadingMessages));
        }
        throw new IllegalStateException("This utility is only available for Assistant feature enabled app!");
    }

    public AssistantThreadsSetStatusResponse setStatus(RequestConfigurator<AssistantThreadsSetStatusRequest.AssistantThreadsSetStatusRequestBuilder> req) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().assistantThreadsSetStatus(((AssistantThreadsSetStatusRequest.AssistantThreadsSetStatusRequestBuilder)req.configure((Object)AssistantThreadsSetStatusRequest.builder().channelId(this.getChannelId()).threadTs(this.getThreadTs()))).build());
        }
        throw new IllegalStateException("This utility is only available for Assistant feature enabled app!");
    }

    public AssistantThreadsSetTitleResponse setTitle(String title) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().assistantThreadsSetTitle(r -> r.channelId(this.getChannelId()).threadTs(this.getThreadTs()).title(title));
        }
        throw new IllegalStateException("This utility is only available for Assistant feature enabled app!");
    }

    public AssistantThreadsSetTitleResponse setTitle(RequestConfigurator<AssistantThreadsSetTitleRequest.AssistantThreadsSetTitleRequestBuilder> req) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().assistantThreadsSetTitle(((AssistantThreadsSetTitleRequest.AssistantThreadsSetTitleRequestBuilder)req.configure((Object)AssistantThreadsSetTitleRequest.builder().channelId(this.getChannelId()).threadTs(this.getThreadTs()))).build());
        }
        throw new IllegalStateException("This utility is only available for Assistant feature enabled app!");
    }

    public AssistantThreadsSetSuggestedPromptsResponse setSuggestedPrompts(List<SuggestedPrompt> prompts) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().assistantThreadsSetSuggestedPrompts(r -> r.channelId(this.getChannelId()).threadTs(this.getThreadTs()).prompts(prompts));
        }
        throw new IllegalStateException("This utility is only available for Assistant feature enabled app!");
    }

    public AssistantThreadsSetSuggestedPromptsResponse setSuggestedPrompts(RequestConfigurator<AssistantThreadsSetSuggestedPromptsRequest.AssistantThreadsSetSuggestedPromptsRequestBuilder> req) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().assistantThreadsSetSuggestedPrompts(((AssistantThreadsSetSuggestedPromptsRequest.AssistantThreadsSetSuggestedPromptsRequestBuilder)req.configure((Object)AssistantThreadsSetSuggestedPromptsRequest.builder().channelId(this.getChannelId()).threadTs(this.getThreadTs()))).build());
        }
        throw new IllegalStateException("This utility is only available for Assistant feature enabled app!");
    }

    public AssistantThreadsSetSuggestedPromptsResponse setSuggestedPrompts(List<SuggestedPrompt> prompts, String title) throws IOException, SlackApiException {
        if (this.isAssistantThreadEvent()) {
            return this.client().assistantThreadsSetSuggestedPrompts(r -> r.channelId(this.getChannelId()).threadTs(this.getThreadTs()).prompts(prompts).title(title));
        }
        throw new IllegalStateException("This utility is only available for Assistant feature enabled app!");
    }

    @Generated
    public static EventContextBuilder builder() {
        return new EventContextBuilder();
    }

    @Override
    @Generated
    public String getChannelId() {
        return this.channelId;
    }

    @Generated
    public String getThreadTs() {
        return this.threadTs;
    }

    @Generated
    public AssistantThreadContext getThreadContext() {
        return this.threadContext;
    }

    @Generated
    public AssistantThreadContextService getThreadContextService() {
        return this.threadContextService;
    }

    @Generated
    public boolean isAssistantThreadEvent() {
        return this.assistantThreadEvent;
    }

    @Generated
    public Integer getRetryNum() {
        return this.retryNum;
    }

    @Generated
    public String getRetryReason() {
        return this.retryReason;
    }

    @Generated
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    @Generated
    public void setThreadTs(String threadTs) {
        this.threadTs = threadTs;
    }

    @Generated
    public void setThreadContext(AssistantThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    @Generated
    public void setThreadContextService(AssistantThreadContextService threadContextService) {
        this.threadContextService = threadContextService;
    }

    @Generated
    public void setAssistantThreadEvent(boolean assistantThreadEvent) {
        this.assistantThreadEvent = assistantThreadEvent;
    }

    @Generated
    public void setRetryNum(Integer retryNum) {
        this.retryNum = retryNum;
    }

    @Generated
    public void setRetryReason(String retryReason) {
        this.retryReason = retryReason;
    }

    @Override
    @Generated
    public String toString() {
        return "EventContext(super=" + super.toString() + ", channelId=" + this.getChannelId() + ", threadTs=" + this.getThreadTs() + ", threadContext=" + this.getThreadContext() + ", threadContextService=" + this.getThreadContextService() + ", assistantThreadEvent=" + this.isAssistantThreadEvent() + ", retryNum=" + this.getRetryNum() + ", retryReason=" + this.getRetryReason() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventContext)) {
            return false;
        }
        EventContext other = (EventContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAssistantThreadEvent() != other.isAssistantThreadEvent()) {
            return false;
        }
        Integer this$retryNum = this.getRetryNum();
        Integer other$retryNum = other.getRetryNum();
        if (this$retryNum == null ? other$retryNum != null : !((Object)this$retryNum).equals(other$retryNum)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$threadTs = this.getThreadTs();
        String other$threadTs = other.getThreadTs();
        if (this$threadTs == null ? other$threadTs != null : !this$threadTs.equals(other$threadTs)) {
            return false;
        }
        AssistantThreadContext this$threadContext = this.getThreadContext();
        AssistantThreadContext other$threadContext = other.getThreadContext();
        if (this$threadContext == null ? other$threadContext != null : !this$threadContext.equals(other$threadContext)) {
            return false;
        }
        AssistantThreadContextService this$threadContextService = this.getThreadContextService();
        AssistantThreadContextService other$threadContextService = other.getThreadContextService();
        if (this$threadContextService == null ? other$threadContextService != null : !this$threadContextService.equals(other$threadContextService)) {
            return false;
        }
        String this$retryReason = this.getRetryReason();
        String other$retryReason = other.getRetryReason();
        return !(this$retryReason == null ? other$retryReason != null : !this$retryReason.equals(other$retryReason));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAssistantThreadEvent() ? 79 : 97);
        Integer $retryNum = this.getRetryNum();
        result = result * 59 + ($retryNum == null ? 43 : ((Object)$retryNum).hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $threadTs = this.getThreadTs();
        result = result * 59 + ($threadTs == null ? 43 : $threadTs.hashCode());
        AssistantThreadContext $threadContext = this.getThreadContext();
        result = result * 59 + ($threadContext == null ? 43 : $threadContext.hashCode());
        AssistantThreadContextService $threadContextService = this.getThreadContextService();
        result = result * 59 + ($threadContextService == null ? 43 : $threadContextService.hashCode());
        String $retryReason = this.getRetryReason();
        result = result * 59 + ($retryReason == null ? 43 : $retryReason.hashCode());
        return result;
    }

    @Generated
    public EventContext() {
    }

    @Generated
    public EventContext(String channelId, String threadTs, AssistantThreadContext threadContext, AssistantThreadContextService threadContextService, boolean assistantThreadEvent, Integer retryNum, String retryReason) {
        this.channelId = channelId;
        this.threadTs = threadTs;
        this.threadContext = threadContext;
        this.threadContextService = threadContextService;
        this.assistantThreadEvent = assistantThreadEvent;
        this.retryNum = retryNum;
        this.retryReason = retryReason;
    }

    @Generated
    public static class EventContextBuilder {
        @Generated
        private String channelId;
        @Generated
        private String threadTs;
        @Generated
        private AssistantThreadContext threadContext;
        @Generated
        private AssistantThreadContextService threadContextService;
        @Generated
        private boolean assistantThreadEvent;
        @Generated
        private Integer retryNum;
        @Generated
        private String retryReason;

        @Generated
        EventContextBuilder() {
        }

        @Generated
        public EventContextBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        @Generated
        public EventContextBuilder threadTs(String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        @Generated
        public EventContextBuilder threadContext(AssistantThreadContext threadContext) {
            this.threadContext = threadContext;
            return this;
        }

        @Generated
        public EventContextBuilder threadContextService(AssistantThreadContextService threadContextService) {
            this.threadContextService = threadContextService;
            return this;
        }

        @Generated
        public EventContextBuilder assistantThreadEvent(boolean assistantThreadEvent) {
            this.assistantThreadEvent = assistantThreadEvent;
            return this;
        }

        @Generated
        public EventContextBuilder retryNum(Integer retryNum) {
            this.retryNum = retryNum;
            return this;
        }

        @Generated
        public EventContextBuilder retryReason(String retryReason) {
            this.retryReason = retryReason;
            return this;
        }

        @Generated
        public EventContext build() {
            return new EventContext(this.channelId, this.threadTs, this.threadContext, this.threadContextService, this.assistantThreadEvent, this.retryNum, this.retryReason);
        }

        @Generated
        public String toString() {
            return "EventContext.EventContextBuilder(channelId=" + this.channelId + ", threadTs=" + this.threadTs + ", threadContext=" + this.threadContext + ", threadContextService=" + this.threadContextService + ", assistantThreadEvent=" + this.assistantThreadEvent + ", retryNum=" + this.retryNum + ", retryReason=" + this.retryReason + ")";
        }
    }
}

