/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin;

import com.slack.api.bolt.Initializer;
import com.slack.api.bolt.model.Bot;
import com.slack.api.bolt.model.Installer;
import com.slack.api.bolt.model.builtin.DefaultBot;
import com.slack.api.bolt.model.builtin.DefaultInstaller;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.bolt.util.JsonOps;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AmazonS3InstallationService
implements InstallationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AmazonS3InstallationService.class);
    private final String bucketName;
    private AwsCredentialsProvider credentialsProvider;
    private boolean historicalDataEnabled;

    public AmazonS3InstallationService(String bucketName) {
        this.bucketName = bucketName;
    }

    @Override
    public Initializer initializer() {
        return app -> {
            this.credentialsProvider = DefaultCredentialsProvider.create();
            AwsCredentials credentials = this.createCredentials(this.credentialsProvider);
            if (credentials == null || credentials.accessKeyId() == null) {
                throw new IllegalStateException("AWS credentials not found");
            }
            if (log.isDebugEnabled()) {
                log.debug("AWS credentials loaded (access key id: {})", (Object)credentials.accessKeyId());
            }
            boolean bucketExists = false;
            Exception ex = null;
            try (S3Client s3 = this.createS3Client();){
                bucketExists = s3.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucketName).build()) != null;
            }
            catch (Exception e) {
                ex = e;
            }
            if (!bucketExists) {
                String error = ex != null ? ex.getClass().getName() + ":" + ex.getMessage() : "-";
                String message = "Failed to access the Amazon S3 bucket (name: " + this.bucketName + ", error: " + error + ")";
                throw new IllegalStateException(message);
            }
        };
    }

    @Override
    public boolean isHistoricalDataEnabled() {
        return this.historicalDataEnabled;
    }

    @Override
    public void setHistoricalDataEnabled(boolean isHistoricalDataEnabled) {
        this.historicalDataEnabled = isHistoricalDataEnabled;
    }

    @Override
    public void saveInstallerAndBot(Installer i) throws Exception {
        try (S3Client s3 = this.createS3Client();){
            if (this.isHistoricalDataEnabled()) {
                this.save(s3, this.getInstallerKey(i) + "-latest", JsonOps.toJsonString(i), "AWS S3 putObject result of Installer data - {}, {}");
                this.save(s3, this.getBotKey(i) + "-latest", JsonOps.toJsonString(i.toBot()), "AWS S3 putObject result of Bot data - {}, {}");
                this.save(s3, this.getInstallerKey(i) + "-" + i.getInstalledAt(), JsonOps.toJsonString(i), "AWS S3 putObject result of Installer data - {}, {}");
                this.save(s3, this.getBotKey(i) + "-" + i.getInstalledAt(), JsonOps.toJsonString(i.toBot()), "AWS S3 putObject result of Bot data - {}, {}");
            } else {
                this.save(s3, this.getInstallerKey(i), JsonOps.toJsonString(i), "AWS S3 putObject result of Installer data - {}, {}");
                this.save(s3, this.getBotKey(i), JsonOps.toJsonString(i.toBot()), "AWS S3 putObject result of Bot data - {}, {}");
            }
        }
    }

    @Override
    public void saveBot(Bot bot) throws Exception {
        try (S3Client s3 = this.createS3Client();){
            String keyPrefix = this.getBotKey(bot.getEnterpriseId(), bot.getTeamId());
            if (this.isHistoricalDataEnabled()) {
                this.save(s3, keyPrefix + "-latest", JsonOps.toJsonString(bot), "AWS S3 putObject result of Bot data - {}, {}");
                this.save(s3, keyPrefix + "-" + bot.getInstalledAt(), JsonOps.toJsonString(bot), "AWS S3 putObject result of Bot data - {}, {}");
            } else {
                this.save(s3, keyPrefix, JsonOps.toJsonString(bot), "AWS S3 putObject result of Bot data - {}, {}");
            }
        }
    }

    private void save(S3Client s3, String s3Key, String json, String logMessage) {
        PutObjectResponse botPutResult = s3.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(s3Key).build(), RequestBody.fromString((String)json));
        if (log.isDebugEnabled()) {
            log.debug(logMessage, (Object)s3Key, (Object)botPutResult.toString());
        }
    }

    @Override
    public void deleteBot(Bot bot) throws Exception {
        try (S3Client s3 = this.createS3Client();){
            String key = this.getBotKey(bot.getEnterpriseId(), bot.getTeamId());
            if (this.isHistoricalDataEnabled()) {
                key = key + "-latest";
            }
            if (log.isDebugEnabled()) {
                log.debug("Going to delete an object (bucket: {}, key: {})", (Object)this.bucketName, (Object)key);
            }
            s3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(key).build());
        }
    }

    @Override
    public void deleteInstaller(Installer installer) throws Exception {
        try (S3Client s3 = this.createS3Client();){
            String key = this.getInstallerKey(installer);
            if (this.isHistoricalDataEnabled()) {
                key = key + "-latest";
            }
            if (log.isDebugEnabled()) {
                log.debug("Going to delete an object (bucket: {}, key: {})", (Object)this.bucketName, (Object)key);
            }
            s3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(key).build());
        }
    }

    @Override
    public Bot findBot(String enterpriseId, String teamId) {
        ResponseBytes<GetObjectResponse> s3Object;
        String fullKey;
        S3Client s3 = this.createS3Client();
        if (enterpriseId != null) {
            fullKey = this.getBotKey(enterpriseId, null);
            if (this.isHistoricalDataEnabled()) {
                fullKey = fullKey + "-latest";
            }
            if (this.getObjectMetadata(s3, fullKey) != null) {
                s3Object = this.getObject(s3, fullKey);
                try {
                    return this.toBot(s3Object);
                }
                catch (IOException e) {
                    log.error("Failed to load org-level Bot installation for enterprise_id: {}", (Object)enterpriseId);
                }
            }
        }
        fullKey = this.getBotKey(enterpriseId, teamId);
        if (this.isHistoricalDataEnabled()) {
            fullKey = fullKey + "-latest";
        }
        if (this.getObjectMetadata(s3, fullKey) == null && enterpriseId != null) {
            ResponseBytes<GetObjectResponse> nonGridObject;
            String nonGridKey = this.getBotKey(null, teamId);
            if (this.isHistoricalDataEnabled()) {
                nonGridKey = nonGridKey + "-latest";
            }
            if ((nonGridObject = this.getObject(s3, nonGridKey)) != null) {
                try {
                    Bot bot = this.toBot(nonGridObject);
                    bot.setEnterpriseId(enterpriseId);
                    this.save(s3, fullKey, JsonOps.toJsonString(bot), "AWS S3 putObject result of Bot data - {}");
                    return bot;
                }
                catch (Exception e) {
                    log.error("Failed to save a new Bot data for enterprise_id: {}, team_id: {}", (Object)enterpriseId, (Object)teamId);
                }
            }
        }
        s3Object = this.getObject(s3, fullKey);
        try {
            return this.toBot(s3Object);
        }
        catch (IOException e) {
            log.error("Failed to load Bot data for enterprise_id: {}, team_id: {}", (Object)enterpriseId, (Object)teamId);
            return null;
        }
    }

    @Override
    public Installer findInstaller(String enterpriseId, String teamId, String userId) {
        ResponseBytes<GetObjectResponse> s3Object;
        String fullKey;
        S3Client s3 = this.createS3Client();
        if (enterpriseId != null) {
            fullKey = this.getInstallerKey(enterpriseId, null, userId);
            if (this.isHistoricalDataEnabled()) {
                fullKey = fullKey + "-latest";
            }
            if (this.getObjectMetadata(s3, fullKey) != null) {
                s3Object = this.getObject(s3, fullKey);
                try {
                    return this.toInstaller(s3Object);
                }
                catch (IOException e) {
                    log.error("Failed to load org-level installation for enterprise_id: {}, user_id: {}", (Object)enterpriseId, (Object)userId);
                }
            }
        }
        fullKey = this.getInstallerKey(enterpriseId, teamId, userId);
        if (this.isHistoricalDataEnabled()) {
            fullKey = fullKey + "-latest";
        }
        if (this.getObjectMetadata(s3, fullKey) == null && enterpriseId != null) {
            ResponseBytes<GetObjectResponse> nonGridObject;
            String nonGridKey = this.getInstallerKey(null, teamId, userId);
            if (this.isHistoricalDataEnabled()) {
                nonGridKey = nonGridKey + "-latest";
            }
            if ((nonGridObject = this.getObject(s3, nonGridKey)) != null) {
                try {
                    Installer installer = this.toInstaller(nonGridObject);
                    installer.setEnterpriseId(enterpriseId);
                    this.saveInstallerAndBot(installer);
                    return installer;
                }
                catch (Exception e) {
                    log.error("Failed to save a new Installer data for enterprise_id: {}, team_id: {}, user_id: {}", new Object[]{enterpriseId, teamId, userId});
                }
            }
        }
        s3Object = this.getObject(s3, fullKey);
        try {
            return this.toInstaller(s3Object);
        }
        catch (Exception e) {
            log.error("Failed to save a new Installer data for enterprise_id: {}, team_id: {}, user_id: {}", new Object[]{enterpriseId, teamId, userId});
            return null;
        }
    }

    @Override
    public void deleteAll(String enterpriseId, String teamId) {
        S3Client s3 = this.createS3Client();
        this.deleteAllObjectsMatchingPrefix(s3, "installer/" + Optional.ofNullable(enterpriseId).orElse("none") + "-" + Optional.ofNullable(teamId).orElse("none"));
        this.deleteAllObjectsMatchingPrefix(s3, "bot/" + Optional.ofNullable(enterpriseId).orElse("none") + "-" + Optional.ofNullable(teamId).orElse("none"));
    }

    private void deleteAllObjectsMatchingPrefix(S3Client s3, String prefix) {
        for (S3Object obj : s3.listObjectsV2((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName).prefix(prefix).build()).contents()) {
            if (log.isDebugEnabled()) {
                log.debug("Going to delete an object (bucket: {}, key: {})", (Object)this.bucketName, (Object)obj.key());
            }
            s3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(obj.key()).build());
        }
    }

    private Map<String, String> getObjectMetadata(S3Client s3, String fullKey) {
        try {
            return s3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucketName).key(fullKey).build()).metadata();
        }
        catch (S3Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Amazon S3 object metadata not found (key: {}, S3Exception: {})", (Object)fullKey, (Object)e.toString());
            }
            return null;
        }
    }

    private ResponseBytes<GetObjectResponse> getObject(S3Client s3, String fullKey) {
        try {
            return (ResponseBytes)s3.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(fullKey).build(), ResponseTransformer.toBytes());
        }
        catch (S3Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Amazon S3 object metadata not found (key: {}, S3Exception: {})", (Object)fullKey, (Object)e.toString());
            }
            return null;
        }
    }

    private Bot toBot(ResponseBytes<GetObjectResponse> s3Object) throws IOException {
        if (s3Object == null) {
            return null;
        }
        String json = s3Object.asString(StandardCharsets.UTF_8);
        return JsonOps.fromJson(json, DefaultBot.class);
    }

    private Installer toInstaller(ResponseBytes<GetObjectResponse> s3Object) throws IOException {
        if (s3Object == null) {
            return null;
        }
        String json = s3Object.asString(StandardCharsets.UTF_8);
        return JsonOps.fromJson(json, DefaultInstaller.class);
    }

    protected AwsCredentials createCredentials(AwsCredentialsProvider provider) {
        return provider.resolveCredentials();
    }

    protected S3Client createS3Client() {
        return (S3Client)((S3ClientBuilder)S3Client.builder().credentialsProvider(this.credentialsProvider)).build();
    }

    private String getInstallerKey(Installer i) {
        return this.getInstallerKey(i.getEnterpriseId(), i.getTeamId(), i.getInstallerUserId());
    }

    private String getInstallerKey(String enterpriseId, String teamId, String userId) {
        return "installer/" + Optional.ofNullable(enterpriseId).orElse("none") + "-" + Optional.ofNullable(teamId).orElse("none") + "-" + userId;
    }

    private String getBotKey(Installer i) {
        return this.getBotKey(i.getEnterpriseId(), i.getTeamId());
    }

    private String getBotKey(String enterpriseId, String teamId) {
        return "bot/" + Optional.ofNullable(enterpriseId).orElse("none") + "-" + Optional.ofNullable(teamId).orElse("none");
    }
}

