/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slack.api.bolt.context.builtin.EventContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.bolt.util.EventsApiPayloadParser;
import com.slack.api.model.assistant.AssistantThreadContext;
import com.slack.api.util.json.GsonFactory;
import java.util.Locale;
import lombok.Generated;

public class EventRequest
extends Request<EventContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final String eventType;
    private final String eventSubtype;
    private final EventContext context = new EventContext();

    public EventRequest(String requestBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        JsonObject payload = ((JsonElement)GsonFactory.createSnakeCase().fromJson(requestBody, JsonElement.class)).getAsJsonObject();
        JsonObject event = payload.get("event").getAsJsonObject();
        this.eventType = event.get("type").getAsString();
        this.eventSubtype = event.get("subtype") != null && !event.get("subtype").isJsonNull() ? event.get("subtype").getAsString() : null;
        String enterpriseId = null;
        String teamId = null;
        if (payload.get("authorizations") != null && !payload.get("authorizations").isJsonNull()) {
            JsonObject authorization;
            JsonArray authorizations = payload.get("authorizations").getAsJsonArray();
            if (authorizations.size() > 0 && (authorization = authorizations.get(0).getAsJsonObject()) != null && !authorization.isJsonNull()) {
                JsonElement teamIdElement;
                JsonElement enterpriseIdElement = authorization.get("enterprise_id");
                if (enterpriseIdElement != null && !enterpriseIdElement.isJsonNull()) {
                    enterpriseId = enterpriseIdElement.getAsString();
                }
                if ((teamIdElement = authorization.get("team_id")) != null && !teamIdElement.isJsonNull()) {
                    teamId = teamIdElement.getAsString();
                }
            }
        } else {
            JsonElement teamIdElement;
            JsonElement enterpriseIdElement = payload.get("enterprise_id");
            if (enterpriseIdElement != null && !enterpriseIdElement.isJsonNull()) {
                enterpriseId = enterpriseIdElement.getAsString();
            }
            if ((teamIdElement = payload.get("team_id")) != null && !teamIdElement.isJsonNull()) {
                teamId = teamIdElement.getAsString();
            }
        }
        this.getContext().setEnterpriseId(enterpriseId);
        this.getContext().setTeamId(teamId);
        this.getContext().setRequestUserId(EventRequest.extractRequestUserId(payload));
        if (this.headers != null && this.headers.getNames().size() > 0) {
            for (String name : this.headers.getNames()) {
                String normalizedName = name.toLowerCase(Locale.ENGLISH);
                String value = this.headers.getFirstValue(name);
                if (normalizedName.equals("x-slack-retry-num")) {
                    try {
                        Integer num = Integer.parseInt(value);
                        this.getContext().setRetryNum(num);
                    }
                    catch (NumberFormatException num) {
                        // empty catch block
                    }
                }
                if (!normalizedName.equals("x-slack-retry-reason")) continue;
                this.getContext().setRetryReason(value);
            }
        }
        if (event.get("channel") != null && event.get("channel").isJsonPrimitive()) {
            this.getContext().setChannelId(event.get("channel").getAsString());
        } else if (event.get("channel_id") != null) {
            this.getContext().setChannelId(event.get("channel_id").getAsString());
        }
        if (event.get("assistant_thread") != null) {
            this.getContext().setAssistantThreadEvent(true);
            JsonObject thread = event.get("assistant_thread").getAsJsonObject();
            String channelId = thread.get("channel_id").getAsString();
            this.getContext().setChannelId(channelId);
            String threadTs = thread.get("thread_ts").getAsString();
            this.getContext().setThreadTs(threadTs);
            JsonObject context = thread.get("context").getAsJsonObject();
            if (context != null) {
                AssistantThreadContext threadContext = AssistantThreadContext.builder().enterpriseId(context.get("enterprise_id") != null ? context.get("enterprise_id").getAsString() : null).teamId(context.get("team_id") != null ? context.get("team_id").getAsString() : null).channelId(context.get("channel_id") != null ? context.get("channel_id").getAsString() : null).build();
                this.getContext().setThreadContext(threadContext);
            }
        } else if (this.eventType != null && this.eventType.equals("message") && EventsApiPayloadParser.isMessageEventInAssistantThread(event)) {
            this.getContext().setAssistantThreadEvent(true);
            this.getContext().setChannelId(event.get("channel").getAsString());
            if (event.get("thread_ts") != null) {
                this.getContext().setThreadTs(event.get("thread_ts").getAsString());
            } else if (event.get("message") != null && event.get("message").getAsJsonObject().get("thread_ts") != null) {
                this.getContext().setThreadTs(event.get("message").getAsJsonObject().get("thread_ts").getAsString());
            }
        }
        if (this.eventType != null && this.eventType.equals("function_executed")) {
            if (event.get("bot_access_token") != null) {
                String functionBotAccessToken = event.get("bot_access_token").getAsString();
                this.getContext().setFunctionBotAccessToken(functionBotAccessToken);
            }
            if (event.get("function_execution_id") != null) {
                String functionExecutionId = event.get("function_execution_id").getAsString();
                this.getContext().setFunctionExecutionId(functionExecutionId);
            }
        }
    }

    private static String extractRequestUserId(JsonObject payload) {
        if (payload.get("user") != null) {
            JsonElement userId;
            if (payload.get("user").isJsonPrimitive()) {
                return payload.get("user").getAsString();
            }
            if (payload.get("user").isJsonObject() && (userId = payload.get("user").getAsJsonObject().get("id")) != null) {
                return userId.getAsString();
            }
        }
        if (payload.get("user_id") != null) {
            return payload.get("user_id").getAsString();
        }
        if (payload.get("event") != null) {
            return EventRequest.extractRequestUserId(payload.get("event").getAsJsonObject());
        }
        if (payload.get("message") != null) {
            return EventRequest.extractRequestUserId(payload.get("message").getAsJsonObject());
        }
        if (payload.get("previous_message") != null) {
            return EventRequest.extractRequestUserId(payload.get("previous_message").getAsJsonObject());
        }
        return null;
    }

    private boolean isMessageEventInAssistantThread(JsonObject event) {
        if (event.get("channel_type") != null && event.get("channel_type").getAsString().equals("im")) {
            if (event.get("thread_ts") != null) {
                return true;
            }
            if (event.get("message") != null) {
                return this.isAssistantThreadMessageSubEvent(event, "message");
            }
            if (event.get("previous_message") != null) {
                return this.isAssistantThreadMessageSubEvent(event, "previous_message");
            }
        }
        return false;
    }

    private boolean isAssistantThreadMessageSubEvent(JsonObject event, String message) {
        JsonElement subtype = event.get(message).getAsJsonObject().get("subtype");
        return subtype != null && subtype.getAsString().equals("assistant_app_thread") || event.get(message).getAsJsonObject().get("thread_ts") != null;
    }

    @Override
    public EventContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.Event;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventTypeAndSubtype() {
        if (!this.eventType.equals("message") || this.eventSubtype == null) {
            return this.eventType;
        }
        return this.eventType + ":" + this.eventSubtype;
    }

    @Override
    public String getResponseUrl() {
        return null;
    }

    @Override
    @Generated
    public String toString() {
        return "EventRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", eventType=" + this.getEventType() + ", eventSubtype=" + this.eventSubtype + ", context=" + this.getContext() + ")";
    }
}

