/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.interactive_components.payload.MessageShortcutPayload;
import com.slack.api.bolt.context.builtin.MessageShortcutContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class MessageShortcutRequest
extends Request<MessageShortcutContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final MessageShortcutPayload payload;
    private MessageShortcutContext context = new MessageShortcutContext();

    public MessageShortcutRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (MessageShortcutPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, MessageShortcutPayload.class);
        this.getContext().setResponseUrl(this.payload.getResponseUrl());
        this.getContext().setTriggerId(this.payload.getTriggerId());
        if (this.payload.getEnterprise() != null) {
            this.getContext().setEnterpriseId(this.payload.getEnterprise().getId());
        } else if (this.payload.getTeam() != null) {
            this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        }
        if (this.payload.getTeam() != null && this.payload.getTeam().getId() != null) {
            this.getContext().setTeamId(this.payload.getTeam().getId());
        } else if (this.payload.getUser() != null && this.payload.getUser().getTeamId() != null) {
            this.getContext().setTeamId(this.payload.getUser().getTeamId());
        }
        if (this.payload.getChannel() != null) {
            this.getContext().setChannelId(this.payload.getChannel().getId());
        }
        this.getContext().setRequestUserId(this.payload.getUser().getId());
    }

    @Override
    public MessageShortcutContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.MessageShortcut;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public MessageShortcutPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getResponseUrl() {
        return this.getPayload() != null ? this.getPayload().getResponseUrl() : null;
    }

    @Override
    @Generated
    public String toString() {
        return "MessageShortcutRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

