/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.slash_commands.SlashCommandPayloadParser;
import com.slack.api.app_backend.slash_commands.payload.SlashCommandPayload;
import com.slack.api.bolt.context.builtin.SlashCommandContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import lombok.Generated;

public class SlashCommandRequest
extends Request<SlashCommandContext> {
    private static final SlashCommandPayloadParser PAYLOAD_PARSER = new SlashCommandPayloadParser();
    private final SlashCommandContext context = new SlashCommandContext();
    private final String requestBody;
    private final RequestHeaders headers;
    private final SlashCommandPayload payload;

    public SlashCommandRequest(String requestBody, RequestHeaders headers) {
        this(requestBody, PAYLOAD_PARSER.parse(requestBody), headers);
    }

    public SlashCommandRequest(String requestBody, SlashCommandPayload payload, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = payload;
        this.getContext().setResponseUrl(payload.getResponseUrl());
        this.getContext().setTriggerId(payload.getTriggerId());
        this.getContext().setChannelId(payload.getChannelId());
        this.getContext().setEnterpriseId(payload.getEnterpriseId());
        this.getContext().setTeamId(payload.getTeamId());
        this.getContext().setRequestUserId(payload.getUserId());
    }

    @Override
    public SlashCommandContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.Command;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public SlashCommandPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getResponseUrl() {
        return this.getPayload() != null ? this.getPayload().getResponseUrl() : null;
    }

    @Override
    @Generated
    public String toString() {
        return "SlashCommandRequest(super=" + super.toString() + ", context=" + this.getContext() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ")";
    }
}

