/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.views.payload.ViewClosedPayload;
import com.slack.api.bolt.context.builtin.DefaultContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class ViewClosedRequest
extends Request<DefaultContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final ViewClosedPayload payload;
    private DefaultContext context = new DefaultContext();

    public ViewClosedRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (ViewClosedPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, ViewClosedPayload.class);
        if (this.payload.getEnterprise() != null) {
            this.getContext().setEnterpriseId(this.payload.getEnterprise().getId());
        } else if (this.payload.getTeam() != null) {
            this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        }
        if (this.payload.getTeam() != null) {
            this.getContext().setTeamId(this.payload.getTeam().getId());
        }
        this.getContext().setRequestUserId(this.payload.getUser().getId());
    }

    @Override
    public DefaultContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.ViewClosed;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public ViewClosedPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getResponseUrl() {
        return null;
    }

    @Override
    @Generated
    public String toString() {
        return "ViewClosedRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

