/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin.oauth.default_impl;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.builtin.oauth.OAuthV2AccessErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.view.OAuthRedirectUriPageRenderer;
import com.slack.api.methods.response.oauth.OAuthV2AccessResponse;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthV2DefaultAccessErrorHandler
implements OAuthV2AccessErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuthV2DefaultAccessErrorHandler.class);
    private final AppConfig appConfig;
    private final OAuthRedirectUriPageRenderer pageRenderer;

    public OAuthV2DefaultAccessErrorHandler(AppConfig appConfig) {
        this.appConfig = appConfig;
        this.pageRenderer = appConfig.getOAuthRedirectUriPageRenderer();
    }

    @Override
    public Response handle(OAuthCallbackRequest req, Response response, OAuthV2AccessResponse apiResponse) {
        log.error("Failed to run an oauth.v2.access API call: {} - {}", (Object)apiResponse.getError(), (Object)apiResponse);
        String url = req.getContext().getOauthCancellationUrl();
        if (url == null) {
            String reason = apiResponse.getError();
            response.setStatusCode(200);
            response.setBody(this.pageRenderer.renderFailurePage(this.appConfig.getOauthInstallRequestURI(), reason));
            response.setContentType("text/html; charset=utf-8");
        } else {
            response.setStatusCode(302);
            response.getHeaders().put("Location", Arrays.asList(url));
        }
        return response;
    }
}

