/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware.builtin;

import com.slack.api.bolt.handler.builtin.WorkflowStepEditHandler;
import com.slack.api.bolt.handler.builtin.WorkflowStepExecuteHandler;
import com.slack.api.bolt.handler.builtin.WorkflowStepSaveHandler;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.MiddlewareChain;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.builtin.WorkflowStepEditRequest;
import com.slack.api.bolt.request.builtin.WorkflowStepExecuteRequest;
import com.slack.api.bolt.request.builtin.WorkflowStepSaveRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.util.thread.ExecutorServiceFactory;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStep
implements Middleware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowStep.class);
    private String callbackId;
    private Pattern callbackIdPattern;
    private WorkflowStepEditHandler edit;
    private WorkflowStepSaveHandler save;
    private WorkflowStepExecuteHandler execute;
    private ExecutorService executorService;

    protected void finalize() throws Throwable {
        this.executorService.shutdown();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response apply(Request req, Response resp, MiddlewareChain chain) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("The WorkflowStep middleware started (request type: {})", (Object)req.getRequestType());
        }
        try {
            switch (req.getRequestType()) {
                case WorkflowStepEdit: {
                    Request request = (WorkflowStepEditRequest)req;
                    String requestCallbackId = ((WorkflowStepEditRequest)request).getPayload().getCallbackId();
                    if (requestCallbackId != null) {
                        if (this.isStepCallbackId(requestCallbackId)) {
                            Object RESP = this.edit.apply(request, ((WorkflowStepEditRequest)request).getContext());
                            return RESP;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("callback_id: {} didn't match in the WorkflowStep middleware", (Object)requestCallbackId);
                        }
                    }
                }
                case WorkflowStepSave: {
                    Request request = (WorkflowStepSaveRequest)req;
                    String requestCallbackId = ((WorkflowStepSaveRequest)request).getPayload().getView().getCallbackId();
                    if (requestCallbackId != null) {
                        if (this.isStepCallbackId(requestCallbackId)) {
                            Object RESP = this.save.apply(request, ((WorkflowStepSaveRequest)request).getContext());
                            return RESP;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("callback_id: {} didn't match in the WorkflowStep middleware", (Object)requestCallbackId);
                        }
                    }
                }
                case WorkflowStepExecute: {
                    Request request = (WorkflowStepExecuteRequest)req;
                    String requestCallbackId = ((WorkflowStepExecuteRequest)request).getContext().getCallbackId();
                    if (requestCallbackId == null) break;
                    if (this.isStepCallbackId(requestCallbackId)) {
                        this.executorService.execute(() -> this.lambda$apply$0((WorkflowStepExecuteRequest)request, requestCallbackId));
                        Response response = new Response();
                        return response;
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug("callback_id: {} didn't match in the WorkflowStep middleware", (Object)requestCallbackId);
                }
            }
            Response response = chain.next(req);
            return response;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("The WorkflowStep middleware completed (request type: {})", (Object)req.getRequestType());
            }
        }
    }

    protected boolean isStepCallbackId(String requestCallbackId) {
        return this.getCallbackIdPattern() != null && this.getCallbackIdPattern().matcher(requestCallbackId).matches() || this.getCallbackId().equals(requestCallbackId);
    }

    protected static ExecutorService buildDefaultExecutorService() {
        String threadGroupName = WorkflowStep.class.getSimpleName();
        int poolSize = 3;
        ExecutorService service = ExecutorServiceFactory.createDaemonThreadPoolExecutor((String)threadGroupName, (int)poolSize);
        return service;
    }

    @Generated
    private static ExecutorService $default$executorService() {
        return WorkflowStep.buildDefaultExecutorService();
    }

    @Generated
    public static WorkflowStepBuilder builder() {
        return new WorkflowStepBuilder();
    }

    @Generated
    public String getCallbackId() {
        return this.callbackId;
    }

    @Generated
    public Pattern getCallbackIdPattern() {
        return this.callbackIdPattern;
    }

    @Generated
    public WorkflowStepEditHandler getEdit() {
        return this.edit;
    }

    @Generated
    public WorkflowStepSaveHandler getSave() {
        return this.save;
    }

    @Generated
    public WorkflowStepExecuteHandler getExecute() {
        return this.execute;
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Generated
    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    @Generated
    public void setCallbackIdPattern(Pattern callbackIdPattern) {
        this.callbackIdPattern = callbackIdPattern;
    }

    @Generated
    public void setEdit(WorkflowStepEditHandler edit) {
        this.edit = edit;
    }

    @Generated
    public void setSave(WorkflowStepSaveHandler save) {
        this.save = save;
    }

    @Generated
    public void setExecute(WorkflowStepExecuteHandler execute) {
        this.execute = execute;
    }

    @Generated
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Generated
    public WorkflowStep() {
        this.executorService = WorkflowStep.$default$executorService();
    }

    @Generated
    public WorkflowStep(String callbackId, Pattern callbackIdPattern, WorkflowStepEditHandler edit, WorkflowStepSaveHandler save, WorkflowStepExecuteHandler execute, ExecutorService executorService) {
        this.callbackId = callbackId;
        this.callbackIdPattern = callbackIdPattern;
        this.edit = edit;
        this.save = save;
        this.execute = execute;
        this.executorService = executorService;
    }

    private /* synthetic */ void lambda$apply$0(WorkflowStepExecuteRequest request, String requestCallbackId) {
        try {
            this.execute.apply(request, request.getContext());
        }
        catch (Exception e) {
            log.error("Failed to run listener for a workflow_step_execute event ({}): {}", new Object[]{requestCallbackId, e.getMessage(), e});
        }
    }

    @Generated
    public static class WorkflowStepBuilder {
        @Generated
        private String callbackId;
        @Generated
        private Pattern callbackIdPattern;
        @Generated
        private WorkflowStepEditHandler edit;
        @Generated
        private WorkflowStepSaveHandler save;
        @Generated
        private WorkflowStepExecuteHandler execute;
        @Generated
        private boolean executorService$set;
        @Generated
        private ExecutorService executorService$value;

        @Generated
        WorkflowStepBuilder() {
        }

        @Generated
        public WorkflowStepBuilder callbackId(String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        @Generated
        public WorkflowStepBuilder callbackIdPattern(Pattern callbackIdPattern) {
            this.callbackIdPattern = callbackIdPattern;
            return this;
        }

        @Generated
        public WorkflowStepBuilder edit(WorkflowStepEditHandler edit) {
            this.edit = edit;
            return this;
        }

        @Generated
        public WorkflowStepBuilder save(WorkflowStepSaveHandler save) {
            this.save = save;
            return this;
        }

        @Generated
        public WorkflowStepBuilder execute(WorkflowStepExecuteHandler execute) {
            this.execute = execute;
            return this;
        }

        @Generated
        public WorkflowStepBuilder executorService(ExecutorService executorService) {
            this.executorService$value = executorService;
            this.executorService$set = true;
            return this;
        }

        @Generated
        public WorkflowStep build() {
            ExecutorService executorService$value = this.executorService$value;
            if (!this.executorService$set) {
                executorService$value = WorkflowStep.$default$executorService();
            }
            return new WorkflowStep(this.callbackId, this.callbackIdPattern, this.edit, this.save, this.execute, executorService$value);
        }

        @Generated
        public String toString() {
            return "WorkflowStep.WorkflowStepBuilder(callbackId=" + this.callbackId + ", callbackIdPattern=" + this.callbackIdPattern + ", edit=" + this.edit + ", save=" + this.save + ", execute=" + this.execute + ", executorService$value=" + this.executorService$value + ")";
        }
    }
}

