/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.views.payload.WorkflowStepSavePayload;
import com.slack.api.bolt.context.builtin.WorkflowStepSaveContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class WorkflowStepSaveRequest
extends Request<WorkflowStepSaveContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final WorkflowStepSavePayload payload;
    private WorkflowStepSaveContext context = new WorkflowStepSaveContext();

    public WorkflowStepSaveRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (WorkflowStepSavePayload)GsonFactory.createSnakeCase().fromJson(payloadBody, WorkflowStepSavePayload.class);
        if (this.payload.getEnterprise() != null) {
            this.getContext().setEnterpriseId(this.payload.getEnterprise().getId());
        } else if (this.payload.getTeam() != null) {
            this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        }
        if (this.payload.getTeam() != null) {
            this.getContext().setTeamId(this.payload.getTeam().getId());
        }
        this.getContext().setRequestUserId(this.payload.getUser().getId());
        this.getContext().setWorkflowStepEditId(this.payload.getWorkflowStep().getWorkflowStepEditId());
    }

    @Override
    public WorkflowStepSaveContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.WorkflowStepSave;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getResponseUrl() {
        return null;
    }

    public WorkflowStepSavePayload getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public String toString() {
        return "WorkflowStepSaveRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

