/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt;

import com.google.gson.Gson;
import com.slack.api.Slack;
import com.slack.api.app_backend.SlackSignature;
import com.slack.api.app_backend.events.EventHandler;
import com.slack.api.app_backend.events.EventsDispatcher;
import com.slack.api.app_backend.events.EventsDispatcherFactory;
import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.Initializer;
import com.slack.api.bolt.WebEndpoint;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.handler.BoltEventHandler;
import com.slack.api.bolt.handler.WebEndpointHandler;
import com.slack.api.bolt.handler.builtin.AttachmentActionHandler;
import com.slack.api.bolt.handler.builtin.BlockActionHandler;
import com.slack.api.bolt.handler.builtin.BlockSuggestionHandler;
import com.slack.api.bolt.handler.builtin.DefaultAppUninstalledEventHandler;
import com.slack.api.bolt.handler.builtin.DefaultTokensRevokedEventHandler;
import com.slack.api.bolt.handler.builtin.DialogCancellationHandler;
import com.slack.api.bolt.handler.builtin.DialogSubmissionHandler;
import com.slack.api.bolt.handler.builtin.DialogSuggestionHandler;
import com.slack.api.bolt.handler.builtin.GlobalShortcutHandler;
import com.slack.api.bolt.handler.builtin.MessageShortcutHandler;
import com.slack.api.bolt.handler.builtin.SlashCommandHandler;
import com.slack.api.bolt.handler.builtin.ViewClosedHandler;
import com.slack.api.bolt.handler.builtin.ViewSubmissionHandler;
import com.slack.api.bolt.handler.builtin.WorkflowStepEditHandler;
import com.slack.api.bolt.handler.builtin.WorkflowStepExecuteHandler;
import com.slack.api.bolt.handler.builtin.WorkflowStepSaveHandler;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.builtin.IgnoringSelfEvents;
import com.slack.api.bolt.middleware.builtin.MultiTeamsAuthorization;
import com.slack.api.bolt.middleware.builtin.RequestVerification;
import com.slack.api.bolt.middleware.builtin.SSLCheck;
import com.slack.api.bolt.middleware.builtin.SingleTeamAuthorization;
import com.slack.api.bolt.middleware.builtin.WorkflowStep;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.bolt.service.OAuthCallbackService;
import com.slack.api.bolt.service.OAuthStateService;
import com.slack.api.bolt.service.OpenIDConnectNonceService;
import com.slack.api.bolt.service.Service;
import com.slack.api.bolt.service.builtin.ClientOnlyOAuthStateService;
import com.slack.api.bolt.service.builtin.DefaultOAuthCallbackService;
import com.slack.api.bolt.service.builtin.FileInstallationService;
import com.slack.api.bolt.service.builtin.NullOpenIDConnectNonceService;
import com.slack.api.bolt.service.builtin.oauth.OAuthAccessErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthExceptionHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthStateErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthSuccessHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthV2AccessErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthV2SuccessHandler;
import com.slack.api.bolt.service.builtin.oauth.OpenIDConnectErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.OpenIDConnectSuccessHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultAccessErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultExceptionHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultStateErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultSuccessHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthV2DefaultAccessErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthV2DefaultSuccessHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OpenIDConnectDefaultErrorHandler;
import com.slack.api.bolt.util.EventsApiPayloadParser;
import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.auth.AuthTestResponse;
import com.slack.api.model.event.AppUninstalledEvent;
import com.slack.api.model.event.Event;
import com.slack.api.model.event.MessageEvent;
import com.slack.api.model.event.TokensRevokedEvent;
import com.slack.api.util.json.GsonFactory;
import com.slack.api.util.thread.ExecutorServiceFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(App.class);
    private static final Gson GSON = GsonFactory.createSnakeCase();
    private final AppConfig appConfig;
    private final Slack slack;
    private final MethodsClient client;
    private final ExecutorService executorService;
    private List<Middleware> middlewareList;
    private Status status;
    private final Map<Pattern, SlashCommandHandler> slashCommandHandlers = new HashMap<Pattern, SlashCommandHandler>();
    private final Map<String, BoltEventHandler<Event>> eventHandlers = new HashMap<String, BoltEventHandler<Event>>();
    private final EventsDispatcher eventsDispatcher = EventsDispatcherFactory.getInstance();
    private final Map<Pattern, BlockActionHandler> blockActionHandlers = new HashMap<Pattern, BlockActionHandler>();
    private final Map<Pattern, BlockSuggestionHandler> blockSuggestionHandlers = new HashMap<Pattern, BlockSuggestionHandler>();
    private final Map<Pattern, ViewSubmissionHandler> viewSubmissionHandlers = new HashMap<Pattern, ViewSubmissionHandler>();
    private final Map<Pattern, ViewClosedHandler> viewClosedHandlers = new HashMap<Pattern, ViewClosedHandler>();
    private final Map<Pattern, GlobalShortcutHandler> globalShortcutHandlers = new HashMap<Pattern, GlobalShortcutHandler>();
    private final Map<Pattern, MessageShortcutHandler> messageShortcutHandlers = new HashMap<Pattern, MessageShortcutHandler>();
    private final Map<Pattern, WorkflowStepEditHandler> workflowStepEditHandlers = new HashMap<Pattern, WorkflowStepEditHandler>();
    private final Map<Pattern, WorkflowStepSaveHandler> workflowStepSaveHandlers = new HashMap<Pattern, WorkflowStepSaveHandler>();
    private final Map<Pattern, WorkflowStepExecuteHandler> workflowStepExecuteHandlers = new HashMap<Pattern, WorkflowStepExecuteHandler>();
    private final Map<Pattern, AttachmentActionHandler> attachmentActionHandlers = new HashMap<Pattern, AttachmentActionHandler>();
    private final Map<Pattern, DialogSubmissionHandler> dialogSubmissionHandlers = new HashMap<Pattern, DialogSubmissionHandler>();
    private final Map<Pattern, DialogSuggestionHandler> dialogSuggestionHandlers = new HashMap<Pattern, DialogSuggestionHandler>();
    private final Map<Pattern, DialogCancellationHandler> dialogCancellationHandlers = new HashMap<Pattern, DialogCancellationHandler>();
    private InstallationService installationService;
    private DefaultTokensRevokedEventHandler tokensRevokedEventHandler;
    private DefaultAppUninstalledEventHandler appUninstalledEventHandler;
    private OAuthStateService oAuthStateService;
    private OpenIDConnectNonceService openIDConnectNonceService;
    private OAuthSuccessHandler oAuthSuccessHandler;
    private OAuthV2SuccessHandler oAuthV2SuccessHandler;
    private OpenIDConnectSuccessHandler openIDConnectSuccessHandler;
    private OAuthErrorHandler oAuthErrorHandler;
    private OAuthAccessErrorHandler oAuthAccessErrorHandler;
    private OAuthV2AccessErrorHandler oAuthV2AccessErrorHandler;
    private OpenIDConnectErrorHandler openIDConnectErrorHandler;
    private OAuthStateErrorHandler oAuthStateErrorHandler;
    private OAuthExceptionHandler oAuthExceptionHandler;
    private OAuthCallbackService oAuthCallbackService;
    private final Map<WebEndpoint, WebEndpointHandler> webEndpointHandlers = new HashMap<WebEndpoint, WebEndpointHandler>();
    private final Map<String, Initializer> componentNameToInitializer = new HashMap<String, Initializer>();
    private final AtomicBoolean neverStarted = new AtomicBoolean(true);

    protected List<Middleware> buildDefaultMiddlewareList(AppConfig config) {
        ArrayList<Middleware> middlewareList = new ArrayList<Middleware>();
        if (config.isSslCheckEnabled()) {
            middlewareList.add(new SSLCheck(config.getVerificationToken()));
        }
        if (config.isRequestVerificationEnabled()) {
            String signingSecret = config.getSigningSecret();
            if (signingSecret == null || signingSecret.trim().isEmpty()) {
                signingSecret = "---";
            }
            SlackSignature.Verifier verifier = new SlackSignature.Verifier(new SlackSignature.Generator(signingSecret));
            RequestVerification requestVerification = new RequestVerification(verifier);
            middlewareList.add(requestVerification);
        }
        if (config.isDistributedApp()) {
            middlewareList.add(new MultiTeamsAuthorization(config, this.installationService));
        } else if (config.getSingleTeamBotToken() != null) {
            try {
                AuthTestResponse initialAuthTest = this.client().authTest(r -> r.token(config.getSingleTeamBotToken()));
                if (initialAuthTest == null || !initialAuthTest.isOk()) {
                    String error = initialAuthTest != null ? initialAuthTest.getError() : "";
                    String message = "The token is invalid (auth.test error: " + error + ")";
                    throw new IllegalArgumentException(message);
                }
                middlewareList.add(new SingleTeamAuthorization(config, initialAuthTest, this.installationService));
            }
            catch (SlackApiException | IOException e) {
                String message = "The token is invalid (error: " + e.getMessage() + ")";
                throw new IllegalArgumentException(message);
            }
        } else {
            log.warn("Skipped adding any authorization middleware - you need to call `app.use(new YourOwnMultiTeamsAuthorization())`");
        }
        if (config.isIgnoringSelfEventsEnabled()) {
            middlewareList.add(new IgnoringSelfEvents(config.getSlack().getConfig()));
        }
        return middlewareList;
    }

    public BoltEventHandler<TokensRevokedEvent> defaultTokensRevokedEventHandler() {
        return this.tokensRevokedEventHandler;
    }

    public BoltEventHandler<AppUninstalledEvent> defaultAppUninstalledEventHandler() {
        return this.appUninstalledEventHandler;
    }

    public App enableTokenRevocationHandlers() {
        this.event(TokensRevokedEvent.class, this.defaultTokensRevokedEventHandler());
        this.event(AppUninstalledEvent.class, this.defaultAppUninstalledEventHandler());
        return this;
    }

    private void initOAuthServicesIfNecessary() {
        if (this.appConfig.isDistributedApp() && this.appConfig.isOAuthRedirectUriPathEnabled() && this.oAuthCallbackService == null) {
            this.oAuthCallbackService = new DefaultOAuthCallbackService(this.config(), this.oAuthStateService, this.oAuthSuccessHandler, this.oAuthV2SuccessHandler, this.oAuthErrorHandler, this.oAuthStateErrorHandler, this.oAuthAccessErrorHandler, this.oAuthV2AccessErrorHandler, this.oAuthExceptionHandler, this.openIDConnectSuccessHandler, this.openIDConnectErrorHandler);
        }
    }

    public String buildAuthorizeUrl(String state) {
        return this.buildAuthorizeUrl(state, null);
    }

    public String buildAuthorizeUrl(String state, String nonce) {
        AppConfig config = this.config();
        if (config.getClientId() == null || !config.isOpenIDConnectEnabled() && config.getScope() == null || state == null) {
            return null;
        }
        String scope = config.getScope() == null ? "" : config.getScope();
        String redirectUriParam = this.redirectUriQueryParam(this.appConfig);
        if (config.isClassicAppPermissionsEnabled()) {
            return "https://slack.com/oauth/authorize?client_id=" + config.getClientId() + "&scope=" + scope + "&state=" + state + redirectUriParam;
        }
        if (config.isOpenIDConnectEnabled()) {
            return "https://slack.com/openid/connect/authorize?client_id=" + config.getClientId() + "&response_type=code&scope=" + (config.getUserScope() != null ? config.getUserScope() : scope) + "&state=" + state + redirectUriParam + (nonce != null ? "&nonce=" + nonce : "");
        }
        String userScope = config.getUserScope() == null ? "" : config.getUserScope();
        return "https://slack.com/oauth/v2/authorize?client_id=" + config.getClientId() + "&scope=" + scope + "&user_scope=" + userScope + "&state=" + state + redirectUriParam;
    }

    @Deprecated
    public String getOauthInstallationUrl(String state) {
        return this.buildAuthorizeUrl(state);
    }

    private String redirectUriQueryParam(AppConfig appConfig) {
        if (appConfig.getRedirectUri() == null) {
            return "";
        }
        try {
            String urlEncodedRedirectUri = URLEncoder.encode(appConfig.getRedirectUri(), StandardCharsets.UTF_8.name());
            return String.format("&redirect_uri=%s", urlEncodedRedirectUri);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public Map<WebEndpoint, WebEndpointHandler> getWebEndpointHandlers() {
        return this.webEndpointHandlers;
    }

    public App() {
        this(new AppConfig());
    }

    public App(AppConfig appConfig) {
        this(appConfig, null);
        this.asOAuthApp(false);
    }

    public App(AppConfig appConfig, List<Middleware> middlewareList) {
        this(appConfig, appConfig.getSlack() != null ? appConfig.getSlack() : Slack.getInstance(), middlewareList);
        this.status = Status.Stopped;
    }

    public App(AppConfig appConfig, Slack slack, List<Middleware> middlewareList) {
        this.appConfig = appConfig;
        this.slack = slack;
        this.client = this.slack.methods();
        this.executorService = ExecutorServiceFactory.createDaemonThreadPoolExecutor((String)"bolt-app-threads", (int)this.appConfig.getThreadPoolSize());
        this.middlewareList = middlewareList;
        this.oAuthStateService = new ClientOnlyOAuthStateService();
        this.openIDConnectNonceService = new NullOpenIDConnectNonceService();
        this.installationService = new FileInstallationService(this.appConfig);
        this.tokensRevokedEventHandler = new DefaultTokensRevokedEventHandler(this.installationService, this.executorService);
        this.appUninstalledEventHandler = new DefaultAppUninstalledEventHandler(this.installationService, this.executorService);
        this.oAuthSuccessHandler = new OAuthDefaultSuccessHandler(this.appConfig, this.installationService);
        this.oAuthV2SuccessHandler = new OAuthV2DefaultSuccessHandler(this.config(), this.installationService);
        this.openIDConnectSuccessHandler = (request, response, apiResponse) -> {
            log.warn("This OpenIDConnectSuccessHandler does nothing. Implement your own handler and register it by calling App#openIDConnectSuccess(handler)");
            return response;
        };
        this.oAuthErrorHandler = new OAuthDefaultErrorHandler(this.config());
        this.oAuthAccessErrorHandler = new OAuthDefaultAccessErrorHandler(this.config());
        this.oAuthV2AccessErrorHandler = new OAuthV2DefaultAccessErrorHandler(this.config());
        this.openIDConnectErrorHandler = new OpenIDConnectDefaultErrorHandler(this.config());
        this.oAuthStateErrorHandler = new OAuthDefaultStateErrorHandler(this.config());
        this.oAuthExceptionHandler = new OAuthDefaultExceptionHandler(this.config());
        this.oAuthCallbackService = null;
    }

    public AppConfig config() {
        return this.appConfig;
    }

    public Slack slack() {
        return this.slack;
    }

    public MethodsClient client() {
        return this.client;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Status status() {
        return this.status;
    }

    private void putServiceInitializer(Class<? extends Service> clazz, Initializer initializer) {
        String canonicalName = clazz.getCanonicalName();
        this.initializer(canonicalName, initializer);
    }

    public App initializer(String name, Initializer initializer) {
        this.componentNameToInitializer.put(name, initializer);
        return this;
    }

    public void initialize() {
        this.initOAuthServicesIfNecessary();
        if (this.neverStarted.get() && this.config().isAppInitializersEnabled()) {
            for (Initializer initializer : this.componentNameToInitializer.values()) {
                initializer.accept(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public App start() {
        Status status = this.status;
        synchronized (status) {
            if (this.status == Status.Stopped) {
                if (this.middlewareList == null) {
                    this.middlewareList = this.buildDefaultMiddlewareList(this.appConfig);
                }
                this.initialize();
                if (!this.eventsDispatcher.isEmpty()) {
                    this.eventsDispatcher.start();
                }
                this.neverStarted.set(false);
            }
            this.status = Status.Running;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public App stop() {
        Status status = this.status;
        synchronized (status) {
            if (this.status == Status.Running && this.eventsDispatcher.isRunning()) {
                this.eventsDispatcher.stop();
            }
            this.status = Status.Stopped;
        }
        return this;
    }

    public Response run(Request request) throws Exception {
        LinkedList<Middleware> remaining;
        if (request == null || request.getContext() == null) {
            return Response.builder().statusCode(400).body("Invalid Request").build();
        }
        ((Context)request.getContext()).setSlack(this.slack);
        if (this.neverStarted.get()) {
            this.start();
        }
        if ((remaining = new LinkedList<Middleware>(this.middlewareList)).isEmpty()) {
            return this.runHandler(request);
        }
        Middleware firstMiddleware = remaining.pop();
        return this.runMiddleware(request, Response.ok(), firstMiddleware, remaining);
    }

    public App use(Middleware middleware) {
        if (this.middlewareList == null) {
            this.middlewareList = this.buildDefaultMiddlewareList(this.config());
        }
        this.middlewareList.add(middleware);
        return this;
    }

    public <E extends Event> App event(Class<E> eventClass, BoltEventHandler<E> handler) {
        String eventTypeAndSubtype = EventsApiPayloadParser.getEventTypeAndSubtype(eventClass);
        if (eventTypeAndSubtype == null) {
            throw new IllegalArgumentException("Unexpectedly failed to register the handler");
        }
        if (this.eventHandlers.get(eventTypeAndSubtype) != null) {
            log.warn("Replaced the handler for {}", (Object)eventTypeAndSubtype);
        }
        this.eventHandlers.put(eventTypeAndSubtype, handler);
        return this;
    }

    public App event(EventHandler<?> handler) {
        this.eventsDispatcher.register(handler);
        return this;
    }

    public App message(String pattern, BoltEventHandler<MessageEvent> messageHandler) {
        return this.message(Pattern.compile("^.*" + Pattern.quote(pattern) + ".*$"), messageHandler);
    }

    public App message(Pattern pattern, BoltEventHandler<MessageEvent> messageHandler) {
        this.event(MessageEvent.class, (event, ctx) -> {
            String text = ((MessageEvent)event.getEvent()).getText();
            if (log.isDebugEnabled()) {
                log.debug("Run a message event handler (pattern: {}, text: {})", (Object)pattern, (Object)text);
            }
            if (text != null && pattern.matcher(text).matches()) {
                return messageHandler.apply(event, ctx);
            }
            return ctx.ack();
        });
        return this;
    }

    public App command(String command, SlashCommandHandler handler) {
        return this.command(Pattern.compile("^" + Pattern.quote(command) + "$"), handler);
    }

    public App command(Pattern command, SlashCommandHandler handler) {
        if (this.slashCommandHandlers.get(command) != null) {
            log.warn("Replaced the handler for {}", (Object)command);
        }
        this.slashCommandHandlers.put(command, handler);
        return this;
    }

    public App blockAction(String actionId, BlockActionHandler handler) {
        return this.blockAction(Pattern.compile("^" + Pattern.quote(actionId) + "$"), handler);
    }

    public App blockAction(Pattern actionId, BlockActionHandler handler) {
        if (this.blockActionHandlers.get(actionId) != null) {
            log.warn("Replaced the handler for {}", (Object)actionId);
        }
        this.blockActionHandlers.put(actionId, handler);
        return this;
    }

    public App blockSuggestion(String actionId, BlockSuggestionHandler handler) {
        return this.blockSuggestion(Pattern.compile("^" + Pattern.quote(actionId) + "$"), handler);
    }

    public App blockSuggestion(Pattern actionId, BlockSuggestionHandler handler) {
        if (this.blockSuggestionHandlers.get(actionId) != null) {
            log.warn("Replaced the handler for {}", (Object)actionId);
        }
        this.blockSuggestionHandlers.put(actionId, handler);
        return this;
    }

    public App globalShortcut(String callbackId, GlobalShortcutHandler handler) {
        return this.globalShortcut(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App globalShortcut(Pattern callbackId, GlobalShortcutHandler handler) {
        if (this.globalShortcutHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.globalShortcutHandlers.put(callbackId, handler);
        return this;
    }

    public App messageShortcut(String callbackId, MessageShortcutHandler handler) {
        return this.messageShortcut(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App messageShortcut(Pattern callbackId, MessageShortcutHandler handler) {
        if (this.messageShortcutHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.messageShortcutHandlers.put(callbackId, handler);
        return this;
    }

    public App viewSubmission(String callbackId, ViewSubmissionHandler handler) {
        return this.viewSubmission(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App viewSubmission(Pattern callbackId, ViewSubmissionHandler handler) {
        if (this.viewSubmissionHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.viewSubmissionHandlers.put(callbackId, handler);
        return this;
    }

    public App viewClosed(String callbackId, ViewClosedHandler handler) {
        return this.viewClosed(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App viewClosed(Pattern callbackId, ViewClosedHandler handler) {
        if (this.viewClosedHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.viewClosedHandlers.put(callbackId, handler);
        return this;
    }

    public App step(WorkflowStep step) {
        return this.use(step);
    }

    public App workflowStepEdit(String callbackId, WorkflowStepEditHandler handler) {
        return this.workflowStepEdit(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App workflowStepEdit(Pattern callbackId, WorkflowStepEditHandler handler) {
        if (this.workflowStepEditHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.workflowStepEditHandlers.put(callbackId, handler);
        return this;
    }

    public App workflowStepSave(String callbackId, WorkflowStepSaveHandler handler) {
        return this.workflowStepSave(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App workflowStepSave(Pattern callbackId, WorkflowStepSaveHandler handler) {
        if (this.workflowStepSaveHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.workflowStepSaveHandlers.put(callbackId, handler);
        return this;
    }

    public App workflowStepExecute(String pattern, WorkflowStepExecuteHandler handler) {
        return this.workflowStepExecute(Pattern.compile("^.*" + Pattern.quote(pattern) + ".*$"), handler);
    }

    public App workflowStepExecute(Pattern pattern, WorkflowStepExecuteHandler handler) {
        if (this.workflowStepExecuteHandlers.get(pattern) != null) {
            log.warn("Replaced the handler for {}", (Object)pattern);
        }
        this.workflowStepExecuteHandlers.put(pattern, handler);
        return this;
    }

    public App attachmentAction(String callbackId, AttachmentActionHandler handler) {
        return this.attachmentAction(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App attachmentAction(Pattern callbackId, AttachmentActionHandler handler) {
        if (this.attachmentActionHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.attachmentActionHandlers.put(callbackId, handler);
        return this;
    }

    public App dialogSubmission(String callbackId, DialogSubmissionHandler handler) {
        return this.dialogSubmission(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App dialogSubmission(Pattern callbackId, DialogSubmissionHandler handler) {
        if (this.dialogSubmissionHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.dialogSubmissionHandlers.put(callbackId, handler);
        return this;
    }

    public App dialogSuggestion(String callbackId, DialogSuggestionHandler handler) {
        return this.dialogSuggestion(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App dialogSuggestion(Pattern callbackId, DialogSuggestionHandler handler) {
        if (this.dialogSuggestionHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.dialogSuggestionHandlers.put(callbackId, handler);
        return this;
    }

    public App dialogCancellation(String callbackId, DialogCancellationHandler handler) {
        return this.dialogCancellation(Pattern.compile("^" + Pattern.quote(callbackId) + "$"), handler);
    }

    public App dialogCancellation(Pattern callbackId, DialogCancellationHandler handler) {
        if (this.dialogCancellationHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.dialogCancellationHandlers.put(callbackId, handler);
        return this;
    }

    public App asOAuthApp(boolean enabled) {
        this.config().setOAuthInstallPathEnabled(enabled);
        this.config().setOAuthRedirectUriPathEnabled(enabled);
        return this;
    }

    public App asOpenIDConnectApp(boolean enabled) {
        this.config().setOpenIDConnectEnabled(enabled);
        this.asOAuthApp(enabled);
        return this;
    }

    public App service(OAuthCallbackService oAuthCallbackService) {
        this.oAuthCallbackService = oAuthCallbackService;
        this.putServiceInitializer(OAuthCallbackService.class, oAuthCallbackService.initializer());
        return this;
    }

    public App service(OAuthStateService oAuthStateService) {
        this.oAuthStateService = oAuthStateService;
        this.putServiceInitializer(OAuthStateService.class, oAuthStateService.initializer());
        return this;
    }

    public App service(OpenIDConnectNonceService openIDConnectNonceService) {
        this.openIDConnectNonceService = openIDConnectNonceService;
        this.putServiceInitializer(OpenIDConnectNonceService.class, openIDConnectNonceService.initializer());
        return this;
    }

    public App service(InstallationService installationService) {
        this.installationService = installationService;
        this.tokensRevokedEventHandler = new DefaultTokensRevokedEventHandler(this.installationService, this.executorService);
        this.appUninstalledEventHandler = new DefaultAppUninstalledEventHandler(this.installationService, this.executorService);
        this.putServiceInitializer(InstallationService.class, installationService.initializer());
        if (this.config().isClassicAppPermissionsEnabled()) {
            return this.oauthCallback(new OAuthDefaultSuccessHandler(this.config(), installationService));
        }
        return this.oauthCallback(new OAuthV2DefaultSuccessHandler(this.config(), installationService));
    }

    public App oauthCallback(OAuthSuccessHandler handler) {
        this.oAuthSuccessHandler = handler;
        return this;
    }

    public App oauthCallback(OAuthV2SuccessHandler handler) {
        this.oAuthV2SuccessHandler = handler;
        return this;
    }

    public App oauthCallbackError(OAuthErrorHandler handler) {
        this.oAuthErrorHandler = handler;
        return this;
    }

    public App oauthCallbackStateError(OAuthStateErrorHandler handler) {
        this.oAuthStateErrorHandler = handler;
        return this;
    }

    public App oauthCallbackAccessError(OAuthAccessErrorHandler handler) {
        this.oAuthAccessErrorHandler = handler;
        return this;
    }

    public App oauthCallbackAccessError(OAuthV2AccessErrorHandler handler) {
        this.oAuthV2AccessErrorHandler = handler;
        return this;
    }

    public App openIDConnectSuccess(OpenIDConnectSuccessHandler handler) {
        this.openIDConnectSuccessHandler = handler;
        return this;
    }

    public App openIDConnectError(OpenIDConnectErrorHandler handler) {
        this.openIDConnectErrorHandler = handler;
        return this;
    }

    public App oauthCallbackException(OAuthExceptionHandler handler) {
        this.oAuthExceptionHandler = handler;
        return this;
    }

    @Deprecated
    public App toOAuthStartApp() {
        return this.toOAuthInstallPathEnabledApp();
    }

    public App toOAuthInstallPathEnabledApp() {
        App newApp = this.toBuilder().appConfig(this.config().toBuilder().build()).build();
        newApp.config().setOAuthInstallPathEnabled(true);
        newApp.config().setOAuthRedirectUriPathEnabled(false);
        return newApp;
    }

    @Deprecated
    public App toOAuthCallbackApp() {
        return this.toOAuthRedirectUriPathEnabledApp();
    }

    public App toOAuthRedirectUriPathEnabledApp() {
        App newApp = this.toBuilder().appConfig(this.config().toBuilder().build()).build();
        newApp.config().setOAuthInstallPathEnabled(false);
        newApp.config().setOAuthRedirectUriPathEnabled(true);
        return newApp;
    }

    public App endpoint(String path, WebEndpointHandler handler) {
        return this.endpoint(WebEndpoint.Method.GET, path, handler);
    }

    public App endpoint(String method, String path, WebEndpointHandler handler) {
        return this.endpoint(WebEndpoint.Method.valueOf(method), path, handler);
    }

    public App endpoint(WebEndpoint.Method method, String path, WebEndpointHandler handler) {
        this.webEndpointHandlers.put(new WebEndpoint(method, path), handler);
        return this;
    }

    protected Response runMiddleware(Request request, Response response, Middleware current, LinkedList<Middleware> remaining) throws Exception {
        if (log.isDebugEnabled()) {
            String middlewareName = current.getClass().getCanonicalName();
            if (middlewareName == null) {
                middlewareName = current.toString();
            }
            log.debug("Applying a middleware (name: {})", (Object)middlewareName);
        }
        if (remaining.isEmpty()) {
            return current.apply(request, response, req -> this.runHandler(req));
        }
        Middleware next = remaining.pop();
        return current.apply(request, response, req -> this.runMiddleware(request, response, next, remaining));
    }

    /*
     * Exception decompiling
     */
    protected Response runHandler(Request slackRequest) throws IOException, SlackApiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [46[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Generated
    public static AppBuilder builder() {
        return new AppBuilder();
    }

    @Generated
    public AppBuilder toBuilder() {
        return new AppBuilder().appConfig(this.appConfig).slack(this.slack).client(this.client).executorService(this.executorService).middlewareList(this.middlewareList).status(this.status).installationService(this.installationService).tokensRevokedEventHandler(this.tokensRevokedEventHandler).appUninstalledEventHandler(this.appUninstalledEventHandler).oAuthStateService(this.oAuthStateService).openIDConnectNonceService(this.openIDConnectNonceService).oAuthSuccessHandler(this.oAuthSuccessHandler).oAuthV2SuccessHandler(this.oAuthV2SuccessHandler).openIDConnectSuccessHandler(this.openIDConnectSuccessHandler).oAuthErrorHandler(this.oAuthErrorHandler).oAuthAccessErrorHandler(this.oAuthAccessErrorHandler).oAuthV2AccessErrorHandler(this.oAuthV2AccessErrorHandler).openIDConnectErrorHandler(this.openIDConnectErrorHandler).oAuthStateErrorHandler(this.oAuthStateErrorHandler).oAuthExceptionHandler(this.oAuthExceptionHandler).oAuthCallbackService(this.oAuthCallbackService);
    }

    @Generated
    public App(AppConfig appConfig, Slack slack, MethodsClient client, ExecutorService executorService, List<Middleware> middlewareList, Status status, InstallationService installationService, DefaultTokensRevokedEventHandler tokensRevokedEventHandler, DefaultAppUninstalledEventHandler appUninstalledEventHandler, OAuthStateService oAuthStateService, OpenIDConnectNonceService openIDConnectNonceService, OAuthSuccessHandler oAuthSuccessHandler, OAuthV2SuccessHandler oAuthV2SuccessHandler, OpenIDConnectSuccessHandler openIDConnectSuccessHandler, OAuthErrorHandler oAuthErrorHandler, OAuthAccessErrorHandler oAuthAccessErrorHandler, OAuthV2AccessErrorHandler oAuthV2AccessErrorHandler, OpenIDConnectErrorHandler openIDConnectErrorHandler, OAuthStateErrorHandler oAuthStateErrorHandler, OAuthExceptionHandler oAuthExceptionHandler, OAuthCallbackService oAuthCallbackService) {
        this.appConfig = appConfig;
        this.slack = slack;
        this.client = client;
        this.executorService = executorService;
        this.middlewareList = middlewareList;
        this.status = status;
        this.installationService = installationService;
        this.tokensRevokedEventHandler = tokensRevokedEventHandler;
        this.appUninstalledEventHandler = appUninstalledEventHandler;
        this.oAuthStateService = oAuthStateService;
        this.openIDConnectNonceService = openIDConnectNonceService;
        this.oAuthSuccessHandler = oAuthSuccessHandler;
        this.oAuthV2SuccessHandler = oAuthV2SuccessHandler;
        this.openIDConnectSuccessHandler = openIDConnectSuccessHandler;
        this.oAuthErrorHandler = oAuthErrorHandler;
        this.oAuthAccessErrorHandler = oAuthAccessErrorHandler;
        this.oAuthV2AccessErrorHandler = oAuthV2AccessErrorHandler;
        this.openIDConnectErrorHandler = openIDConnectErrorHandler;
        this.oAuthStateErrorHandler = oAuthStateErrorHandler;
        this.oAuthExceptionHandler = oAuthExceptionHandler;
        this.oAuthCallbackService = oAuthCallbackService;
    }

    public static enum Status {
        Running,
        Stopped;

    }

    @Generated
    public static class AppBuilder {
        @Generated
        private AppConfig appConfig;
        @Generated
        private Slack slack;
        @Generated
        private MethodsClient client;
        @Generated
        private ExecutorService executorService;
        @Generated
        private List<Middleware> middlewareList;
        @Generated
        private Status status;
        @Generated
        private InstallationService installationService;
        @Generated
        private DefaultTokensRevokedEventHandler tokensRevokedEventHandler;
        @Generated
        private DefaultAppUninstalledEventHandler appUninstalledEventHandler;
        @Generated
        private OAuthStateService oAuthStateService;
        @Generated
        private OpenIDConnectNonceService openIDConnectNonceService;
        @Generated
        private OAuthSuccessHandler oAuthSuccessHandler;
        @Generated
        private OAuthV2SuccessHandler oAuthV2SuccessHandler;
        @Generated
        private OpenIDConnectSuccessHandler openIDConnectSuccessHandler;
        @Generated
        private OAuthErrorHandler oAuthErrorHandler;
        @Generated
        private OAuthAccessErrorHandler oAuthAccessErrorHandler;
        @Generated
        private OAuthV2AccessErrorHandler oAuthV2AccessErrorHandler;
        @Generated
        private OpenIDConnectErrorHandler openIDConnectErrorHandler;
        @Generated
        private OAuthStateErrorHandler oAuthStateErrorHandler;
        @Generated
        private OAuthExceptionHandler oAuthExceptionHandler;
        @Generated
        private OAuthCallbackService oAuthCallbackService;

        @Generated
        AppBuilder() {
        }

        @Generated
        public AppBuilder appConfig(AppConfig appConfig) {
            this.appConfig = appConfig;
            return this;
        }

        @Generated
        public AppBuilder slack(Slack slack) {
            this.slack = slack;
            return this;
        }

        @Generated
        public AppBuilder client(MethodsClient client) {
            this.client = client;
            return this;
        }

        @Generated
        public AppBuilder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Generated
        public AppBuilder middlewareList(List<Middleware> middlewareList) {
            this.middlewareList = middlewareList;
            return this;
        }

        @Generated
        public AppBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @Generated
        public AppBuilder installationService(InstallationService installationService) {
            this.installationService = installationService;
            return this;
        }

        @Generated
        public AppBuilder tokensRevokedEventHandler(DefaultTokensRevokedEventHandler tokensRevokedEventHandler) {
            this.tokensRevokedEventHandler = tokensRevokedEventHandler;
            return this;
        }

        @Generated
        public AppBuilder appUninstalledEventHandler(DefaultAppUninstalledEventHandler appUninstalledEventHandler) {
            this.appUninstalledEventHandler = appUninstalledEventHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthStateService(OAuthStateService oAuthStateService) {
            this.oAuthStateService = oAuthStateService;
            return this;
        }

        @Generated
        public AppBuilder openIDConnectNonceService(OpenIDConnectNonceService openIDConnectNonceService) {
            this.openIDConnectNonceService = openIDConnectNonceService;
            return this;
        }

        @Generated
        public AppBuilder oAuthSuccessHandler(OAuthSuccessHandler oAuthSuccessHandler) {
            this.oAuthSuccessHandler = oAuthSuccessHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthV2SuccessHandler(OAuthV2SuccessHandler oAuthV2SuccessHandler) {
            this.oAuthV2SuccessHandler = oAuthV2SuccessHandler;
            return this;
        }

        @Generated
        public AppBuilder openIDConnectSuccessHandler(OpenIDConnectSuccessHandler openIDConnectSuccessHandler) {
            this.openIDConnectSuccessHandler = openIDConnectSuccessHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthErrorHandler(OAuthErrorHandler oAuthErrorHandler) {
            this.oAuthErrorHandler = oAuthErrorHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthAccessErrorHandler(OAuthAccessErrorHandler oAuthAccessErrorHandler) {
            this.oAuthAccessErrorHandler = oAuthAccessErrorHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthV2AccessErrorHandler(OAuthV2AccessErrorHandler oAuthV2AccessErrorHandler) {
            this.oAuthV2AccessErrorHandler = oAuthV2AccessErrorHandler;
            return this;
        }

        @Generated
        public AppBuilder openIDConnectErrorHandler(OpenIDConnectErrorHandler openIDConnectErrorHandler) {
            this.openIDConnectErrorHandler = openIDConnectErrorHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthStateErrorHandler(OAuthStateErrorHandler oAuthStateErrorHandler) {
            this.oAuthStateErrorHandler = oAuthStateErrorHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthExceptionHandler(OAuthExceptionHandler oAuthExceptionHandler) {
            this.oAuthExceptionHandler = oAuthExceptionHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthCallbackService(OAuthCallbackService oAuthCallbackService) {
            this.oAuthCallbackService = oAuthCallbackService;
            return this;
        }

        @Generated
        public App build() {
            return new App(this.appConfig, this.slack, this.client, this.executorService, this.middlewareList, this.status, this.installationService, this.tokensRevokedEventHandler, this.appUninstalledEventHandler, this.oAuthStateService, this.openIDConnectNonceService, this.oAuthSuccessHandler, this.oAuthV2SuccessHandler, this.openIDConnectSuccessHandler, this.oAuthErrorHandler, this.oAuthAccessErrorHandler, this.oAuthV2AccessErrorHandler, this.openIDConnectErrorHandler, this.oAuthStateErrorHandler, this.oAuthExceptionHandler, this.oAuthCallbackService);
        }

        @Generated
        public String toString() {
            return "App.AppBuilder(appConfig=" + this.appConfig + ", slack=" + this.slack + ", client=" + this.client + ", executorService=" + this.executorService + ", middlewareList=" + this.middlewareList + ", status=" + (Object)((Object)this.status) + ", installationService=" + this.installationService + ", tokensRevokedEventHandler=" + this.tokensRevokedEventHandler + ", appUninstalledEventHandler=" + this.appUninstalledEventHandler + ", oAuthStateService=" + this.oAuthStateService + ", openIDConnectNonceService=" + this.openIDConnectNonceService + ", oAuthSuccessHandler=" + this.oAuthSuccessHandler + ", oAuthV2SuccessHandler=" + this.oAuthV2SuccessHandler + ", openIDConnectSuccessHandler=" + this.openIDConnectSuccessHandler + ", oAuthErrorHandler=" + this.oAuthErrorHandler + ", oAuthAccessErrorHandler=" + this.oAuthAccessErrorHandler + ", oAuthV2AccessErrorHandler=" + this.oAuthV2AccessErrorHandler + ", openIDConnectErrorHandler=" + this.openIDConnectErrorHandler + ", oAuthStateErrorHandler=" + this.oAuthStateErrorHandler + ", oAuthExceptionHandler=" + this.oAuthExceptionHandler + ", oAuthCallbackService=" + this.oAuthCallbackService + ")";
        }
    }
}

