/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware.builtin;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.MiddlewareChain;
import com.slack.api.bolt.middleware.MiddlewareOps;
import com.slack.api.bolt.model.Installer;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.methods.response.auth.AuthTestResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTeamAuthorization
implements Middleware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SingleTeamAuthorization.class);
    private final AppConfig appConfig;
    private final InstallationService installationService;

    public SingleTeamAuthorization(AppConfig appConfig, InstallationService installationService) {
        this.appConfig = appConfig;
        this.installationService = installationService;
    }

    @Override
    public Response apply(Request req, Response resp, MiddlewareChain chain) throws Exception {
        if (MiddlewareOps.isNoAuthRequiredRequest(req.getRequestType())) {
            return chain.next(req);
        }
        Object context = req.getContext();
        AuthTestResponse authResult = ((Context)context).client().authTest(r -> r.token(this.appConfig.getSingleTeamBotToken()));
        if (authResult.isOk()) {
            if (((Context)context).getBotToken() == null) {
                ((Context)context).setBotToken(this.appConfig.getSingleTeamBotToken());
            }
            ((Context)context).setBotUserId(authResult.getUserId());
            ((Context)context).setTeamId(authResult.getTeamId());
            ((Context)context).setEnterpriseId(authResult.getEnterpriseId());
            if (this.appConfig.isAlwaysRequestUserTokenNeeded()) {
                if (this.installationService == null) {
                    log.warn("Skipped to fetch requestUserToken as InstallationService is not available for SingleTeamAuthorization - enterprise_id: {}, team_id: {}, user_id: {}", new Object[]{((Context)context).getEnterpriseId(), ((Context)context).getTeamId(), ((Context)context).getRequestUserId()});
                } else {
                    Installer installer = this.installationService.findInstaller(((Context)context).getEnterpriseId(), ((Context)context).getTeamId(), ((Context)context).getRequestUserId());
                    if (installer != null) {
                        ((Context)context).setRequestUserToken(installer.getInstallerUserAccessToken());
                    }
                }
            }
            return chain.next(req);
        }
        log.info("Invalid request detected - enterprise_id: {}, team_id: {}, user_id: {}", new Object[]{((Context)context).getEnterpriseId(), ((Context)context).getTeamId(), ((Context)context).getRequestUserId()});
        return Response.builder().statusCode(401).contentType("application/json").body("{\"error\":\"a request for an unknown workspace detected\"}").build();
    }
}

