/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.response;

import com.slack.api.RequestConfigurator;
import com.slack.api.Slack;
import com.slack.api.app_backend.interactive_components.ActionResponseSender;
import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.app_backend.slash_commands.SlashCommandResponseSender;
import com.slack.api.app_backend.slash_commands.response.SlashCommandResponse;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;

public class Responder {
    private final Slack slack;
    private final String responseUrl;
    private final ActionResponseSender actionResponseSender;
    private final SlashCommandResponseSender slashCommandResponseSender;

    public Responder(Slack slack, String responseUrl) {
        this.slack = slack;
        this.responseUrl = responseUrl;
        this.actionResponseSender = new ActionResponseSender(slack);
        this.slashCommandResponseSender = new SlashCommandResponseSender(slack);
    }

    public WebhookResponse send(SlashCommandResponse response) throws IOException {
        return new SlashCommandResponseSender(this.slack).send(this.responseUrl, response);
    }

    public WebhookResponse send(ActionResponse response) throws IOException {
        return new ActionResponseSender(this.slack).send(this.responseUrl, response);
    }

    public WebhookResponse sendToAction(RequestConfigurator<ActionResponse.ActionResponseBuilder> body) throws IOException {
        return this.send(((ActionResponse.ActionResponseBuilder)body.configure((Object)ActionResponse.builder())).build());
    }

    public WebhookResponse sendToCommand(RequestConfigurator<SlashCommandResponse.SlashCommandResponseBuilder> body) throws IOException {
        return this.send(((SlashCommandResponse.SlashCommandResponseBuilder)body.configure((Object)SlashCommandResponse.builder())).build());
    }
}

