/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slack.api.bolt.context.builtin.DefaultContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class UrlVerificationRequest
extends Request<DefaultContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final String challenge;
    private DefaultContext context = new DefaultContext();

    public UrlVerificationRequest(String requestBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        JsonObject payload = ((JsonElement)GsonFactory.createSnakeCase().fromJson(requestBody, JsonElement.class)).getAsJsonObject();
        this.challenge = payload.get("challenge").getAsString();
    }

    @Override
    public DefaultContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.UrlVerification;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public String getChallenge() {
        return this.challenge;
    }

    @Override
    @Generated
    public String toString() {
        return "UrlVerificationRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", challenge=" + this.getChallenge() + ", context=" + this.getContext() + ")";
    }
}

