/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.interactive_components.payload.MessageActionPayload;
import com.slack.api.bolt.context.builtin.MessageActionContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class MessageActionRequest
extends Request<MessageActionContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final MessageActionPayload payload;
    private MessageActionContext context = new MessageActionContext();

    public MessageActionRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (MessageActionPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, MessageActionPayload.class);
        this.getContext().setResponseUrl(this.payload.getResponseUrl());
        this.getContext().setTriggerId(this.payload.getTriggerId());
        this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        this.getContext().setTeamId(this.payload.getTeam().getId());
        if (this.payload.getChannel() != null) {
            this.getContext().setChannelId(this.payload.getChannel().getId());
        }
        this.getContext().setRequestUserId(this.payload.getUser().getId());
    }

    @Override
    public MessageActionContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.MessageAction;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public MessageActionPayload getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public String toString() {
        return "MessageActionRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

