/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.slack.api.Slack;
import com.slack.api.app_backend.SlackSignature;
import com.slack.api.app_backend.events.EventHandler;
import com.slack.api.app_backend.events.EventsDispatcher;
import com.slack.api.app_backend.events.EventsDispatcherFactory;
import com.slack.api.app_backend.events.payload.EventsApiPayload;
import com.slack.api.app_backend.interactive_components.payload.BlockActionPayload;
import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.Initializer;
import com.slack.api.bolt.WebEndpoint;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.handler.BoltEventHandler;
import com.slack.api.bolt.handler.WebEndpointHandler;
import com.slack.api.bolt.handler.builtin.AttachmentActionHandler;
import com.slack.api.bolt.handler.builtin.BlockActionHandler;
import com.slack.api.bolt.handler.builtin.BlockSuggestionHandler;
import com.slack.api.bolt.handler.builtin.DialogCancellationHandler;
import com.slack.api.bolt.handler.builtin.DialogSubmissionHandler;
import com.slack.api.bolt.handler.builtin.DialogSuggestionHandler;
import com.slack.api.bolt.handler.builtin.MessageActionHandler;
import com.slack.api.bolt.handler.builtin.OutgoingWebhooksHandler;
import com.slack.api.bolt.handler.builtin.SlashCommandHandler;
import com.slack.api.bolt.handler.builtin.ViewClosedHandler;
import com.slack.api.bolt.handler.builtin.ViewSubmissionHandler;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.builtin.IgnoringSelfEvents;
import com.slack.api.bolt.middleware.builtin.MultiTeamsAuthorization;
import com.slack.api.bolt.middleware.builtin.RequestVerification;
import com.slack.api.bolt.middleware.builtin.SSLCheck;
import com.slack.api.bolt.middleware.builtin.SingleTeamAuthorization;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.builtin.AttachmentActionRequest;
import com.slack.api.bolt.request.builtin.BlockActionRequest;
import com.slack.api.bolt.request.builtin.BlockSuggestionRequest;
import com.slack.api.bolt.request.builtin.DialogCancellationRequest;
import com.slack.api.bolt.request.builtin.DialogSubmissionRequest;
import com.slack.api.bolt.request.builtin.DialogSuggestionRequest;
import com.slack.api.bolt.request.builtin.EventRequest;
import com.slack.api.bolt.request.builtin.MessageActionRequest;
import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.request.builtin.OutgoingWebhooksRequest;
import com.slack.api.bolt.request.builtin.SlashCommandRequest;
import com.slack.api.bolt.request.builtin.UrlVerificationRequest;
import com.slack.api.bolt.request.builtin.ViewClosedRequest;
import com.slack.api.bolt.request.builtin.ViewSubmissionRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.bolt.service.OAuthCallbackService;
import com.slack.api.bolt.service.OAuthStateService;
import com.slack.api.bolt.service.Service;
import com.slack.api.bolt.service.builtin.ClientOnlyOAuthStateService;
import com.slack.api.bolt.service.builtin.DefaultOAuthCallbackService;
import com.slack.api.bolt.service.builtin.FileInstallationService;
import com.slack.api.bolt.service.builtin.oauth.OAuthAccessErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthExceptionHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthStateErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthSuccessHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthV2AccessErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.OAuthV2SuccessHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultAccessErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultExceptionHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultStateErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthDefaultSuccessHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthV2DefaultAccessErrorHandler;
import com.slack.api.bolt.service.builtin.oauth.default_impl.OAuthV2DefaultSuccessHandler;
import com.slack.api.methods.SlackApiException;
import com.slack.api.model.event.Event;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(App.class);
    private static final Gson GSON = GsonFactory.createSnakeCase();
    private final AppConfig appConfig;
    private final Slack slack;
    private List<Middleware> middlewareList;
    private Status status;
    private final Map<Pattern, SlashCommandHandler> slashCommandHandlers = new HashMap<Pattern, SlashCommandHandler>();
    private final Map<String, BoltEventHandler<Event>> eventHandlers = new HashMap<String, BoltEventHandler<Event>>();
    private final EventsDispatcher eventsDispatcher = EventsDispatcherFactory.getInstance();
    private final Map<Class<? extends Event>, String> eventTypeAndSubtypeValues = new HashMap<Class<? extends Event>, String>();
    private final Map<Pattern, BlockActionHandler> blockActionHandlers = new HashMap<Pattern, BlockActionHandler>();
    private final Map<Pattern, BlockSuggestionHandler> blockSuggestionHandlers = new HashMap<Pattern, BlockSuggestionHandler>();
    private final Map<Pattern, ViewSubmissionHandler> viewSubmissionHandlers = new HashMap<Pattern, ViewSubmissionHandler>();
    private final Map<Pattern, ViewClosedHandler> viewClosedHandlers = new HashMap<Pattern, ViewClosedHandler>();
    private final Map<Pattern, MessageActionHandler> messageActionHandlers = new HashMap<Pattern, MessageActionHandler>();
    private final Map<Pattern, AttachmentActionHandler> attachmentActionHandlers = new HashMap<Pattern, AttachmentActionHandler>();
    private final Map<Pattern, DialogSubmissionHandler> dialogSubmissionHandlers = new HashMap<Pattern, DialogSubmissionHandler>();
    private final Map<Pattern, DialogSuggestionHandler> dialogSuggestionHandlers = new HashMap<Pattern, DialogSuggestionHandler>();
    private final Map<Pattern, DialogCancellationHandler> dialogCancellationHandlers = new HashMap<Pattern, DialogCancellationHandler>();
    private final Map<String, OutgoingWebhooksHandler> outgoingWebhooksHandlers = new HashMap<String, OutgoingWebhooksHandler>();
    private InstallationService installationService;
    private OAuthStateService oAuthStateService;
    private OAuthSuccessHandler oAuthSuccessHandler;
    private OAuthV2SuccessHandler oAuthV2SuccessHandler;
    private OAuthErrorHandler oAuthErrorHandler;
    private OAuthAccessErrorHandler oAuthAccessErrorHandler;
    private OAuthV2AccessErrorHandler oAuthV2AccessErrorHandler;
    private OAuthStateErrorHandler oAuthStateErrorHandler;
    private OAuthExceptionHandler oAuthExceptionHandler;
    private OAuthCallbackService oAuthCallbackService;
    private final Map<WebEndpoint, WebEndpointHandler> webEndpointHandlers = new HashMap<WebEndpoint, WebEndpointHandler>();
    private final Map<String, Initializer> componentNameToInitializer = new HashMap<String, Initializer>();
    private final AtomicBoolean neverStarted = new AtomicBoolean(true);

    protected List<Middleware> buildDefaultMiddlewareList(AppConfig appConfig) {
        ArrayList<Middleware> middlewareList = new ArrayList<Middleware>();
        middlewareList.add(new SSLCheck(this.config().getVerificationToken()));
        SlackSignature.Verifier verifier = new SlackSignature.Verifier(new SlackSignature.Generator(appConfig.getSigningSecret()));
        RequestVerification requestVerification = new RequestVerification(verifier);
        middlewareList.add(requestVerification);
        if (appConfig.isDistributedApp()) {
            middlewareList.add(new MultiTeamsAuthorization(this.config(), this.installationService));
        } else if (appConfig.getSingleTeamBotToken() != null) {
            middlewareList.add(new SingleTeamAuthorization(this.config(), this.installationService));
        } else {
            log.warn("Skipped adding any authorization middleware - you need to call `app.use(new YourOwnMultiTeamsAuthorization())`");
        }
        middlewareList.add(new IgnoringSelfEvents(appConfig.getSlack().getConfig()));
        return middlewareList;
    }

    private Class<? extends Event> getEventClass(String eventType) {
        for (Map.Entry<Class<? extends Event>, String> entry : this.eventTypeAndSubtypeValues.entrySet()) {
            if (!entry.getValue().equals(eventType)) continue;
            return entry.getKey();
        }
        return null;
    }

    private String getEventTypeAndSubtype(Class<? extends Event> clazz) {
        String cached = this.eventTypeAndSubtypeValues.get(clazz);
        if (cached != null) {
            return cached;
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            try {
                Event event = (Event)constructor.newInstance(new Object[0]);
                String typeAndSubtype = event.getType() + ":" + event.getSubtype();
                this.eventTypeAndSubtypeValues.put(clazz, typeAndSubtype);
                return typeAndSubtype;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                log.error("Unexpectedly failed to load event type for the class {}", (Object)clazz.getCanonicalName());
                break;
            }
        }
        return null;
    }

    private BoltEventPayload buildEventPayload(EventRequest request) {
        BoltEventPayload payload = (BoltEventPayload)GSON.fromJson(request.getRequestBodyAsString(), BoltEventPayload.class);
        Class<? extends Event> eventClass = this.getEventClass(request.getEventTypeAndSubtype());
        if (eventClass != null) {
            Event event = (Event)GSON.fromJson((JsonElement)((JsonElement)GSON.fromJson(request.getRequestBodyAsString(), JsonElement.class)).getAsJsonObject().get("event").getAsJsonObject(), eventClass);
            payload.setEvent(event);
        }
        return payload;
    }

    private void initOAuthServicesIfNecessary() {
        if (this.appConfig.isDistributedApp() && this.appConfig.isOAuthCallbackEnabled() && this.oAuthCallbackService == null) {
            this.oAuthCallbackService = new DefaultOAuthCallbackService(this.config(), this.oAuthStateService, this.oAuthSuccessHandler, this.oAuthV2SuccessHandler, this.oAuthErrorHandler, this.oAuthStateErrorHandler, this.oAuthAccessErrorHandler, this.oAuthV2AccessErrorHandler, this.oAuthExceptionHandler);
        }
    }

    public String getOauthInstallationUrl(String state) {
        String scope;
        AppConfig config = this.config();
        if (config.getClientId() == null || config.getScope() == null || state == null) {
            return null;
        }
        String string = scope = config.getScope() == null ? "" : config.getScope();
        if (config.isClassicAppPermissionsEnabled()) {
            return "https://slack.com/oauth/authorize?client_id=" + config.getClientId() + "&scope=" + scope + "&state=" + state;
        }
        String userScope = config.getUserScope() == null ? "" : config.getUserScope();
        return "https://slack.com/oauth/v2/authorize?client_id=" + config.getClientId() + "&scope=" + scope + "&user_scope=" + userScope + "&state=" + state;
    }

    public Map<WebEndpoint, WebEndpointHandler> getWebEndpointHandlers() {
        return this.webEndpointHandlers;
    }

    public App() {
        this(new AppConfig());
    }

    public App(AppConfig appConfig) {
        this(appConfig, null);
        this.asOAuthApp(false);
    }

    public App(AppConfig appConfig, List<Middleware> middlewareList) {
        this(appConfig, appConfig.getSlack() != null ? appConfig.getSlack() : Slack.getInstance(), middlewareList);
        this.status = Status.Stopped;
    }

    public App(AppConfig appConfig, Slack slack, List<Middleware> middlewareList) {
        this.appConfig = appConfig;
        this.slack = slack;
        this.middlewareList = middlewareList;
        this.oAuthStateService = new ClientOnlyOAuthStateService();
        this.installationService = new FileInstallationService(this.appConfig);
        this.oAuthSuccessHandler = new OAuthDefaultSuccessHandler(this.installationService);
        this.oAuthV2SuccessHandler = new OAuthV2DefaultSuccessHandler(this.installationService);
        this.oAuthErrorHandler = new OAuthDefaultErrorHandler();
        this.oAuthAccessErrorHandler = new OAuthDefaultAccessErrorHandler();
        this.oAuthV2AccessErrorHandler = new OAuthV2DefaultAccessErrorHandler();
        this.oAuthStateErrorHandler = new OAuthDefaultStateErrorHandler();
        this.oAuthExceptionHandler = new OAuthDefaultExceptionHandler();
        this.oAuthCallbackService = null;
    }

    public AppConfig config() {
        return this.appConfig;
    }

    public Status status() {
        return this.status;
    }

    private void putServiceInitializer(Class<? extends Service> clazz, Initializer initializer) {
        String canonicalName = clazz.getCanonicalName();
        this.initializer(canonicalName, initializer);
    }

    public App initializer(String name, Initializer initializer) {
        this.componentNameToInitializer.put(name, initializer);
        return this;
    }

    public void initialize() {
        this.initOAuthServicesIfNecessary();
        if (this.neverStarted.get() && this.config().isAppInitializersEnabled()) {
            for (Initializer initializer : this.componentNameToInitializer.values()) {
                initializer.accept(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public App start() {
        Status status = this.status;
        synchronized (status) {
            if (this.status == Status.Stopped) {
                if (this.middlewareList == null) {
                    this.middlewareList = this.buildDefaultMiddlewareList(this.appConfig);
                }
                this.initialize();
                if (!this.eventsDispatcher.isEmpty()) {
                    this.eventsDispatcher.start();
                }
                this.neverStarted.set(false);
            }
            this.status = Status.Running;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public App stop() {
        Status status = this.status;
        synchronized (status) {
            if (this.status == Status.Running && this.eventsDispatcher.isRunning()) {
                this.eventsDispatcher.stop();
            }
            this.status = Status.Stopped;
        }
        return this;
    }

    public Response run(Request request) throws Exception {
        LinkedList<Middleware> remaining;
        ((Context)request.getContext()).setSlack(this.slack);
        if (this.neverStarted.get()) {
            this.start();
        }
        if ((remaining = new LinkedList<Middleware>(this.middlewareList)).isEmpty()) {
            return this.runHandler(request);
        }
        Middleware firstMiddleware = remaining.pop();
        return this.runMiddleware(request, Response.ok(), firstMiddleware, remaining);
    }

    public App use(Middleware middleware) {
        if (this.middlewareList == null) {
            this.middlewareList = this.buildDefaultMiddlewareList(this.config());
        }
        this.middlewareList.add(middleware);
        return this;
    }

    public <E extends Event> App event(Class<E> eventClass, BoltEventHandler<E> handler) {
        String eventTypeAndSubtype = this.getEventTypeAndSubtype(eventClass);
        if (eventTypeAndSubtype == null) {
            throw new IllegalArgumentException("Unexpectedly failed to register the handler");
        }
        if (this.eventHandlers.get(eventTypeAndSubtype) != null) {
            log.warn("Replaced the handler for {}", (Object)eventTypeAndSubtype);
        }
        this.eventHandlers.put(eventTypeAndSubtype, handler);
        return this;
    }

    public App event(EventHandler<?> handler) {
        this.eventsDispatcher.register(handler);
        return this;
    }

    public App command(String command, SlashCommandHandler handler) {
        return this.command(Pattern.compile("^" + command + "$"), handler);
    }

    public App command(Pattern command, SlashCommandHandler handler) {
        if (this.slashCommandHandlers.get(command) != null) {
            log.warn("Replaced the handler for {}", (Object)command);
        }
        this.slashCommandHandlers.put(command, handler);
        return this;
    }

    public App blockAction(String actionId, BlockActionHandler handler) {
        return this.blockAction(Pattern.compile("^" + actionId + "$"), handler);
    }

    public App blockAction(Pattern actionId, BlockActionHandler handler) {
        if (this.blockActionHandlers.get(actionId) != null) {
            log.warn("Replaced the handler for {}", (Object)actionId);
        }
        this.blockActionHandlers.put(actionId, handler);
        return this;
    }

    public App blockSuggestion(String actionId, BlockSuggestionHandler handler) {
        return this.blockSuggestion(Pattern.compile("^" + actionId + "$"), handler);
    }

    public App blockSuggestion(Pattern actionId, BlockSuggestionHandler handler) {
        if (this.blockSuggestionHandlers.get(actionId) != null) {
            log.warn("Replaced the handler for {}", (Object)actionId);
        }
        this.blockSuggestionHandlers.put(actionId, handler);
        return this;
    }

    public App viewSubmission(String callbackId, ViewSubmissionHandler handler) {
        return this.viewSubmission(Pattern.compile("^" + callbackId + "$"), handler);
    }

    public App viewSubmission(Pattern callbackId, ViewSubmissionHandler handler) {
        if (this.viewSubmissionHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.viewSubmissionHandlers.put(callbackId, handler);
        return this;
    }

    public App viewClosed(String callbackId, ViewClosedHandler handler) {
        return this.viewClosed(Pattern.compile("^" + callbackId + "$"), handler);
    }

    public App viewClosed(Pattern callbackId, ViewClosedHandler handler) {
        if (this.viewClosedHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.viewClosedHandlers.put(callbackId, handler);
        return this;
    }

    public App messageAction(String callbackId, MessageActionHandler handler) {
        return this.messageAction(Pattern.compile("^" + callbackId + "$"), handler);
    }

    public App messageAction(Pattern callbackId, MessageActionHandler handler) {
        if (this.messageActionHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.messageActionHandlers.put(callbackId, handler);
        return this;
    }

    public App attachmentAction(String callbackId, AttachmentActionHandler handler) {
        return this.attachmentAction(Pattern.compile("^" + callbackId + "$"), handler);
    }

    public App attachmentAction(Pattern callbackId, AttachmentActionHandler handler) {
        if (this.attachmentActionHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.attachmentActionHandlers.put(callbackId, handler);
        return this;
    }

    public App dialogSubmission(String callbackId, DialogSubmissionHandler handler) {
        return this.dialogSubmission(Pattern.compile("^" + callbackId + "$"), handler);
    }

    public App dialogSubmission(Pattern callbackId, DialogSubmissionHandler handler) {
        if (this.dialogSubmissionHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.dialogSubmissionHandlers.put(callbackId, handler);
        return this;
    }

    public App dialogSuggestion(String callbackId, DialogSuggestionHandler handler) {
        return this.dialogSuggestion(Pattern.compile("^" + callbackId + "$"), handler);
    }

    public App dialogSuggestion(Pattern callbackId, DialogSuggestionHandler handler) {
        if (this.dialogSuggestionHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.dialogSuggestionHandlers.put(callbackId, handler);
        return this;
    }

    public App dialogCancellation(String callbackId, DialogCancellationHandler handler) {
        return this.dialogCancellation(Pattern.compile("^" + callbackId + "$"), handler);
    }

    public App dialogCancellation(Pattern callbackId, DialogCancellationHandler handler) {
        if (this.dialogCancellationHandlers.get(callbackId) != null) {
            log.warn("Replaced the handler for {}", (Object)callbackId);
        }
        this.dialogCancellationHandlers.put(callbackId, handler);
        return this;
    }

    public App webhook(String triggerWord, OutgoingWebhooksHandler handler) {
        if (this.outgoingWebhooksHandlers.get(triggerWord) != null) {
            log.warn("Replaced the handler for {}", (Object)triggerWord);
        }
        this.outgoingWebhooksHandlers.put(triggerWord, handler);
        return this;
    }

    public App asOAuthApp(boolean enabled) {
        this.config().setOAuthStartEnabled(enabled);
        this.config().setOAuthCallbackEnabled(enabled);
        return this;
    }

    public App service(OAuthCallbackService oAuthCallbackService) {
        this.oAuthCallbackService = oAuthCallbackService;
        this.putServiceInitializer(OAuthCallbackService.class, oAuthCallbackService.initializer());
        return this;
    }

    public App service(OAuthStateService oAuthStateService) {
        this.oAuthStateService = oAuthStateService;
        this.putServiceInitializer(OAuthStateService.class, oAuthStateService.initializer());
        return this;
    }

    public App service(InstallationService installationService) {
        this.installationService = installationService;
        this.putServiceInitializer(InstallationService.class, installationService.initializer());
        if (this.config().isClassicAppPermissionsEnabled()) {
            return this.oauthCallback(new OAuthDefaultSuccessHandler(installationService));
        }
        return this.oauthCallback(new OAuthV2DefaultSuccessHandler(installationService));
    }

    public App oauthCallback(OAuthSuccessHandler handler) {
        this.oAuthSuccessHandler = handler;
        return this;
    }

    public App oauthCallback(OAuthV2SuccessHandler handler) {
        this.oAuthV2SuccessHandler = handler;
        return this;
    }

    public App oauthCallbackError(OAuthErrorHandler handler) {
        this.oAuthErrorHandler = handler;
        return this;
    }

    public App oauthCallbackStateError(OAuthStateErrorHandler handler) {
        this.oAuthStateErrorHandler = handler;
        return this;
    }

    public App oauthCallbackAccessError(OAuthAccessErrorHandler handler) {
        this.oAuthAccessErrorHandler = handler;
        return this;
    }

    public App oauthCallbackAccessError(OAuthV2AccessErrorHandler handler) {
        this.oAuthV2AccessErrorHandler = handler;
        return this;
    }

    public App oauthCallbackException(OAuthExceptionHandler handler) {
        this.oAuthExceptionHandler = handler;
        return this;
    }

    public App toOAuthStartApp() {
        App newApp = this.toBuilder().appConfig(this.config().toBuilder().build()).build();
        newApp.config().setOAuthStartEnabled(true);
        newApp.config().setOAuthCallbackEnabled(false);
        return newApp;
    }

    public App toOAuthCallbackApp() {
        App newApp = this.toBuilder().appConfig(this.config().toBuilder().build()).build();
        newApp.config().setOAuthStartEnabled(false);
        newApp.config().setOAuthCallbackEnabled(true);
        return newApp;
    }

    public App endpoint(String path, WebEndpointHandler handler) {
        return this.endpoint(WebEndpoint.Method.GET, path, handler);
    }

    public App endpoint(String method, String path, WebEndpointHandler handler) {
        return this.endpoint(WebEndpoint.Method.valueOf(method), path, handler);
    }

    public App endpoint(WebEndpoint.Method method, String path, WebEndpointHandler handler) {
        this.webEndpointHandlers.put(new WebEndpoint(method, path), handler);
        return this;
    }

    protected Response runMiddleware(Request request, Response response, Middleware current, LinkedList<Middleware> remaining) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Start running a middleware (name: {})", (Object)current.getClass().getCanonicalName());
        }
        if (remaining.isEmpty()) {
            return current.apply(request, response, req -> this.runHandler(req));
        }
        Middleware next = remaining.pop();
        return current.apply(request, response, req -> this.runMiddleware(request, response, next, remaining));
    }

    protected Response runHandler(Request slackRequest) throws IOException, SlackApiException {
        if (log.isDebugEnabled()) {
            log.debug("Start running the main handler (request type: {})", (Object)slackRequest.getRequestType());
        }
        switch (slackRequest.getRequestType()) {
            case OAuthStart: {
                if (this.config().isDistributedApp()) {
                    try {
                        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                        Response response = Response.builder().statusCode(302).headers(responseHeaders).build();
                        String state = this.oAuthStateService.issueNewState(slackRequest, response);
                        String url = this.getOauthInstallationUrl(state);
                        if (url == null) {
                            log.error("AppConfig#getOauthInstallationUrl(String) returned null due to some missing settings");
                            responseHeaders.put("Location", Arrays.asList(this.config().getOauthCancellationUrl()));
                        } else {
                            responseHeaders.put("Location", Arrays.asList(url));
                        }
                        return response;
                    }
                    catch (Exception e) {
                        log.error("Failed to run the operation (error: {})", (Object)e.getMessage(), (Object)e);
                    }
                }
                log.warn("Skipped to handle an OAuth callback request as this Bolt app is not ready for it");
                return Response.builder().statusCode(500).body("something wrong").build();
            }
            case OAuthCallback: {
                if (this.config().isDistributedApp() && this.oAuthCallbackService != null) {
                    OAuthCallbackRequest request = (OAuthCallbackRequest)slackRequest;
                    return this.oAuthCallbackService.handle(request);
                }
                log.warn("Skipped to handle an OAuth callback request as this Bolt app is not ready for it");
                return Response.builder().statusCode(500).body("something wrong").build();
            }
            case Command: {
                SlashCommandRequest request = (SlashCommandRequest)slackRequest;
                String command = request.getPayload().getCommand();
                if (command != null) {
                    for (Pattern pattern : this.slashCommandHandlers.keySet()) {
                        if (!pattern.matcher(command).matches()) continue;
                        SlashCommandHandler handler = this.slashCommandHandlers.get(pattern);
                        return handler.apply(request, request.getContext());
                    }
                }
                log.warn("No SlashCommandHandler registered for command: {}", (Object)request.getPayload().getCommand());
                break;
            }
            case OutgoingWebhooks: {
                OutgoingWebhooksRequest request = (OutgoingWebhooksRequest)slackRequest;
                OutgoingWebhooksHandler handler = this.outgoingWebhooksHandlers.get(request.getPayload().getTriggerWord());
                if (handler != null) {
                    return handler.apply(request, request.getContext());
                }
                log.warn("No OutgoingWebhooksHandler for trigger_word: {}", (Object)request.getPayload().getTriggerWord());
                break;
            }
            case Event: {
                EventRequest request;
                BoltEventHandler<Event> handler;
                if (this.eventsDispatcher.isRunning()) {
                    this.eventsDispatcher.enqueue(slackRequest.getRequestBodyAsString());
                }
                if ((handler = this.eventHandlers.get((request = (EventRequest)slackRequest).getEventTypeAndSubtype())) != null) {
                    BoltEventPayload payload = this.buildEventPayload(request);
                    return handler.apply(payload, request.getContext());
                }
                log.warn("No BoltEventHandler registered for event: {}", (Object)request.getEventTypeAndSubtype());
                return Response.ok();
            }
            case UrlVerification: {
                return Response.builder().statusCode(200).contentType("text/plain").body(((UrlVerificationRequest)slackRequest).getChallenge()).build();
            }
            case AttachmentAction: {
                AttachmentActionRequest request = (AttachmentActionRequest)slackRequest;
                String callbackId = request.getPayload().getCallbackId();
                if (callbackId != null) {
                    for (Pattern pattern : this.attachmentActionHandlers.keySet()) {
                        if (!pattern.matcher(callbackId).matches()) continue;
                        AttachmentActionHandler handler = this.attachmentActionHandlers.get(pattern);
                        return handler.apply(request, request.getContext());
                    }
                }
                log.warn("No AttachmentActionHandler registered for callback_id: {}", (Object)request.getPayload().getCallbackId());
                break;
            }
            case BlockAction: {
                BlockActionRequest request = (BlockActionRequest)slackRequest;
                List actions = request.getPayload().getActions();
                if (actions == null) {
                    return Response.json(400, "{\"error\":\"No `actions` property found\"}");
                }
                if (actions.size() == 1) {
                    String actionId = ((BlockActionPayload.Action)actions.get(0)).getActionId();
                    if (actionId != null) {
                        for (Pattern pattern : this.blockActionHandlers.keySet()) {
                            if (!pattern.matcher(actionId).matches()) continue;
                            BlockActionHandler handler = this.blockActionHandlers.get(pattern);
                            return handler.apply(request, request.getContext());
                        }
                    }
                    log.warn("No BlockActionHandler registered for action_id: {}", (Object)((BlockActionPayload.Action)actions.get(0)).getActionId());
                    break;
                }
                for (BlockActionPayload.Action action : request.getPayload().getActions()) {
                    if (action == null || action.getActionId() == null) continue;
                    this.blockActionHandlers.get(action.getActionId());
                }
                break;
            }
            case BlockSuggestion: {
                BlockSuggestionRequest request = (BlockSuggestionRequest)slackRequest;
                String actionId = request.getPayload().getActionId();
                if (actionId != null) {
                    for (Pattern pattern : this.blockSuggestionHandlers.keySet()) {
                        if (!pattern.matcher(actionId).matches()) continue;
                        BlockSuggestionHandler handler = this.blockSuggestionHandlers.get(pattern);
                        return handler.apply(request, request.getContext());
                    }
                }
                log.warn("No BlockSuggestionHandler registered for action_id: {}", (Object)actionId);
                break;
            }
            case MessageAction: {
                MessageActionRequest request = (MessageActionRequest)slackRequest;
                String callbackId = request.getPayload().getCallbackId();
                if (callbackId != null) {
                    for (Pattern pattern : this.messageActionHandlers.keySet()) {
                        if (!pattern.matcher(callbackId).matches()) continue;
                        MessageActionHandler handler = this.messageActionHandlers.get(pattern);
                        return handler.apply(request, request.getContext());
                    }
                }
                log.warn("No MessageActionHandler registered for callback_id: {}", (Object)request.getPayload().getCallbackId());
                break;
            }
            case DialogSubmission: {
                DialogSubmissionRequest request = (DialogSubmissionRequest)slackRequest;
                String callbackId = request.getPayload().getCallbackId();
                if (callbackId != null) {
                    for (Pattern pattern : this.dialogSubmissionHandlers.keySet()) {
                        if (!pattern.matcher(callbackId).matches()) continue;
                        DialogSubmissionHandler handler = this.dialogSubmissionHandlers.get(pattern);
                        return handler.apply(request, request.getContext());
                    }
                }
                log.warn("No DialogSubmissionHandler registered for callback_id: {}", (Object)request.getPayload().getCallbackId());
                break;
            }
            case DialogCancellation: {
                DialogCancellationRequest request = (DialogCancellationRequest)slackRequest;
                String callbackId = request.getPayload().getCallbackId();
                if (callbackId != null) {
                    for (Pattern pattern : this.dialogCancellationHandlers.keySet()) {
                        if (!pattern.matcher(callbackId).matches()) continue;
                        DialogCancellationHandler handler = this.dialogCancellationHandlers.get(pattern);
                        return handler.apply(request, request.getContext());
                    }
                }
                log.warn("No DialogCancellationHandler registered for callback_id: {}", (Object)request.getPayload().getCallbackId());
                break;
            }
            case DialogSuggestion: {
                DialogSuggestionRequest request = (DialogSuggestionRequest)slackRequest;
                String callbackId = request.getPayload().getCallbackId();
                if (callbackId != null) {
                    for (Pattern pattern : this.dialogSuggestionHandlers.keySet()) {
                        if (!pattern.matcher(callbackId).matches()) continue;
                        DialogSuggestionHandler handler = this.dialogSuggestionHandlers.get(pattern);
                        return handler.apply(request, request.getContext());
                    }
                }
                log.warn("No DialogSuggestionHandler registered for callback_id: {}", (Object)request.getPayload().getCallbackId());
                break;
            }
            case ViewSubmission: {
                ViewSubmissionRequest request = (ViewSubmissionRequest)slackRequest;
                String callbackId = request.getPayload().getView().getCallbackId();
                if (callbackId != null) {
                    for (Pattern pattern : this.viewSubmissionHandlers.keySet()) {
                        if (!pattern.matcher(callbackId).matches()) continue;
                        ViewSubmissionHandler handler = this.viewSubmissionHandlers.get(pattern);
                        return handler.apply(request, request.getContext());
                    }
                }
                log.warn("No ViewSubmissionHandler registered for callback_id: {}", (Object)request.getPayload().getView().getCallbackId());
                break;
            }
            case ViewClosed: {
                ViewClosedRequest request = (ViewClosedRequest)slackRequest;
                String callbackId = request.getPayload().getView().getCallbackId();
                if (callbackId != null) {
                    for (Pattern pattern : this.viewClosedHandlers.keySet()) {
                        if (!pattern.matcher(callbackId).matches()) continue;
                        ViewClosedHandler handler = this.viewClosedHandlers.get(pattern);
                        return handler.apply(request, request.getContext());
                    }
                }
                log.warn("No ViewClosedHandler registered for callback_id: {}", (Object)request.getPayload().getView().getCallbackId());
                break;
            }
        }
        return Response.json(404, "{\"error\":\"no handler found\"}");
    }

    @Generated
    public static AppBuilder builder() {
        return new AppBuilder();
    }

    @Generated
    public AppBuilder toBuilder() {
        return new AppBuilder().appConfig(this.appConfig).slack(this.slack).middlewareList(this.middlewareList).status(this.status).installationService(this.installationService).oAuthStateService(this.oAuthStateService).oAuthSuccessHandler(this.oAuthSuccessHandler).oAuthV2SuccessHandler(this.oAuthV2SuccessHandler).oAuthErrorHandler(this.oAuthErrorHandler).oAuthAccessErrorHandler(this.oAuthAccessErrorHandler).oAuthV2AccessErrorHandler(this.oAuthV2AccessErrorHandler).oAuthStateErrorHandler(this.oAuthStateErrorHandler).oAuthExceptionHandler(this.oAuthExceptionHandler).oAuthCallbackService(this.oAuthCallbackService);
    }

    @Generated
    public App(AppConfig appConfig, Slack slack, List<Middleware> middlewareList, Status status, InstallationService installationService, OAuthStateService oAuthStateService, OAuthSuccessHandler oAuthSuccessHandler, OAuthV2SuccessHandler oAuthV2SuccessHandler, OAuthErrorHandler oAuthErrorHandler, OAuthAccessErrorHandler oAuthAccessErrorHandler, OAuthV2AccessErrorHandler oAuthV2AccessErrorHandler, OAuthStateErrorHandler oAuthStateErrorHandler, OAuthExceptionHandler oAuthExceptionHandler, OAuthCallbackService oAuthCallbackService) {
        this.appConfig = appConfig;
        this.slack = slack;
        this.middlewareList = middlewareList;
        this.status = status;
        this.installationService = installationService;
        this.oAuthStateService = oAuthStateService;
        this.oAuthSuccessHandler = oAuthSuccessHandler;
        this.oAuthV2SuccessHandler = oAuthV2SuccessHandler;
        this.oAuthErrorHandler = oAuthErrorHandler;
        this.oAuthAccessErrorHandler = oAuthAccessErrorHandler;
        this.oAuthV2AccessErrorHandler = oAuthV2AccessErrorHandler;
        this.oAuthStateErrorHandler = oAuthStateErrorHandler;
        this.oAuthExceptionHandler = oAuthExceptionHandler;
        this.oAuthCallbackService = oAuthCallbackService;
    }

    @Generated
    public static class AppBuilder {
        @Generated
        private AppConfig appConfig;
        @Generated
        private Slack slack;
        @Generated
        private List<Middleware> middlewareList;
        @Generated
        private Status status;
        @Generated
        private InstallationService installationService;
        @Generated
        private OAuthStateService oAuthStateService;
        @Generated
        private OAuthSuccessHandler oAuthSuccessHandler;
        @Generated
        private OAuthV2SuccessHandler oAuthV2SuccessHandler;
        @Generated
        private OAuthErrorHandler oAuthErrorHandler;
        @Generated
        private OAuthAccessErrorHandler oAuthAccessErrorHandler;
        @Generated
        private OAuthV2AccessErrorHandler oAuthV2AccessErrorHandler;
        @Generated
        private OAuthStateErrorHandler oAuthStateErrorHandler;
        @Generated
        private OAuthExceptionHandler oAuthExceptionHandler;
        @Generated
        private OAuthCallbackService oAuthCallbackService;

        @Generated
        AppBuilder() {
        }

        @Generated
        public AppBuilder appConfig(AppConfig appConfig) {
            this.appConfig = appConfig;
            return this;
        }

        @Generated
        public AppBuilder slack(Slack slack) {
            this.slack = slack;
            return this;
        }

        @Generated
        public AppBuilder middlewareList(List<Middleware> middlewareList) {
            this.middlewareList = middlewareList;
            return this;
        }

        @Generated
        public AppBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @Generated
        public AppBuilder installationService(InstallationService installationService) {
            this.installationService = installationService;
            return this;
        }

        @Generated
        public AppBuilder oAuthStateService(OAuthStateService oAuthStateService) {
            this.oAuthStateService = oAuthStateService;
            return this;
        }

        @Generated
        public AppBuilder oAuthSuccessHandler(OAuthSuccessHandler oAuthSuccessHandler) {
            this.oAuthSuccessHandler = oAuthSuccessHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthV2SuccessHandler(OAuthV2SuccessHandler oAuthV2SuccessHandler) {
            this.oAuthV2SuccessHandler = oAuthV2SuccessHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthErrorHandler(OAuthErrorHandler oAuthErrorHandler) {
            this.oAuthErrorHandler = oAuthErrorHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthAccessErrorHandler(OAuthAccessErrorHandler oAuthAccessErrorHandler) {
            this.oAuthAccessErrorHandler = oAuthAccessErrorHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthV2AccessErrorHandler(OAuthV2AccessErrorHandler oAuthV2AccessErrorHandler) {
            this.oAuthV2AccessErrorHandler = oAuthV2AccessErrorHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthStateErrorHandler(OAuthStateErrorHandler oAuthStateErrorHandler) {
            this.oAuthStateErrorHandler = oAuthStateErrorHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthExceptionHandler(OAuthExceptionHandler oAuthExceptionHandler) {
            this.oAuthExceptionHandler = oAuthExceptionHandler;
            return this;
        }

        @Generated
        public AppBuilder oAuthCallbackService(OAuthCallbackService oAuthCallbackService) {
            this.oAuthCallbackService = oAuthCallbackService;
            return this;
        }

        @Generated
        public App build() {
            return new App(this.appConfig, this.slack, this.middlewareList, this.status, this.installationService, this.oAuthStateService, this.oAuthSuccessHandler, this.oAuthV2SuccessHandler, this.oAuthErrorHandler, this.oAuthAccessErrorHandler, this.oAuthV2AccessErrorHandler, this.oAuthStateErrorHandler, this.oAuthExceptionHandler, this.oAuthCallbackService);
        }

        @Generated
        public String toString() {
            return "App.AppBuilder(appConfig=" + this.appConfig + ", slack=" + this.slack + ", middlewareList=" + this.middlewareList + ", status=" + (Object)((Object)this.status) + ", installationService=" + this.installationService + ", oAuthStateService=" + this.oAuthStateService + ", oAuthSuccessHandler=" + this.oAuthSuccessHandler + ", oAuthV2SuccessHandler=" + this.oAuthV2SuccessHandler + ", oAuthErrorHandler=" + this.oAuthErrorHandler + ", oAuthAccessErrorHandler=" + this.oAuthAccessErrorHandler + ", oAuthV2AccessErrorHandler=" + this.oAuthV2AccessErrorHandler + ", oAuthStateErrorHandler=" + this.oAuthStateErrorHandler + ", oAuthExceptionHandler=" + this.oAuthExceptionHandler + ", oAuthCallbackService=" + this.oAuthCallbackService + ")";
        }
    }

    static class BoltEventPayload
    implements EventsApiPayload<Event> {
        private String token;
        private String enterpriseId;
        private String teamId;
        private String apiAppId;
        private String type;
        private List<String> authedUsers;
        private List<String> authedTeams;
        private String eventId;
        private Integer eventTime;
        private transient Event event;

        @Generated
        public BoltEventPayload() {
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public String getEnterpriseId() {
            return this.enterpriseId;
        }

        @Generated
        public String getTeamId() {
            return this.teamId;
        }

        @Generated
        public String getApiAppId() {
            return this.apiAppId;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public List<String> getAuthedUsers() {
            return this.authedUsers;
        }

        @Generated
        public List<String> getAuthedTeams() {
            return this.authedTeams;
        }

        @Generated
        public String getEventId() {
            return this.eventId;
        }

        @Generated
        public Integer getEventTime() {
            return this.eventTime;
        }

        @Generated
        public Event getEvent() {
            return this.event;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public void setEnterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @Generated
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Generated
        public void setApiAppId(String apiAppId) {
            this.apiAppId = apiAppId;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setAuthedUsers(List<String> authedUsers) {
            this.authedUsers = authedUsers;
        }

        @Generated
        public void setAuthedTeams(List<String> authedTeams) {
            this.authedTeams = authedTeams;
        }

        @Generated
        public void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Generated
        public void setEventTime(Integer eventTime) {
            this.eventTime = eventTime;
        }

        @Generated
        public void setEvent(Event event) {
            this.event = event;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BoltEventPayload)) {
                return false;
            }
            BoltEventPayload other = (BoltEventPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$enterpriseId = this.getEnterpriseId();
            String other$enterpriseId = other.getEnterpriseId();
            if (this$enterpriseId == null ? other$enterpriseId != null : !this$enterpriseId.equals(other$enterpriseId)) {
                return false;
            }
            String this$teamId = this.getTeamId();
            String other$teamId = other.getTeamId();
            if (this$teamId == null ? other$teamId != null : !this$teamId.equals(other$teamId)) {
                return false;
            }
            String this$apiAppId = this.getApiAppId();
            String other$apiAppId = other.getApiAppId();
            if (this$apiAppId == null ? other$apiAppId != null : !this$apiAppId.equals(other$apiAppId)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<String> this$authedUsers = this.getAuthedUsers();
            List<String> other$authedUsers = other.getAuthedUsers();
            if (this$authedUsers == null ? other$authedUsers != null : !((Object)this$authedUsers).equals(other$authedUsers)) {
                return false;
            }
            List<String> this$authedTeams = this.getAuthedTeams();
            List<String> other$authedTeams = other.getAuthedTeams();
            if (this$authedTeams == null ? other$authedTeams != null : !((Object)this$authedTeams).equals(other$authedTeams)) {
                return false;
            }
            String this$eventId = this.getEventId();
            String other$eventId = other.getEventId();
            if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
                return false;
            }
            Integer this$eventTime = this.getEventTime();
            Integer other$eventTime = other.getEventTime();
            return !(this$eventTime == null ? other$eventTime != null : !((Object)this$eventTime).equals(other$eventTime));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BoltEventPayload;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $enterpriseId = this.getEnterpriseId();
            result = result * 59 + ($enterpriseId == null ? 43 : $enterpriseId.hashCode());
            String $teamId = this.getTeamId();
            result = result * 59 + ($teamId == null ? 43 : $teamId.hashCode());
            String $apiAppId = this.getApiAppId();
            result = result * 59 + ($apiAppId == null ? 43 : $apiAppId.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            List<String> $authedUsers = this.getAuthedUsers();
            result = result * 59 + ($authedUsers == null ? 43 : ((Object)$authedUsers).hashCode());
            List<String> $authedTeams = this.getAuthedTeams();
            result = result * 59 + ($authedTeams == null ? 43 : ((Object)$authedTeams).hashCode());
            String $eventId = this.getEventId();
            result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
            Integer $eventTime = this.getEventTime();
            result = result * 59 + ($eventTime == null ? 43 : ((Object)$eventTime).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "App.BoltEventPayload(token=" + this.getToken() + ", enterpriseId=" + this.getEnterpriseId() + ", teamId=" + this.getTeamId() + ", apiAppId=" + this.getApiAppId() + ", type=" + this.getType() + ", authedUsers=" + this.getAuthedUsers() + ", authedTeams=" + this.getAuthedTeams() + ", eventId=" + this.getEventId() + ", eventTime=" + this.getEventTime() + ", event=" + this.getEvent() + ")";
        }
    }

    public static enum Status {
        Running,
        Stopped;

    }
}

