/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.SayUtility;
import com.slack.api.bolt.response.Responder;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;

public class MessageActionContext
extends Context
implements SayUtility {
    private String triggerId;
    private String channelId;
    private String responseUrl;
    private Responder responder;

    public WebhookResponse respond(String text) throws IOException {
        return this.respond(ActionResponse.builder().text(text).build());
    }

    public WebhookResponse respond(List<LayoutBlock> blocks) throws IOException {
        return this.respond(ActionResponse.builder().blocks(blocks).build());
    }

    public WebhookResponse respond(ActionResponse response) throws IOException {
        if (this.responder == null) {
            this.responder = new Responder(this.slack, this.responseUrl);
        }
        return this.responder.send(response);
    }

    public WebhookResponse respond(BuilderConfigurator<ActionResponse.ActionResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(ActionResponse.builder()).build());
    }

    @Generated
    public static MessageActionContextBuilder builder() {
        return new MessageActionContextBuilder();
    }

    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @Generated
    public String getChannelId() {
        return this.channelId;
    }

    @Generated
    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Generated
    public Responder getResponder() {
        return this.responder;
    }

    @Generated
    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    @Generated
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    @Generated
    public void setResponseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
    }

    @Generated
    public void setResponder(Responder responder) {
        this.responder = responder;
    }

    @Generated
    public MessageActionContext() {
    }

    @Generated
    public MessageActionContext(String triggerId, String channelId, String responseUrl, Responder responder) {
        this.triggerId = triggerId;
        this.channelId = channelId;
        this.responseUrl = responseUrl;
        this.responder = responder;
    }

    @Override
    @Generated
    public String toString() {
        return "MessageActionContext(super=" + super.toString() + ", triggerId=" + this.getTriggerId() + ", channelId=" + this.getChannelId() + ", responseUrl=" + this.getResponseUrl() + ", responder=" + this.getResponder() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageActionContext)) {
            return false;
        }
        MessageActionContext other = (MessageActionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$responseUrl = this.getResponseUrl();
        String other$responseUrl = other.getResponseUrl();
        if (this$responseUrl == null ? other$responseUrl != null : !this$responseUrl.equals(other$responseUrl)) {
            return false;
        }
        Responder this$responder = this.getResponder();
        Responder other$responder = other.getResponder();
        return !(this$responder == null ? other$responder != null : !this$responder.equals(other$responder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageActionContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $responseUrl = this.getResponseUrl();
        result = result * 59 + ($responseUrl == null ? 43 : $responseUrl.hashCode());
        Responder $responder = this.getResponder();
        result = result * 59 + ($responder == null ? 43 : $responder.hashCode());
        return result;
    }

    @Generated
    public static class MessageActionContextBuilder {
        @Generated
        private String triggerId;
        @Generated
        private String channelId;
        @Generated
        private String responseUrl;
        @Generated
        private Responder responder;

        @Generated
        MessageActionContextBuilder() {
        }

        @Generated
        public MessageActionContextBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        @Generated
        public MessageActionContextBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        @Generated
        public MessageActionContextBuilder responseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        @Generated
        public MessageActionContextBuilder responder(Responder responder) {
            this.responder = responder;
            return this;
        }

        @Generated
        public MessageActionContext build() {
            return new MessageActionContext(this.triggerId, this.channelId, this.responseUrl, this.responder);
        }

        @Generated
        public String toString() {
            return "MessageActionContext.MessageActionContextBuilder(triggerId=" + this.triggerId + ", channelId=" + this.channelId + ", responseUrl=" + this.responseUrl + ", responder=" + this.responder + ")";
        }
    }
}

