/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin.oauth.default_impl;

import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.builtin.oauth.OAuthV2AccessErrorHandler;
import com.slack.api.methods.response.oauth.OAuthV2AccessResponse;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthV2DefaultAccessErrorHandler
implements OAuthV2AccessErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthV2DefaultAccessErrorHandler.class);

    @Override
    public Response handle(OAuthCallbackRequest req, Response response, OAuthV2AccessResponse apiResponse) {
        log.error("Failed to run an oauth.v2.access API call: {} - {}", (Object)apiResponse.getError(), (Object)apiResponse);
        response.setStatusCode(302);
        response.getHeaders().put("Location", Arrays.asList(req.getContext().getOauthCancellationUrl()));
        return response;
    }
}

