/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.IOUtils;
import com.slack.api.bolt.model.Bot;
import com.slack.api.bolt.model.Installer;
import com.slack.api.bolt.model.builtin.DefaultBot;
import com.slack.api.bolt.model.builtin.DefaultInstaller;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.bolt.util.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3InstallationService
implements InstallationService {
    private static final Logger log = LoggerFactory.getLogger(AmazonS3InstallationService.class);
    private final String bucketName;
    private boolean historicalDataEnabled;

    public AmazonS3InstallationService(String bucketName) {
        this.bucketName = bucketName;
    }

    @Override
    public boolean isHistoricalDataEnabled() {
        return this.historicalDataEnabled;
    }

    @Override
    public void setHistoricalDataEnabled(boolean isHistoricalDataEnabled) {
        this.historicalDataEnabled = isHistoricalDataEnabled;
    }

    @Override
    public void saveInstallerAndBot(Installer i) throws Exception {
        AmazonS3 s3 = this.createS3Client();
        if (this.isHistoricalDataEnabled()) {
            this.save(s3, this.getInstallerKey(i) + "-latest", JsonOps.toJsonString(i), "AWS S3 putObject result of Installer data - {}, {}");
            this.save(s3, this.getBotKey(i) + "-latest", JsonOps.toJsonString(i.toBot()), "AWS S3 putObject result of Bot data - {}, {}");
            this.save(s3, this.getInstallerKey(i) + "-" + i.getInstalledAt(), JsonOps.toJsonString(i), "AWS S3 putObject result of Installer data - {}, {}");
            this.save(s3, this.getBotKey(i) + "-" + i.getInstalledAt(), JsonOps.toJsonString(i.toBot()), "AWS S3 putObject result of Bot data - {}, {}");
        } else {
            this.save(s3, this.getInstallerKey(i), JsonOps.toJsonString(i), "AWS S3 putObject result of Installer data - {}, {}");
            this.save(s3, this.getBotKey(i), JsonOps.toJsonString(i.toBot()), "AWS S3 putObject result of Bot data - {}, {}");
        }
    }

    private void save(AmazonS3 s3, String s3Key, String json, String logMessage) {
        PutObjectResult botPutResult = s3.putObject(this.bucketName, s3Key, json);
        if (log.isDebugEnabled()) {
            log.debug(logMessage, (Object)s3Key, (Object)JsonOps.toJsonString(botPutResult));
        }
    }

    @Override
    public void deleteBot(Bot bot) throws Exception {
        AmazonS3 s3 = this.createS3Client();
        String key = this.getBotKey(bot.getEnterpriseId(), bot.getTeamId());
        if (this.isHistoricalDataEnabled()) {
            key = key + "-latest";
        }
        s3.deleteObject(this.bucketName, key);
    }

    @Override
    public void deleteInstaller(Installer installer) throws Exception {
        AmazonS3 s3 = this.createS3Client();
        String key = this.getInstallerKey(installer);
        if (this.isHistoricalDataEnabled()) {
            key = key + "-latest";
        }
        s3.deleteObject(this.bucketName, key);
    }

    @Override
    public Bot findBot(String enterpriseId, String teamId) {
        AmazonS3 s3 = this.createS3Client();
        String fullKey = this.getBotKey(enterpriseId, teamId);
        if (this.isHistoricalDataEnabled()) {
            fullKey = fullKey + "-latest";
        }
        if (this.getObjectMetadata(s3, fullKey) == null && enterpriseId != null) {
            S3Object nonGridObject;
            String nonGridKey = this.getBotKey(null, teamId);
            if (this.isHistoricalDataEnabled()) {
                nonGridKey = nonGridKey + "-latest";
            }
            if ((nonGridObject = this.getObject(s3, nonGridKey)) != null) {
                try {
                    Bot bot = this.toBot(nonGridObject);
                    bot.setEnterpriseId(enterpriseId);
                    this.save(s3, fullKey, JsonOps.toJsonString(bot), "AWS S3 putObject result of Bot data - {}");
                    return bot;
                }
                catch (Exception e) {
                    log.error("Failed to save a new Bot data for enterprise_id: {}, team_id: {}", (Object)enterpriseId, (Object)teamId);
                }
            }
        }
        S3Object s3Object = this.getObject(s3, fullKey);
        try {
            return this.toBot(s3Object);
        }
        catch (IOException e) {
            log.error("Failed to load Bot data for enterprise_id: {}, team_id: {}", (Object)enterpriseId, (Object)teamId);
            return null;
        }
    }

    @Override
    public Installer findInstaller(String enterpriseId, String teamId, String userId) {
        AmazonS3 s3 = this.createS3Client();
        String fullKey = this.getInstallerKey(enterpriseId, teamId, userId);
        if (this.isHistoricalDataEnabled()) {
            fullKey = fullKey + "-latest";
        }
        if (this.getObjectMetadata(s3, fullKey) == null && enterpriseId != null) {
            S3Object nonGridObject;
            String nonGridKey = this.getInstallerKey(null, teamId, userId);
            if (this.isHistoricalDataEnabled()) {
                nonGridKey = nonGridKey + "-latest";
            }
            if ((nonGridObject = this.getObject(s3, nonGridKey)) != null) {
                try {
                    Installer installer = this.toInstaller(nonGridObject);
                    installer.setEnterpriseId(enterpriseId);
                    this.saveInstallerAndBot(installer);
                    return installer;
                }
                catch (Exception e) {
                    log.error("Failed to save a new Installer data for enterprise_id: {}, team_id: {}, user_id: {}", new Object[]{enterpriseId, teamId, userId});
                }
            }
        }
        S3Object s3Object = this.getObject(s3, fullKey);
        try {
            return this.toInstaller(s3Object);
        }
        catch (Exception e) {
            log.error("Failed to save a new Installer data for enterprise_id: {}, team_id: {}, user_id: {}", new Object[]{enterpriseId, teamId, userId});
            return null;
        }
    }

    private ObjectMetadata getObjectMetadata(AmazonS3 s3, String fullKey) {
        try {
            return s3.getObjectMetadata(this.bucketName, fullKey);
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    private S3Object getObject(AmazonS3 s3, String fullKey) {
        try {
            return s3.getObject(this.bucketName, fullKey);
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    private Bot toBot(S3Object s3Object) throws IOException {
        if (s3Object == null) {
            return null;
        }
        String json = IOUtils.toString((InputStream)s3Object.getObjectContent());
        return JsonOps.fromJson(json, DefaultBot.class);
    }

    private Installer toInstaller(S3Object s3Object) throws IOException {
        if (s3Object == null) {
            return null;
        }
        String json = IOUtils.toString((InputStream)s3Object.getObjectContent());
        return JsonOps.fromJson(json, DefaultInstaller.class);
    }

    private AmazonS3 createS3Client() {
        return AmazonS3ClientBuilder.defaultClient();
    }

    private String getInstallerKey(Installer i) {
        return this.getInstallerKey(i.getEnterpriseId(), i.getTeamId(), i.getInstallerUserId());
    }

    private String getInstallerKey(String enterpriseId, String teamId, String userId) {
        return "installer/" + Optional.ofNullable(enterpriseId).orElse("none") + "-" + teamId + "-" + userId;
    }

    private String getBotKey(Installer i) {
        return this.getBotKey(i.getEnterpriseId(), i.getTeamId());
    }

    private String getBotKey(String enterpriseId, String teamId) {
        return "bot/" + Optional.ofNullable(enterpriseId).orElse("none") + "-" + teamId;
    }
}

