/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.oauth.payload.VerificationCodePayload;
import com.slack.api.bolt.context.builtin.OAuthCallbackContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import java.util.List;
import java.util.Map;

public class OAuthCallbackRequest
extends Request<OAuthCallbackContext> {
    private final Map<String, List<String>> queryString;
    private final String requestBody;
    private final RequestHeaders headers;
    private final VerificationCodePayload payload;
    private OAuthCallbackContext context = new OAuthCallbackContext();

    public OAuthCallbackRequest(Map<String, List<String>> queryString, String requestBody, VerificationCodePayload payload, RequestHeaders headers) {
        this.queryString = queryString;
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = payload;
    }

    @Override
    public OAuthCallbackContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.OAuthCallback;
    }

    @Override
    public Map<String, List<String>> getQueryString() {
        return this.queryString;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public VerificationCodePayload getPayload() {
        return this.payload;
    }

    @Override
    public String toString() {
        return "OAuthCallbackRequest(super=" + super.toString() + ", queryString=" + this.getQueryString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

