/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin.oauth.default_impl;

import com.slack.api.bolt.request.builtin.OAuthCallbackRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.builtin.oauth.OAuthAccessErrorHandler;
import com.slack.api.methods.response.oauth.OAuthAccessResponse;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthDefaultAccessErrorHandler
implements OAuthAccessErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthDefaultAccessErrorHandler.class);

    @Override
    public Response handle(OAuthCallbackRequest request, Response response, OAuthAccessResponse apiResponse) {
        log.error("Failed to run an oauth.access API call: {} - {}", (Object)apiResponse.getError(), (Object)apiResponse);
        response.setStatusCode(302);
        response.getHeaders().put("Location", Arrays.asList(request.getContext().getOauthCancellationUrl()));
        return response;
    }
}

