/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import se.vidstige.jadb.ConnectionToRemoteDeviceException;
import se.vidstige.jadb.DeviceDetectionListener;
import se.vidstige.jadb.DeviceWatcher;
import se.vidstige.jadb.HostConnectToRemoteTcpDevice;
import se.vidstige.jadb.HostDisconnectFromRemoteTcpDevice;
import se.vidstige.jadb.ITransportFactory;
import se.vidstige.jadb.JadbDevice;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.Transport;

public class JadbConnection
implements ITransportFactory {
    private final String host;
    private final int port;
    private static final int DEFAULTPORT = 5037;

    public JadbConnection() {
        this("localhost", 5037);
    }

    public JadbConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public Transport createTransport() throws IOException {
        return new Transport(new Socket(this.host, this.port));
    }

    public String getHostVersion() throws IOException, JadbException {
        Transport main = this.createTransport();
        main.send("host:version");
        main.verifyResponse();
        String version = main.readString();
        main.close();
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress connectToTcpDevice(InetSocketAddress inetSocketAddress) throws IOException, JadbException, ConnectionToRemoteDeviceException {
        try (Transport transport = this.createTransport();){
            InetSocketAddress inetSocketAddress2 = new HostConnectToRemoteTcpDevice(transport).connect(inetSocketAddress);
            return inetSocketAddress2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress disconnectFromTcpDevice(InetSocketAddress tcpAddressEntity) throws IOException, JadbException, ConnectionToRemoteDeviceException {
        try (Transport transport = this.createTransport();){
            InetSocketAddress inetSocketAddress = new HostDisconnectFromRemoteTcpDevice(transport).disconnect(tcpAddressEntity);
            return inetSocketAddress;
        }
    }

    public List<JadbDevice> getDevices() throws IOException, JadbException {
        Transport devices = this.createTransport();
        devices.send("host:devices");
        devices.verifyResponse();
        String body = devices.readString();
        devices.close();
        return this.parseDevices(body);
    }

    public DeviceWatcher createDeviceWatcher(DeviceDetectionListener listener) throws IOException, JadbException {
        Transport transport = this.createTransport();
        transport.send("host:track-devices");
        transport.verifyResponse();
        return new DeviceWatcher(transport, listener, this);
    }

    public List<JadbDevice> parseDevices(String body) {
        String[] lines = body.split("\n");
        ArrayList<JadbDevice> devices = new ArrayList<JadbDevice>(lines.length);
        for (String line : lines) {
            String[] parts = line.split("\t");
            if (parts.length <= 1) continue;
            devices.add(new JadbDevice(parts[0], this));
        }
        return devices;
    }

    public JadbDevice getAnyDevice() {
        return JadbDevice.createAny(this);
    }
}

