/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.support.Commons;

public class Crawler {
    static String className = "";
    static String classOuter = "";
    static boolean shouldReflect = false;
    static boolean onlyMissing = false;
    static boolean noComments = false;
    static boolean rawPublic = false;
    static boolean shouldCreate = false;
    static String packg;
    static String thisPackg;
    static File sourceBase;
    static List<Map<String, List<String>>> classes;
    static String[] strings;
    static String NL;
    static int lineNumber;
    static List<String> classNames;
    static boolean inComment;
    static String currentComment;
    static String lastComment;
    private static List<List<String>> functionDocs;
    private static final String pyMethod = ".. py:class:: %s\n\n\t.. py:method:: %s\n\n\t\t%s\n\n%s\t\t:return: %s\n";
    private static String pyMethodParams;

    private static void p(String message, Object ... args) {
        if (args.length == 0) {
            return;
        }
        if (message.isEmpty()) {
            message = "%s";
        }
        System.out.println(String.format(message, args));
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        for (String arg : args) {
            if (arg.equals("*")) {
                shouldCreate = true;
                continue;
            }
            if (arg.equals("!")) {
                rawPublic = true;
                continue;
            }
            if (arg.equals("+")) {
                shouldReflect = true;
                continue;
            }
            if (arg.equals("?")) {
                onlyMissing = true;
                continue;
            }
            if (arg.equals("-")) {
                noComments = true;
                continue;
            }
            if (arg.startsWith("#")) break;
            if (arg.endsWith(".")) {
                thisPackg = packg + arg;
                continue;
            }
            if (rawPublic) {
                shouldReflect = false;
                onlyMissing = false;
                noComments = false;
            }
            className = thisPackg + arg;
            classOuter = arg;
            String fpSource = sourceBase.getAbsolutePath() + "/" + className.replace(".", "/") + ".java";
            File fSource = new File(fpSource);
            if (!fSource.exists()) {
                Crawler.p("ERROR: not exists %s", fSource);
                System.exit(1);
            }
            if (shouldReflect) {
                Crawler.crawlLines(fSource, true);
                Crawler.crawlClass(className);
                Crawler.printFunctions();
            }
            if (rawPublic || noComments || onlyMissing || shouldCreate) {
                Crawler.commentReset();
                Crawler.crawlLines(fSource, false);
                if (shouldCreate) {
                    Crawler.createPyMethods();
                }
            }
            onlyMissing = false;
            noComments = false;
            shouldReflect = false;
        }
    }

    static void crawlClass(String className) {
        String orgSignature = "";
        String signature = "";
        boolean isInner = false;
        for (String clazz : classNames) {
            HashMap<String, List<String>> functions = new HashMap<String, List<String>>();
            try {
                int modifiers;
                Class<?> aClass;
                if (className.endsWith(clazz)) {
                    aClass = Class.forName(className);
                } else {
                    aClass = Class.forName(className + "$" + clazz);
                    className = className + "." + clazz;
                }
                String cName = aClass.getSimpleName();
                String superClass = aClass.getSuperclass().getSimpleName();
                ArrayList<String> classInfo = new ArrayList<String>();
                classInfo.add(String.format("%s (%s)", className, superClass));
                if (isInner) {
                    classInfo.add(classOuter);
                }
                functions.put("#name", classInfo);
                Method[] declaredMethods = aClass.getDeclaredMethods();
                Constructor<?>[] declaredConstructors = aClass.getDeclaredConstructors();
                Field[] declaredFields = aClass.getDeclaredFields();
                for (Constructor<?> constructor : declaredConstructors) {
                    modifiers = constructor.getModifiers();
                    if ((modifiers & 1) == 0) continue;
                    String constrName = constructor.getName().replace(thisPackg, "");
                    if (isInner) {
                        constrName = constrName.split("\\$")[1];
                    }
                    String params = "()";
                    String hasThrows = "";
                    if (constructor.getExceptionTypes().length > 0) {
                        hasThrows = String.format("!%s", constructor.getExceptionTypes());
                    }
                    if (constructor.getParameterCount() > 0) {
                        throw new SikuliXception("Constructor Params ?? " + constructor.toGenericString());
                    }
                    signature = constrName + params + hasThrows;
                    if (functions.containsKey(" ")) {
                        ((List)functions.get(" ")).add(signature);
                        continue;
                    }
                    ArrayList<String> signatures = new ArrayList<String>();
                    signatures.add(signature);
                    functions.put(" ", signatures);
                }
                for (Executable executable : declaredMethods) {
                    String returns;
                    modifiers = ((Method)executable).getModifiers();
                    if ((modifiers & 1) == 0) continue;
                    boolean isStatic = (modifiers & 8) == 1;
                    String methName = ((Method)executable).getName().replace(thisPackg, "");
                    if (isInner) {
                        methName = methName.split("\\$")[1];
                    }
                    String parameter = "()";
                    String hasThrows = "";
                    if (((Method)executable).getExceptionTypes().length > 0) {
                        hasThrows = String.format(" !%s", ((Method)executable).getExceptionTypes());
                    }
                    if (((Method)executable).getParameterCount() > 0) {
                        String genericString = ((Method)executable).toGenericString();
                        Type[] gpTypes = ((Method)executable).getGenericParameterTypes();
                        String[] parameters = new String[gpTypes.length];
                        int n = 0;
                        for (Type param : gpTypes) {
                            parameters[n] = param.getTypeName();
                            ++n;
                        }
                        parameter = String.format("%s", gpTypes);
                    }
                    signature = "void".equals(returns = ((Method)executable).getReturnType().toString()) ? parameter + " void" + hasThrows : String.format("%s -> %s%s", returns, parameter, hasThrows);
                    String getterSetter = "";
                    String function = methName;
                    if (function.startsWith("get") || function.startsWith("set")) {
                        getterSetter = function.substring(0, 3);
                        function = function.substring(3);
                    }
                    if (isStatic) {
                        function = "!" + function;
                    }
                    if (!getterSetter.isEmpty()) {
                        function = "+" + function;
                    }
                    if (functions.containsKey(function)) {
                        ((List)functions.get(function)).add(signature);
                        continue;
                    }
                    ArrayList<String> signatures = new ArrayList<String>();
                    signatures.add(signature);
                    functions.put(function, signatures);
                }
                ArrayList<String> notBeans = new ArrayList<String>();
                for (String function : functions.keySet()) {
                    if (!function.startsWith("+")) continue;
                    int n = 0;
                    int nSet = 0;
                    for (String sig : (List)functions.get(function)) {
                        if (sig.startsWith("get")) {
                            ++n;
                            continue;
                        }
                        if (!sig.startsWith("set")) continue;
                        ++nSet;
                    }
                    if (nSet > 0 && n > 0) continue;
                    String name = function.substring(1);
                    String makeStatic = "";
                    if (name.startsWith("!")) {
                        makeStatic = "!";
                        name = function.substring(2);
                    }
                    notBeans.add(makeStatic + (n > 0 ? "get" : "set") + name);
                }
                if (notBeans.size() > 0) {
                    for (String function : notBeans) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int from = 3;
                        String prefix = "+";
                        if (function.startsWith("!")) {
                            from = 4;
                            prefix = prefix + "!";
                        }
                        List listSignatures = (List)functions.remove(prefix + function.substring(from));
                        for (String sig : listSignatures) {
                            sig = sig.replace("get", "").replace("set", "");
                            arrayList.add(sig);
                        }
                        functions.put(function, arrayList);
                    }
                }
                classes.add(Crawler.sortMap(functions));
            }
            catch (Exception e) {
                Crawler.p("Error: class %s (%s)", className, orgSignature);
            }
            isInner = true;
        }
    }

    static void printFunctions() {
        for (Map<String, List<String>> clazz : classes) {
            Crawler.p("%-20s : %s", "----- Class -----", clazz.get("#name"));
            for (String function : clazz.keySet()) {
                if (function.startsWith("#")) continue;
                String name = function;
                if (function.startsWith("+")) {
                    name = "+" + function.substring(1, 2).toLowerCase() + function.substring(2);
                }
                Crawler.p("%-20s : %s", name, clazz.get(function));
            }
        }
    }

    static Map<String, List<String>> sortMap(Map<String, List<String>> map) {
        ArrayList<Map.Entry<String, List<String>>> entries = new ArrayList<Map.Entry<String, List<String>>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, List<String>>>(){

            @Override
            public int compare(Map.Entry<String, List<String>> o1, Map.Entry<String, List<String>> o2) {
                return o1.getKey().toLowerCase().compareTo(o2.getKey().toLowerCase());
            }
        });
        LinkedHashMap<String, List<String>> sortedMap = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : entries) {
            sortedMap.put((String)entry.getKey(), (List)entry.getValue());
        }
        return sortedMap;
    }

    static void crawlLines(File fSource, boolean onlyClasses) {
        try {
            Stream<String> lines = Files.lines(Paths.get(fSource.getAbsolutePath(), new String[0]));
            lines.forEach(line -> Crawler.processLine(line, onlyClasses));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void processLine(String line, boolean onlyClasses) {
        ++lineNumber;
        if ((line = line.trim()).isEmpty() || line.startsWith("@")) {
            return;
        }
        if (!onlyClasses && line.startsWith("//")) {
            if (!onlyMissing && line.startsWith("//<editor-fold")) {
                if (noComments) {
                    NL = "";
                }
                Crawler.p("%s(%d) %s", NL, lineNumber, line);
                NL = "";
            }
            return;
        }
        if (line.startsWith("public") && (rawPublic || onlyClasses)) {
            if (onlyClasses && !line.contains("class ")) {
                return;
            }
            classNames.add(line.substring(line.indexOf("class ") + 6).split("\\s")[0]);
            if (rawPublic) {
                Crawler.p("(%d) %s", lineNumber, line);
            }
            return;
        }
        if (line.startsWith("/**")) {
            if (inComment) {
                Crawler.commentReset();
            } else {
                inComment = true;
            }
            return;
        }
        if (line.startsWith("public") && line.endsWith("{")) {
            if (!line.contains("class")) {
                line = line.substring(7, line.length() - 1).trim();
                boolean isStatic = false;
                if (line.startsWith("static")) {
                    isStatic = true;
                    line = line.substring(7);
                }
                String function = line;
                if (line.startsWith("<")) {
                    int end = line.indexOf(">");
                    if (end < 0) {
                        Crawler.p("ERROR: unbalanced <>: %s", line);
                        System.exit(1);
                    }
                    function = line.substring(end + 2);
                }
                if (isStatic) {
                    function = "!" + function;
                }
                String docs = lastComment;
                boolean hasDocs = true;
                if (docs.isEmpty()) {
                    hasDocs = false;
                }
                if (hasDocs) {
                    ArrayList<String> item = new ArrayList<String>();
                    item.add(function);
                    item.add(docs);
                    functionDocs.add(item);
                }
                if (!onlyMissing || onlyMissing && !hasDocs) {
                    if (hasDocs) {
                        if (noComments) {
                            Crawler.p("(%d) %s", lineNumber, function);
                        } else {
                            Crawler.p("%s\n(%d) %s", docs, lineNumber, function);
                        }
                    } else {
                        Crawler.p("(%d) ?doc? %s", lineNumber, function);
                    }
                }
            }
            NL = "\n";
            Crawler.commentResetAll();
            return;
        }
        if (inComment && line.startsWith("*")) {
            if (line.startsWith("*/")) {
                Crawler.commentReset();
            } else {
                if (line.startsWith("*")) {
                    line = line.substring(1);
                }
                Crawler.commentAddLine(line);
            }
        }
    }

    static void commentReset() {
        inComment = false;
        lastComment = currentComment;
        currentComment = "";
    }

    static void commentResetAll() {
        inComment = false;
        lastComment = "";
        currentComment = "";
    }

    static void commentAddLine(String line) {
        if (currentComment.isEmpty()) {
            line = "---\n" + line;
        }
        currentComment = currentComment + "\n" + line;
    }

    private static String createPyMethod(String clazz, String method, String text, Map<String, String> params, String returns) {
        String docParams = "";
        for (String pName : params.keySet()) {
            docParams = docParams + String.format(pyMethodParams, pName, params.get(pName));
        }
        String docMethod = String.format(pyMethod, clazz, method, docParams, returns);
        return docMethod;
    }

    private static void createPyMethods() {
        String clazz = className.substring(className.lastIndexOf(".") + 1);
        String[] docItems = null;
        for (List<String> functionDoc : functionDocs) {
            String function = functionDoc.get(0);
            String docReturn = "";
            LinkedHashMap<String, String> docParams = new LinkedHashMap<String, String>();
            String doc = functionDoc.get(1);
            docItems = doc.split("\\n @");
            if (docItems.length <= 1) continue;
            String pyDoc = docItems[0].substring(4);
            for (int n = 1; n < docItems.length; ++n) {
                String item = docItems[n];
                if (item.startsWith("return ")) {
                    docReturn = item.substring(7);
                    continue;
                }
                if (!item.startsWith("param ")) continue;
                String[] strings = item.substring(6).split("\\s");
                docParams.put(strings[0], item.substring(6 + strings[0].length() + 1));
            }
            Crawler.p("", new Object[0]);
        }
    }

    static {
        thisPackg = packg = "org.sikuli.";
        sourceBase = new File(Commons.getWorkDir(), "/src/main/java");
        classes = new ArrayList<Map<String, List<String>>>();
        NL = "";
        lineNumber = 0;
        classNames = new ArrayList<String>();
        inComment = false;
        currentComment = "";
        lastComment = "";
        functionDocs = new ArrayList<List<String>>();
        pyMethodParams = "\t\t:param %s: %s\n";
    }
}

