/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.sikuli.basics.Debug;
import org.sikuli.util.CommandArgsEnum;

public class CommandArgs {
    private Options cmdArgs;
    ArrayList<String> userArgs = new ArrayList();
    ArrayList<String> sikuliArgs = new ArrayList();
    static String argsOrg = "";

    public CommandArgs() {
        this.init();
    }

    public CommandLine getCommandLine(String[] args) {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        boolean isUserArg = false;
        for (int i = 0; i < args.length; ++i) {
            if (!isUserArg && args[i].startsWith("--")) {
                isUserArg = true;
                continue;
            }
            if (isUserArg) {
                this.userArgs.add(args[i]);
                continue;
            }
            this.sikuliArgs.add(args[i]);
        }
        try {
            cmd = parser.parse(this.cmdArgs, this.sikuliArgs.toArray(new String[0]), true);
        }
        catch (ParseException exp) {
            Debug.error(exp.getMessage(), new Object[0]);
        }
        return cmd;
    }

    public String[] getUserArgs() {
        return this.userArgs.toArray(new String[0]);
    }

    public String[] getSXArgs() {
        return this.sikuliArgs.toArray(new String[0]);
    }

    private void init() {
        this.cmdArgs = new Options();
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.HELP));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.MULTI));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.VERBOSE));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.QUIET));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.DEBUG));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.LOGFILE));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.USERLOGFILE));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.CONSOLE));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.LOAD));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.RUN));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.SERVER));
        this.cmdArgs.addOption(this.makeOption(CommandArgsEnum.PYTHONSERVER));
    }

    private Option makeOption(CommandArgsEnum anOption) {
        Option.Builder builder = Option.builder((String)anOption.shortname()).longOpt(anOption.longname()).desc(anOption.description());
        if (anOption.hasArgs()) {
            builder.hasArgs();
        }
        return builder.build();
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, "\n", "----- Running SikuliX -------------", this.cmdArgs, "-----\n<foobar.sikuli> (.sikuli might be omitted, is assumed)\npath relative to current working directory or absolute path\nthough deprecated: so called executables .skl can be used too\n------\nanything after --\nor after something beginning with --\ngo to script as user parameters (respecting enclosing \")\n------\n-d use this option if you encounter any weird problems\nDebugLevel=3 and all output goes to <workingFolder>/SikuliLog.text\n----------------------------------------------------------------", true);
    }

    public static String[] scanArgs(String[] args) {
        argsOrg = System.getenv("SIKULI_COMMAND");
        if (argsOrg == null) {
            argsOrg = System.getProperty("sikuli.SIKULI_COMMAND");
        }
        if (argsOrg == null) {
            argsOrg = "";
        }
        String sep = "\"";
        String temp = null;
        ArrayList<String> nargs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("asApp")) continue;
            if (arg.startsWith(sep)) {
                if (!arg.endsWith(sep)) {
                    temp = arg.substring(1);
                    continue;
                }
            } else if (arg.endsWith(sep)) {
                if (temp != null) {
                    arg = temp + " " + arg.substring(0, arg.length() - 1);
                    if (argsOrg != null && !argsOrg.contains(arg)) {
                        arg = arg.replace(" ", " *?");
                        Pattern pat = Pattern.compile("(" + arg + ")");
                        Matcher m = pat.matcher(argsOrg);
                        arg = m.find() ? m.group() : "?" + arg + "?";
                    }
                    temp = null;
                }
            } else if (temp != null) {
                temp = temp + " " + arg;
                continue;
            }
            nargs.add(arg);
        }
        return nargs.toArray(new String[0]);
    }

    public String getArgsOrg() {
        return argsOrg;
    }
}

