/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sikuli.basics.Debug;
import org.sikuli.script.Sikulix;
import org.sikuli.script.runnerSupport.JythonSupport;
import org.sikuli.script.runners.AbstractLocalFileScriptRunner;
import org.sikuli.script.support.IScriptRunner;
import org.sikuli.script.support.RunTime;

public class JythonRunner
extends AbstractLocalFileScriptRunner {
    public static final String NAME = "Jython";
    public static final String TYPE = "text/jython";
    public static final String[] EXTENSIONS = new String[]{"py"};
    private static RunTime runTime = RunTime.get();
    private int lvl = 3;
    static JythonSupport jythonSupport = null;
    private static boolean redirected = false;

    @Override
    public boolean isSupported() {
        try {
            Class.forName("org.python.util.PythonInterpreter");
            return true;
        }
        catch (ClassNotFoundException ex) {
            Debug.log(-1, "no Jython on classpath --- consult the docs for a solution, if needed", new Object[0]);
            return false;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getExtensions() {
        return (String[])EXTENSIONS.clone();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isAbortSupported() {
        return true;
    }

    @Override
    public String[] getFileEndings() {
        String[] endings = super.getFileEndings();
        endings = Arrays.copyOf(endings, endings.length + 1);
        endings[endings.length - 1] = "$py.class";
        return endings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInit(String[] param) {
        Class<JythonRunner> clazz = JythonRunner.class;
        synchronized (JythonRunner.class) {
            this.log(this.lvl, "starting initialization", new Object[0]);
            jythonSupport = JythonSupport.get();
            jythonSupport.getSysPath();
            String fpAPILib = JythonRunner.runTime.fSikulixLib.getAbsolutePath();
            jythonSupport.putSysPath(fpAPILib, 0);
            jythonSupport.setSysPath();
            jythonSupport.addSitePackages();
            jythonSupport.showSysPath();
            jythonSupport.interpreterExecString("import sys");
            jythonSupport.interpreterExecString("import org.sikuli.script.support.Runner as Runner");
            String interpreterVersion = jythonSupport.interpreterEval("sys.version.split(\"(\")[0]\n").toString();
            if (interpreterVersion.isEmpty()) {
                interpreterVersion = "could not be evaluated";
            }
            Debug.setWithTimeElapsed();
            this.log(this.lvl, "ready: version %s", interpreterVersion);
            Debug.unsetWithTimeElapsed();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void initAbort() {
        jythonSupport.interpreterExecString("runner = Runner.getRunner(\"Jython\")\ndef trace_calls_for_abort(frame, evt, arg):\n  if runner.isAborted():\n    raise RuntimeError(\"Aborted\")\n  return trace_calls_for_abort\nsys.settrace(trace_calls_for_abort)");
    }

    @Override
    public void doClose() {
        jythonSupport.interpreterClose();
        redirected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doEvalScript(String script, IScriptRunner.Options options) {
        Class<JythonRunner> clazz = JythonRunner.class;
        synchronized (JythonRunner.class) {
            this.initAbort();
            jythonSupport.interpreterExecString(script);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRunScript(String scriptFile, String[] argv, IScriptRunner.Options options) {
        Class<JythonRunner> clazz = JythonRunner.class;
        synchronized (JythonRunner.class) {
            this.initAbort();
            File pyFile = new File(scriptFile);
            jythonSupport.interpreterFillSysArgv(pyFile, argv);
            jythonSupport.executeScriptHeader(codeBefore);
            int exitCode = 0;
            try {
                if (scriptFile.endsWith("$py.class")) {
                    jythonSupport.interpreterExecCode(new File(scriptFile));
                } else {
                    jythonSupport.interpreterExecFile(pyFile.getAbsolutePath());
                }
            }
            catch (Throwable scriptException) {
                if (!this.isAborted()) {
                    String exception;
                    exitCode = 1;
                    Pattern p = Pattern.compile("SystemExit: (-?[0-9]+)");
                    Matcher matcher = p.matcher(exception = scriptException.toString());
                    if (matcher.find()) {
                        exitCode = Integer.parseInt(matcher.group(1));
                        Debug.info("Exit code: " + exitCode, new Object[0]);
                    } else {
                        int errorExit = jythonSupport.findErrorSource(scriptException, pyFile.getAbsolutePath());
                        if (null != options) {
                            options.setErrorLine(errorExit);
                        }
                    }
                }
            }
            finally {
                jythonSupport.interpreterCleanup();
            }
            if (System.out.checkError()) {
                Sikulix.popError("System.out is broken (console output)!\nYou will not see any messages anymore!\nSave your work and restart the IDE!", "Fatal Error");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return exitCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRunLines(String lines, IScriptRunner.Options options) {
        Class<JythonRunner> clazz = JythonRunner.class;
        synchronized (JythonRunner.class) {
            block5: {
                this.initAbort();
                jythonSupport.executeScriptHeader(codeBefore);
                try {
                    jythonSupport.interpreterExecString(lines);
                }
                catch (Exception ex) {
                    if (this.isAborted()) break block5;
                    this.log(-1, "runPython: (%s) raised: %s", "\n" + lines, ex);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doRedirect(PrintStream stdout, PrintStream stderr) {
        Class<JythonRunner> clazz = JythonRunner.class;
        synchronized (JythonRunner.class) {
            if (!redirected) {
                redirected = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return jythonSupport.interpreterRedirect(stdout, stderr);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }
}

