/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.reflect.Array;
import org.sikuli.guide.Visual;

public class SxArrow
extends Visual
implements ComponentListener {
    public static final int STRAIGHT = 0;
    public static final int ELBOW_X = 1;
    public static final int ELBOW_Y = 2;
    int style;
    private Point source = null;
    private Point destination = null;
    private Visual from = null;
    private Visual to = null;
    boolean hasComponents = false;

    public SxArrow(Point from, Point to) {
        this.source = from;
        this.destination = to;
        this.init();
    }

    public SxArrow(Visual from, Visual to) {
        this.hasComponents = true;
        this.from = from;
        this.to = to;
        from.addComponentListener(this);
        to.addComponentListener(this);
        this.init();
    }

    private void init() {
        this.colorFront = Color.RED;
        this.style = 0;
        this.updateComponent();
    }

    @Override
    public void updateComponent() {
        this.setForeground(this.colorFront);
        Rectangle dirtyBounds = this.getBounds();
        if (this.from != null && this.to != null) {
            this.source = this.from.getCenter();
            this.destination = this.to.getCenter();
        }
        Rectangle r = new Rectangle(this.getSource());
        r.add(this.getDestination());
        r.grow(10, 10);
        this.setActualBounds(r);
        dirtyBounds.add(this.getBounds());
        if (this.getTopLevelAncestor() != null) {
            this.getTopLevelAncestor().repaint(dirtyBounds.x, dirtyBounds.y, dirtyBounds.width, dirtyBounds.height);
        }
        if (this.hasComponents) {
            this.updateVisibility();
        }
    }

    public void setStyle(int style) {
        this.style = style;
    }

    private void drawPolylineArrow(Graphics g, int[] xPoints, int[] yPoints, int headLength, int headwidth) {
        Object tempX1 = Array.get(xPoints, xPoints.length - 2);
        Object tempX2 = Array.get(xPoints, xPoints.length - 1);
        Integer fooX1 = (Integer)tempX1;
        int x1 = fooX1;
        Integer fooX2 = (Integer)tempX2;
        int x2 = fooX2;
        Object tempY1 = Array.get(yPoints, yPoints.length - 2);
        Object tempY2 = Array.get(yPoints, yPoints.length - 1);
        Integer fooY1 = (Integer)tempY1;
        int y1 = fooY1;
        Integer fooY2 = (Integer)tempY2;
        int y2 = fooY2;
        int deltaX = x2 - x1;
        int deltaY = y2 - y1;
        double theta = Math.atan((double)deltaY / (double)deltaX);
        double theta1 = (double)deltaX < 0.0 ? theta + Math.PI : theta;
        int lengthdeltaX = -((int)(Math.cos(theta1) * (double)headLength));
        int lengthdeltaY = -((int)(Math.sin(theta1) * (double)headLength));
        int widthdeltaX = (int)(Math.sin(theta1) * (double)headwidth);
        int widthdeltaY = (int)(Math.cos(theta1) * (double)headwidth);
        g.drawPolyline(xPoints, yPoints, xPoints.length);
        g.drawLine(x2, y2, x2 + lengthdeltaX + widthdeltaX, y2 + lengthdeltaY - widthdeltaY);
        g.drawLine(x2, y2, x2 + lengthdeltaX - widthdeltaX, y2 + lengthdeltaY + widthdeltaY);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle r = this.getActualBounds();
        BasicStroke pen = new BasicStroke(3.0f);
        g2d.setStroke(pen);
        g2d.translate(-r.x, -r.y);
        if (this.style == 0) {
            this.drawPolylineArrow(g, new int[]{this.getSource().x, this.getDestination().x}, new int[]{this.getSource().y, this.getDestination().y}, 6, 6);
        } else if (this.style == 1) {
            Point m = new Point(this.getDestination().x, this.getSource().y);
            g2d.drawLine(this.getSource().x, this.getSource().y, m.x, m.y);
            this.drawPolylineArrow(g, new int[]{m.x, this.getDestination().x}, new int[]{m.y, this.getDestination().y}, 6, 6);
        } else if (this.style == 2) {
            Point m = new Point(this.getSource().x, this.getDestination().y);
            g2d.drawLine(this.getSource().x, this.getSource().y, m.x, m.y);
            this.drawPolylineArrow(g, new int[]{m.x, this.getDestination().x}, new int[]{m.y, this.getDestination().y}, 6, 6);
        }
    }

    public void setDestination(Point destination) {
        this.destination = destination;
        this.updateComponent();
    }

    public Point getDestination() {
        return this.destination;
    }

    public void setSource(Point source) {
        this.source = source;
        this.updateComponent();
    }

    public Point getSource() {
        return this.source;
    }

    void updateVisibility() {
        this.setVisible(this.from.isVisible() && this.to.isVisible());
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
        this.updateVisibility();
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        this.updateComponent();
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
        this.updateComponent();
        this.updateVisibility();
    }
}

