/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class SocketServer
implements Runnable {
    private final int port;
    private ServerSocket socket;
    private Thread thread;
    private boolean isStarted = false;
    private final Object lockObject = new Object();

    protected SocketServer(int port) {
        this.port = port;
    }

    public void start() throws InterruptedException {
        this.thread = new Thread((Runnable)this, "Fake Adb Server");
        this.thread.setDaemon(true);
        this.thread.start();
        this.waitForServer();
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        try {
            this.socket = new ServerSocket(this.port);
            this.socket.setReuseAddress(true);
            this.serverReady();
            while (true) {
                Socket c = this.socket.accept();
                Thread clientThread = new Thread(this.createResponder(c), "AdbClientWorker");
                clientThread.setDaemon(true);
                clientThread.start();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverReady() {
        Object object = this.lockObject;
        synchronized (object) {
            this.isStarted = true;
            this.lockObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForServer() throws InterruptedException {
        Object object = this.lockObject;
        synchronized (object) {
            while (!this.isStarted) {
                this.lockObject.wait();
            }
        }
    }

    protected abstract Runnable createResponder(Socket var1);

    public void stop() throws IOException, InterruptedException {
        this.socket.close();
        this.thread.join();
    }
}

