/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.vnc;

import com.sikulix.vnc.VNCClient;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Location;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.support.IRobot;
import org.sikuli.script.support.IScreen;
import org.sikuli.util.OverlayCapturePrompt;
import org.sikuli.vnc.VNCRobot;

public class VNCScreen
extends Region
implements IScreen {
    private VNCClient client;
    private IRobot robot;
    private ScreenImage lastScreenImage;
    private static String stdIP = "127.0.0.1";
    private static int stdPort = 5900;
    private String ip = "";
    private int port = -1;
    private String id = "";
    private static Map<String, VNCScreen> screens = new HashMap<String, VNCScreen>();
    private static int startUpWait = 3;

    public static void startUp(int waittime) {
        startUpWait = waittime;
    }

    private VNCScreen() {
    }

    public static VNCScreen start() {
        return VNCScreen.start(stdIP);
    }

    public static VNCScreen start(String theIP) {
        VNCScreen vscr = null;
        vscr = VNCScreen.start(theIP, stdPort, null, 3, 0);
        return vscr;
    }

    public static VNCScreen start(String theIP, int thePort) {
        return VNCScreen.start(theIP, thePort, null, 3, 0);
    }

    public static VNCScreen start(String theIP, int thePort, int cTimeout, int timeout) {
        return VNCScreen.start(theIP, thePort, null, cTimeout, timeout);
    }

    public static VNCScreen start(String theIP, int thePort, String password, int cTimeout, int timeout) {
        VNCScreen scr = VNCScreen.canConnect(theIP, thePort, cTimeout);
        if (null != scr) {
            if (scr.id.isEmpty()) {
                scr.init(theIP, thePort, password);
                Debug.log(3, "VNCScreen: start: %s", scr);
            } else {
                Debug.log(3, "VNCScreen: start: using existing: %s", scr);
            }
        } else {
            scr = new VNCScreen();
        }
        return scr;
    }

    private void init(String theIP, int thePort, String password) {
        this.ip = theIP;
        this.port = thePort;
        this.id = String.format("%s:%d", this.ip, this.port);
        this.client = VNCClient.connect((String)this.ip, (int)this.port, (String)password, (boolean)true);
        this.robot = new VNCRobot(this);
        this.setOtherScreen(this);
        this.setRect(this.getBounds());
        this.initScreen(this);
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        VNCScreen.this.client.processMessages();
                    }
                    catch (RuntimeException e) {
                        if (!VNCScreen.this.isRunning()) break block2;
                        throw e;
                    }
                }
            }
        }).start();
        this.client.refreshFramebuffer();
        screens.put(this.id, this);
        this.wait((double)startUpWait);
    }

    private static VNCScreen canConnect(String theIP, int thePort, int timeout) {
        boolean validIP;
        String address = theIP + ":" + thePort;
        String[] parts = theIP.split("\\.");
        if (parts.length == 4) {
            validIP = true;
            int n = 0;
            String[] stringArray = parts;
            int n2 = stringArray.length;
            if (n < n2) {
                String part = stringArray[n];
                try {
                    int numIP = Integer.parseInt(part);
                    if (numIP < 0 || numIP > 255) {
                        return null;
                    }
                }
                catch (NumberFormatException nex) {
                    return null;
                }
            }
        } else {
            boolean bl = validIP = !new InetSocketAddress(theIP, thePort).isUnresolved();
        }
        if (validIP) {
            VNCScreen vNCScreen;
            VNCScreen vncScreen;
            if (screens.size() > 0 && null != (vncScreen = screens.get(address))) {
                return vncScreen;
            }
            Socket socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(theIP, thePort), timeout * 1000);
                vNCScreen = vncScreen = new VNCScreen();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    Debug.error("VNCScreen: start: connection %s:%d not possible", theIP, thePort);
                    return null;
                }
            }
            socket.close();
            return vNCScreen;
        }
        Debug.error("VNCScreen: start: given ip/hostname %s not valid", theIP);
        return null;
    }

    @Override
    public String getIDString() {
        return (this.isRunning() ? "VNC " : "VNC:INVALID ") + this.id;
    }

    public void stop() {
        this.close();
        screens.remove(this.id);
    }

    public static void stopAll() {
        if (screens.size() > 0) {
            Debug.log(3, "VNCScreen: stopping all", new Object[0]);
            for (VNCScreen scr : screens.values()) {
                scr.close();
            }
            screens.clear();
        }
    }

    private void close() {
        if (this.isRunning()) {
            Debug.log(3, "VNCScreen: stopping: %s", this);
            this.client.close();
            this.client = null;
            this.robot = null;
        }
    }

    public boolean isRunning() {
        return null != this.client;
    }

    @Override
    public IRobot getRobot() {
        return this.robot;
    }

    @Override
    public Rectangle getBounds() {
        if (this.isRunning()) {
            return this.client.getBounds();
        }
        return new Rectangle();
    }

    @Override
    public ScreenImage capture() {
        return this.capture(this.getBounds());
    }

    @Override
    public ScreenImage capture(Region reg) {
        return this.capture(reg.x, reg.y, reg.w, reg.h);
    }

    @Override
    public ScreenImage capture(Rectangle rect) {
        return this.capture(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public ScreenImage capture(int x, int y, int w, int h) {
        ScreenImage img;
        if (!this.isRunning()) {
            return null;
        }
        BufferedImage image = this.client.getFrameBuffer(x, y, w, h);
        this.lastScreenImage = img = new ScreenImage(new Rectangle(x, y, w, h), image);
        Debug.log(3, "VNCScreen: capture: (%d,%d) %dx%d on %s", x, y, w, h, this);
        return img;
    }

    @Override
    public int getID() {
        return 0;
    }

    @Override
    public int getIdFromPoint(int srcx, int srcy) {
        return 0;
    }

    @Override
    protected <PSIMRL> Location getLocationFromTarget(PSIMRL target) throws FindFailed {
        Location location = super.getLocationFromTarget(target);
        if (location != null) {
            location.setOtherScreen(this);
        }
        return location;
    }

    @Override
    public ScreenImage getLastScreenImageFromScreen() {
        return this.lastScreenImage;
    }

    @Override
    public ScreenImage userCapture(final String msg) {
        if (!this.isRunning()) {
            return null;
        }
        final OverlayCapturePrompt prompt = new OverlayCapturePrompt(this);
        Thread th = new Thread(){

            @Override
            public void run() {
                prompt.prompt(msg);
            }
        };
        th.start();
        boolean hasShot = false;
        ScreenImage simg = null;
        int count = 0;
        while (!hasShot) {
            this.wait(0.1f);
            if (count++ > 300) break;
            if (!prompt.isComplete()) continue;
            simg = prompt.getSelection();
            if (simg != null) {
                this.lastScreenImage = simg;
            }
            hasShot = true;
            prompt.close();
        }
        if (!hasShot) {
            prompt.close();
        }
        return simg;
    }

    public VNCClient getClient() {
        return this.client;
    }

    public Region set(Region element) {
        return this.setOther(element);
    }

    public Location set(Location element) {
        return this.setOther(element);
    }

    @Override
    public Region setOther(Region element) {
        element.setOtherScreen(this);
        return element;
    }

    @Override
    public Location setOther(Location element) {
        element.setOtherScreen(this);
        return element;
    }

    @Override
    public Location newLocation(int x, int y) {
        Location loc = new Location(x, y);
        loc.setOtherScreen(this);
        return loc;
    }

    @Override
    public Location newLocation(Location loc) {
        return this.newLocation(loc.x, loc.y);
    }

    @Override
    public Region newRegion(int x, int y, int w, int h) {
        Region reg = Region.create(x, y, w, h, this);
        reg.setOtherScreen(this);
        return reg;
    }

    @Override
    public Region newRegion(Location loc, int w, int h) {
        return this.newRegion(loc.x, loc.y, w, h);
    }

    @Override
    public Region newRegion(Region reg) {
        return this.newRegion(reg.x, reg.y, reg.w, reg.h);
    }
}

