/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.sikuli.android.ADBScreen;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.App;
import org.sikuli.script.Button;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Finder;
import org.sikuli.script.Image;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Match;
import org.sikuli.script.Mouse;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.SX;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.support.RunTime;
import org.sikuli.script.support.ScreenUnion;
import org.sikuli.util.Highlight;

public class SikulixTest {
    private static Screen scr;
    private static long start;
    private static String showBase;
    private static String showLink;
    private static int showWait;
    private static int showBefore;
    private static boolean isShown;
    private static RunTime runTime;
    private static Region reg;
    private static Region regWin;
    private static String keyMeta;
    private static boolean isBrowserRunning;
    private static String currentTest;
    private static List<Integer> runTest;

    private static void timer() {
        start = new Date().getTime();
    }

    private static void timer(String msg) {
        SikulixTest.p("%d (%s)", new Date().getTime() - start, msg.isEmpty() ? "msec" : msg);
    }

    private static void p(String msg, Object ... args) {
        if (msg.isEmpty()) {
            return;
        }
        System.out.println(String.format(msg, args));
    }

    private static void error(String msg, Object ... args) {
        SikulixTest.p("[ERROR]" + msg, args);
    }

    private static void show(String image) {
        SikulixTest.show(image, 3, 0);
    }

    private static void show(String image, int wait) {
        SikulixTest.show(image, wait, 0);
    }

    public static void showStop() {
        if (isShown) {
            scr.type("w", keyMeta);
            isShown = false;
        }
    }

    public static void show(String image, final int wait, final int before) {
        if (!image.endsWith(".png")) {
            image = image + ".png";
        }
        showLink = "file://" + Image.create(image).getURL().getPath();
        showWait = wait;
        showBefore = before;
        Thread runnable = new Thread(){

            @Override
            public void run() {
                if (before > 0) {
                    RunTime.pause(showBefore);
                }
                App.openLink(showLink);
                if (wait > 0) {
                    RunTime.pause(showWait);
                    scr.type("w", "\ue023");
                } else {
                    isShown = true;
                }
            }
        };
        runnable.start();
    }

    public static boolean openTestPage() {
        return SikulixTest.openTestPage("");
    }

    public static boolean openTestPage(String page) {
        String testPageBase = "https://github.com/RaiMan/SikuliX1/wiki/";
        String testPage = "Test-page-text";
        if (!page.isEmpty()) {
            testPage = page;
        }
        String actualPage = testPageBase + testPage;
        boolean success = false;
        String corner = "apple";
        Pattern pCorner = new Pattern(corner).similar(0.9);
        Match cornerSeen = null;
        if (App.openLink(actualPage)) {
            scr.wait(1.0);
            ScreenUnion allScreen = Screen.all();
            if (SX.isNotNull(allScreen.exists(pCorner, 30.0))) {
                success = true;
                cornerSeen = allScreen.getLastMatch();
                cornerSeen.hover();
                reg = App.focusedWindow();
                regWin = new Region(reg);
            }
        }
        if (success) {
            int wheelDirection = 0;
            success = false;
            while (!success) {
                List<Match> matches = reg.getAll(corner);
                if (matches.size() == 2) {
                    reg = matches.get(0).union(matches.get(1));
                    SikulixTest.reg.h += 5;
                    success = true;
                    break;
                }
                if (wheelDirection == 0) {
                    wheelDirection = Button.WHEEL_DOWN;
                    reg.wheel(wheelDirection, 1);
                    scr.wait(0.5);
                    Match cornerMatch = regWin.exists(pCorner);
                    if (cornerMatch.y >= cornerSeen.y) {
                        wheelDirection *= -1;
                    }
                }
                reg.wheel(wheelDirection, 1);
                scr.wait(0.5);
            }
        }
        if (!success) {
            SikulixTest.p("***** Error: web page did not open (30 secs)", new Object[0]);
        } else {
            isBrowserRunning = true;
        }
        return success;
    }

    private static void browserStop() {
        if (isBrowserRunning) {
            scr.type("w", keyMeta);
        }
        isBrowserRunning = false;
    }

    private static void before(String test, String text) {
        currentTest = test;
        SikulixTest.p("***** starting %s %s", test, text);
    }

    private static void after() {
        SikulixTest.p("***** ending %s", currentTest);
        Highlight.closeAll();
        SikulixTest.showStop();
        SikulixTest.browserStop();
    }

    private static List<Match> highlight(List<Match> regs, int time) {
        for (Match reg : regs) {
            reg.highlight();
        }
        scr.wait((double)time * 1.0);
        Highlight.closeAll();
        return regs;
    }

    private static void highlight(List<Match> regs) {
        SikulixTest.highlight(regs, 1);
    }

    private static Match highlight(Match match) {
        if (null != match) {
            match.highlight(1.0);
        }
        return match;
    }

    private static boolean shouldRunTest(int nTest) {
        return runTest.contains(0) || runTest.contains(nTest);
    }

    public static void main(String[] args) {
        String[] aTexts;
        Iterator changes;
        runTime = RunTime.get();
        Debug.reset();
        scr = new Screen();
        String browser = "edge";
        if (SikulixTest.runTime.runningMac) {
            browser = "safari";
            keyMeta = "\ue023";
        }
        ImagePath.setBundlePath(new File(SikulixTest.runTime.fWorkDir, showBase).getAbsolutePath());
        Match match = null;
        String testImage = "findBase";
        if (runTest.size() > 1) {
            if (-1 < runTest.indexOf(0)) {
                runTest.remove(runTest.indexOf(0));
            }
        } else if (runTest.size() == 0) {
            SikulixTest.before("test99", "play");
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(1)) {
            SikulixTest.before("test1", "scr.exists(testImage)");
            SikulixTest.show(testImage, 0);
            scr.wait(2.0);
            match = scr.exists(testImage, 10.0);
            match.highlight();
            RunTime.pause(2);
            match.highlight(1.0, "green");
            match.highlight(1.0, "blue");
            match.highlight(1.0, "black");
            RunTime.pause(2);
            Mouse.move(scr.getCenter());
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(2)) {
            SikulixTest.before("test2", "findChanges");
            SikulixTest.show(testImage, 0);
            scr.wait(2.0);
            Finder finder = new Finder(testImage);
            String imgChange = "findChange3";
            changes = finder.findChanges(imgChange);
            match = scr.exists(testImage, 10.0);
            Iterator<Region> iterator = changes.iterator();
            while (iterator.hasNext()) {
                Region region = iterator.next();
                match.getInset(region).highlight(1.0);
            }
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(3)) {
            SikulixTest.before("test3", "text OCR");
            if (SikulixTest.openTestPage()) {
                String text = "";
                if (SX.isNotNull(reg)) {
                    text = reg.text().trim();
                }
                SikulixTest.p("***** read:\n%s", text);
            }
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(4)) {
            Match mText;
            SikulixTest.before("test4", "findWord");
            String aWord = "brown";
            if (SikulixTest.openTestPage() && SX.isNotNull(mText = reg.findWord(aWord))) {
                mText.highlight(2.0);
                SikulixTest.highlight(reg.findWords(aWord), 2);
            }
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(5)) {
            SikulixTest.before("test5", "findLines with RegEx");
            String aRegex = "jumps.*?lazy";
            if (SikulixTest.openTestPage()) {
                Match found;
                Object matches = SikulixTest.highlight(reg.findLines(Finder.asRegEx(aRegex)), 3);
                changes = matches.iterator();
                while (changes.hasNext()) {
                    found = (Match)changes.next();
                    SikulixTest.p("**** line: %s", found.getText());
                }
                aRegex = "jumps.*?very.*?lazy";
                matches = SikulixTest.highlight(reg.findLines(Finder.asRegEx(aRegex)), 3);
                changes = matches.iterator();
                while (changes.hasNext()) {
                    found = (Match)changes.next();
                    SikulixTest.p("**** line: %s", found.getText());
                }
            }
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(6)) {
            SikulixTest.before("test6", "Region.find(someText)");
            aTexts = new String[]{"another", "very, very lazy dog", "very + dog"};
            if (SikulixTest.openTestPage()) {
                for (String string : aTexts) {
                    match = reg.existsText(string);
                    if (!SX.isNotNull(match)) continue;
                    match.highlight(2.0);
                }
            }
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(7)) {
            SikulixTest.before("test7", "Region.findAll(someText)");
            String aText = "very lazy dog";
            if (SikulixTest.openTestPage()) {
                Object found = null;
                found = reg.hasText(Finder.asRegEx(aText));
                if (SX.isNotNull(found)) {
                    ((Region)found).highlight(2.0);
                }
                SikulixTest.highlight(reg.findAllText(aText), 2);
            }
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(8)) {
            SikulixTest.before("test8", "Region.getWords/getLines");
            if (SikulixTest.openTestPage()) {
                List<Match> words;
                List<Match> lines = reg.collectLines();
                if (lines.size() > 0) {
                    for (Match line : lines) {
                        line.highlight(1.0);
                        SikulixTest.p("***** line: %s", line.getText());
                    }
                }
                if ((words = reg.collectWords()).size() > 0) {
                    int jump = words.size() / 10;
                    int current = 0;
                    for (Match word : words) {
                        if (current % 10 == 0) {
                            word.highlight(1.0);
                        }
                        SikulixTest.p("%s", word.getText());
                        ++current;
                    }
                }
            }
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(9)) {
            SikulixTest.before("test9", "basic transparency");
            Pattern imgBG = new Pattern(Image.create("buttonTextOpa"));
            Pattern img = new Pattern(Image.create("buttonText"));
            Pattern imgTrans = new Pattern(Image.create("buttonTextTrans"));
            Pattern maskBlack = new Pattern("buttonTextBlackMask").mask();
            Pattern pattern = new Pattern("buttonTextBlackMask");
            Pattern maskTrans = new Pattern("buttonTextTransMask");
            Pattern maskedBlack = new Pattern(maskBlack).mask(maskBlack);
            Pattern maskedTrans = new Pattern(maskBlack).mask(maskTrans);
            Pattern[] patterns = new Pattern[]{imgTrans};
            if (SikulixTest.openTestPage("Test-page-1")) {
                reg.setAutoWaitTimeout(0.0);
                String out = "";
                for (Pattern pattern2 : patterns) {
                    pattern2.similar(0.9);
                    SikulixTest.highlight(reg.exists(pattern2, 0.0));
                    try {
                        Finder fmatches = (Finder)reg.findAll(pattern2);
                        List<Match> matches = reg.findAllList(pattern2);
                        out = out + String.format("*** findAll: %d of %s\n", matches.size(), pattern2);
                        for (Match next : matches) {
                            next.highlight();
                        }
                    }
                    catch (FindFailed findFailed) {
                        out = out + String.format("findAll failed: %s\n", pattern2);
                    }
                    scr.wait(1.0);
                    Highlight.closeAll();
                }
                SikulixTest.p("%s", out);
                out = "";
            }
            scr.wait(1.0);
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(10)) {
            SikulixTest.before("test10", "transparency with pattern");
            String wb = "whiteBlack";
            String[] wt = "whiteTrans";
            String wwt = "whiteWithText";
            SikulixTest.show(wwt, 0);
            scr.wait(2.0);
            reg = scr;
            reg = App.focusedWindow();
            Pattern wbMask = new Pattern(wb).asMask();
            Pattern pattern = new Pattern(wwt).withMask(wbMask);
            SikulixTest.p("***** real image", new Object[0]);
            reg.has(wwt);
            reg.highlight(-1.0);
            SikulixTest.p("***** pattern asMask()", new Object[0]);
            reg.has(wbMask);
            reg.highlight(-1.0);
            SikulixTest.p("***** pattern withMask()", new Object[0]);
            reg.has(pattern);
            reg.highlight(-1.0);
            SikulixTest.p("***** transparent masked image", new Object[0]);
            reg.has(wt);
            reg.highlight(-1.0);
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(11)) {
            SikulixTest.before("test11", "find SwitchToText");
            Settings.SwitchToText = true;
            aTexts = new String[]{"another"};
            reg = scr;
            if (SikulixTest.openTestPage()) {
                for (String string : aTexts) {
                    match = reg.exists(string, 0.0);
                    if (!SX.isNotNull(match)) continue;
                    match.highlight(1.0);
                }
            }
            SikulixTest.after();
        }
        if (SikulixTest.shouldRunTest(12)) {
            SikulixTest.before("test12", "class App");
            String chrome = "google chrome";
            String firefox = "firefox";
            String notepad = "brackets";
            if (SikulixTest.runTime.runningWindows) {
                chrome = "C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe";
                firefox = "C:\\Program Files\\Mozilla Firefox\\firefox.exe";
                notepad = "C:\\Program Files\\Notepad++\\notepad++.exe";
            }
            App app = new App(notepad);
            app.open(10);
            app.focus();
            if (app.isRunning(5)) {
                List<Region> list = app.getWindows();
                for (Region window : list) {
                    SikulixTest.p("window: %s", window);
                }
                app.focusedWindow().highlight(2.0);
                RunTime.pause(3);
                app.closeByKey();
                app.open(5);
                Object[] objectArray = new Object[2];
                objectArray[0] = app;
                objectArray[1] = app.focusedWindow();
                SikulixTest.p("app: %s (%s)", objectArray);
                app.focusedWindow().highlight(2.0);
            }
        }
        if (SikulixTest.shouldRunTest(13)) {
            SikulixTest.before("test13", "android");
            Debug.on(3);
            ADBScreen adb = ADBScreen.start();
            while (!adb.getDevice().isDisplayOn().booleanValue()) {
                adb.aKey(224);
                RunTime.pause(1);
            }
            ScreenImage capture = adb.capture();
            SikulixTest.p("%s", capture);
        }
    }

    static {
        start = -1L;
        showBase = "API/src/main/resources/Images";
        isShown = false;
        reg = null;
        regWin = null;
        keyMeta = "\ue021";
        isBrowserRunning = false;
        currentTest = "";
        runTest = new ArrayList<Integer>();
    }
}

