/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Scanner;
import org.sikuli.script.Sikulix;

public class Run {
    private static Scanner in = null;
    private static PrintWriter out = null;
    private static Socket socket = null;
    private static boolean socketValid = false;
    private static String ip = null;
    private static int port = -1;
    private static boolean keepAlive = false;
    private static boolean disconnecting = false;

    private static void log(String message, Object ... args) {
        System.out.println(String.format("[debug] Run: " + message, args));
    }

    private static void error(String message, Object ... args) {
        System.out.println(String.format("[error] Run: " + message, args));
    }

    private Run() {
    }

    public static void main(String[] args) {
        String adr = "";
        String p = "-1";
        if (!Run.init(adr, p).booleanValue()) {
            Run.error("not possible", new Object[0]);
        }
    }

    public static boolean connect() {
        keepAlive = true;
        return Run.init();
    }

    private static Boolean init() {
        if (socketValid && !Run.close()) {
            return false;
        }
        return Run.init(ip, "" + port);
    }

    private static Boolean init(String adr, String p) {
        socketValid = true;
        ip = Run.getAddress(adr);
        port = Run.getPort(p);
        if (ip == null || port < 0) {
            Sikulix.terminate(1, "target not valid: %s / %d", adr, p);
        }
        try {
            socket = new Socket(ip, port);
        }
        catch (Exception ex) {
            Run.error("no connection: " + adr + " / " + p, new Object[0]);
            socketValid = false;
        }
        try {
            if (socketValid) {
                out = new PrintWriter(socket.getOutputStream());
                in = new Scanner(socket.getInputStream());
                Run.log("connection at: " + socket, new Object[0]);
            }
        }
        catch (Exception ex) {
            Run.error("problem starting connection:\n", ex.getMessage());
            socketValid = false;
        }
        return socketValid;
    }

    public static String getAddress(String adr) {
        try {
            if (adr == null || adr.isEmpty()) {
                return InetAddress.getLocalHost().getHostAddress();
            }
            return InetAddress.getByName(adr).getHostAddress();
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    public static int getPort(String p) {
        int port;
        int pDefault = 50001;
        if (p == null || p.isEmpty()) {
            return pDefault;
        }
        try {
            port = Integer.parseInt(p);
        }
        catch (NumberFormatException ex) {
            return pDefault;
        }
        if (port < 0) {
            port = pDefault;
        }
        if (port < 1024) {
            port += pDefault;
        }
        return port;
    }

    public static boolean isValid() {
        return socketValid && socket != null;
    }

    public static String send(String command) {
        String res;
        if (keepAlive) {
            command = "X" + command;
        } else {
            Run.init();
        }
        if (!Run.isValid()) {
            Run.error("connection not valid - send not possible", new Object[0]);
            return null;
        }
        try {
            String line;
            out.println(command);
            out.flush();
            Run.log("send: " + command, new Object[0]);
            res = in.nextLine();
            while (in.hasNextLine() && !(line = in.nextLine()).contains("###+++###")) {
                res = res + "\n" + line;
            }
        }
        catch (Exception ex) {
            Run.error("error while processing:\n" + ex.getMessage(), new Object[0]);
            res = "fail: reason unknown";
        }
        if (!keepAlive && !disconnecting) {
            Run.close();
        }
        return res;
    }

    public static boolean close() {
        return Run.close(false);
    }

    public static boolean stop() {
        return Run.close(true);
    }

    private static boolean close(boolean stopServer) {
        disconnecting = true;
        if (stopServer) {
            Run.send("STOP");
        } else if (keepAlive) {
            Run.send("EXIT");
        }
        if (socket != null) {
            try {
                in.close();
                out.close();
                socket.close();
            }
            catch (IOException ex) {
                Run.log("error on close: %s\n" + ex.getMessage(), socket);
                socket = null;
            }
        }
        in = null;
        out = null;
        socketValid = false;
        if (socket == null) {
            return false;
        }
        socket = null;
        keepAlive = false;
        return true;
    }

    public static String show() {
        return String.format("%s:%d %s", ip, port, Run.isValid());
    }
}

