/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RescaleOp;
import javax.swing.JFrame;
import org.sikuli.basics.Debug;
import org.sikuli.script.Location;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.support.IScreen;
import org.sikuli.script.support.RunTime;
import org.sikuli.util.EventObserver;
import org.sikuli.util.EventSubject;

public class OverlayCapturePrompt
extends JFrame
implements EventSubject {
    static final float MIN_DARKER_FACTOR = 0.6f;
    static final long MSG_DISPLAY_TIME = 2000L;
    static final long WIN_FADE_IN_TIME = 200L;
    static final Font fontMsg = new Font("Arial", 0, 60);
    static final Color selFrameColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    static final Color selCrossColor = new Color(1.0f, 0.0f, 0.0f, 0.6f);
    static final Color screenFrameColor = new Color(1.0f, 0.0f, 0.0f, 0.6f);
    private Rectangle screenFrame = null;
    static final BasicStroke strokeScreenFrame = new BasicStroke(5.0f);
    static final BasicStroke _StrokeCross = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    static final BasicStroke bs = new BasicStroke(1.0f);
    private EventObserver captureObserver = null;
    private IScreen scrOCP;
    private BufferedImage scr_img = null;
    private BufferedImage scr_img_darker = null;
    private BufferedImage bi = null;
    private float darker_factor;
    private Rectangle rSel;
    private int srcScreenId = -1;
    private Location srcScreenLocation = null;
    private Location destScreenLocation = null;
    private int srcx;
    private int srcy;
    private int destx;
    private int desty;
    private boolean canceled = false;
    private String promptMsg = "";
    private boolean dragging = false;
    private boolean hasFinished = false;
    private boolean hasStarted = false;
    private boolean mouseMoves = false;
    private int scr_img_type = 1;
    private double scr_img_scale = 1.0;
    private Rectangle scr_img_rect = null;
    private ScreenImage scr_img_original = null;
    private int destMinX;
    private int destMaxX;
    private int destMinY;
    private int destMaxY;
    private boolean isLocalScreen = true;

    public OverlayCapturePrompt(IScreen scr) {
        Debug.log(3, "TRACE: OverlayCapturePrompt: init: S(%d)", scr.getID());
        this.scrOCP = scr;
        this.canceled = false;
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.rSel = new Rectangle();
        if (scr.isOtherScreen()) {
            this.isLocalScreen = false;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (OverlayCapturePrompt.this.scr_img == null) {
                    return;
                }
                if (e.getButton() != 1) {
                    return;
                }
                OverlayCapturePrompt.this.hasStarted = true;
                OverlayCapturePrompt.this.destx = (OverlayCapturePrompt.this.srcx = e.getX());
                OverlayCapturePrompt.this.desty = (OverlayCapturePrompt.this.srcy = e.getY());
                if (OverlayCapturePrompt.this.isLocalScreen) {
                    OverlayCapturePrompt.this.srcScreenId = OverlayCapturePrompt.this.scrOCP.getIdFromPoint(OverlayCapturePrompt.this.srcx, OverlayCapturePrompt.this.srcy);
                    OverlayCapturePrompt.this.srcScreenLocation = new Location(OverlayCapturePrompt.this.srcx + OverlayCapturePrompt.this.scrOCP.getX(), OverlayCapturePrompt.this.srcy + OverlayCapturePrompt.this.scrOCP.getY());
                    Debug.log(3, "CapturePrompt: started at (%d,%d) as %s on %d", OverlayCapturePrompt.this.srcx, OverlayCapturePrompt.this.srcy, OverlayCapturePrompt.this.srcScreenLocation.toStringShort(), OverlayCapturePrompt.this.srcScreenId);
                    OverlayCapturePrompt.this.destMinX = 0;
                    OverlayCapturePrompt.this.destMaxX = OverlayCapturePrompt.this.scrOCP.getW() - 1;
                    OverlayCapturePrompt.this.destMinY = 0;
                    OverlayCapturePrompt.this.destMaxY = OverlayCapturePrompt.this.scrOCP.getH() - 1;
                }
                OverlayCapturePrompt.this.promptMsg = null;
                OverlayCapturePrompt.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (OverlayCapturePrompt.this.scr_img == null) {
                    return;
                }
                if (e.getButton() != 1) {
                    OverlayCapturePrompt.this.canceled = true;
                    Debug.log(3, "CapturePrompt: aborted: not using left mouse button", new Object[0]);
                } else if (OverlayCapturePrompt.this.isLocalScreen) {
                    OverlayCapturePrompt.this.destScreenLocation = new Location(OverlayCapturePrompt.this.destx + OverlayCapturePrompt.this.scrOCP.getX(), OverlayCapturePrompt.this.desty + OverlayCapturePrompt.this.scrOCP.getY());
                    Debug.log(3, "CapturePrompt: finished at (%d,%d) as %s on %d", OverlayCapturePrompt.this.destx, OverlayCapturePrompt.this.desty, OverlayCapturePrompt.this.destScreenLocation.toStringShort(), OverlayCapturePrompt.this.srcScreenId);
                }
                OverlayCapturePrompt.this.hasFinished = true;
                OverlayCapturePrompt.this.setVisible(false);
                OverlayCapturePrompt.this.notifyObserver();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (OverlayCapturePrompt.this.promptMsg == null) {
                    return;
                }
                if (!OverlayCapturePrompt.this.mouseMoves) {
                    OverlayCapturePrompt.this.mouseMoves = true;
                    return;
                }
                OverlayCapturePrompt.this.promptMsg = null;
                OverlayCapturePrompt.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!OverlayCapturePrompt.this.hasStarted || OverlayCapturePrompt.this.scr_img == null) {
                    return;
                }
                if (!OverlayCapturePrompt.this.dragging) {
                    if (OverlayCapturePrompt.this.promptMsg != null) {
                        Screen.closePrompt((Screen)OverlayCapturePrompt.this.scrOCP);
                    }
                    OverlayCapturePrompt.this.dragging = true;
                }
                OverlayCapturePrompt.this.destx = e.getX();
                OverlayCapturePrompt.this.desty = e.getY();
                OverlayCapturePrompt.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    OverlayCapturePrompt.this.hasFinished = (OverlayCapturePrompt.this.canceled = true);
                    Debug.log(3, "CapturePrompt: aborted using key ESC", new Object[0]);
                    OverlayCapturePrompt.this.setVisible(false);
                    OverlayCapturePrompt.this.notifyObserver();
                }
            }
        });
    }

    public int getScrID() {
        return this.srcScreenId;
    }

    public void close() {
        Debug.log(4, "CapturePrompt.close: S(%d) freeing resources", this.scrOCP.getID());
        this.setVisible(false);
        this.dispose();
        this.scr_img = null;
        this.scr_img_darker = null;
        this.bi = null;
    }

    public void prompt(String msg, int delayMS) {
        try {
            Thread.sleep(delayMS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.prompt(msg);
    }

    public void prompt(int delayMS) {
        this.prompt(null, delayMS);
    }

    public void prompt() {
        this.prompt(null);
    }

    public void prompt(String msg) {
        this.scr_img_original = this.scrOCP.capture();
        if (Debug.getDebugLevel() > 2) {
            this.scr_img_original.getFile(RunTime.get().fSikulixStore.getAbsolutePath(), "lastScreenShot");
        }
        this.scr_img_darker = this.scr_img = this.scr_img_original.getImage();
        this.scr_img_type = this.scr_img.getType();
        this.scr_img_rect = new Rectangle(this.scrOCP.getBounds());
        this.promptMsg = msg;
        if (this.isLocalScreen) {
            this.darker_factor = 0.6f;
            RescaleOp op = new RescaleOp(this.darker_factor, 0.0f, null);
            this.scr_img_darker = op.filter(this.scr_img, null);
        } else {
            this.promptMsg = null;
            if ((double)this.scr_img_rect.height > Screen.getPrimaryScreen().getBounds().getHeight()) {
                this.scr_img_scale = Screen.getPrimaryScreen().getBounds().getHeight() / (double)this.scr_img_rect.height;
            }
            if ((double)this.scr_img_rect.width > Screen.getPrimaryScreen().getBounds().getWidth()) {
                this.scr_img_scale = Math.min(Screen.getPrimaryScreen().getBounds().getWidth() / (double)this.scr_img_rect.width, this.scr_img_scale);
            }
            if (1.0 != this.scr_img_scale) {
                this.scr_img_rect.width = (int)((double)this.scr_img_rect.width * this.scr_img_scale);
                this.scr_img_rect.height = (int)((double)this.scr_img_rect.height * this.scr_img_scale);
                Image tmp = this.scr_img.getScaledInstance(this.scr_img_rect.width, this.scr_img_rect.height, 4);
                this.scr_img = new BufferedImage(this.scr_img_rect.width, this.scr_img_rect.height, 2);
                Graphics2D g2d = this.scr_img.createGraphics();
                g2d.drawImage(tmp, 0, 0, null);
                g2d.dispose();
                this.scr_img_darker = this.scr_img;
            }
        }
        this.setBounds(this.scr_img_rect);
        this.setVisible(true);
    }

    public boolean isComplete() {
        return this.hasFinished;
    }

    @Override
    public void addObserver(EventObserver obs) {
        Debug.log(3, "TRACE: OverlayCapturePrompt: addObserver: %s", obs != null);
        this.captureObserver = obs;
    }

    @Override
    public void notifyObserver() {
        Debug.log(3, "TRACE: OverlayCapturePrompt: notifyObserver: %s", this.captureObserver != null);
        if (null != this.captureObserver) {
            this.captureObserver.update(this);
        }
    }

    public ScreenImage getSelection() {
        if (this.canceled) {
            return null;
        }
        BufferedImage cropImg = this.cropSelection();
        if (cropImg == null) {
            return null;
        }
        this.rSel.x += this.scrOCP.getX();
        this.rSel.y += this.scrOCP.getY();
        ScreenImage ret = new ScreenImage(this.rSel, cropImg);
        ret.setStartEnd(this.srcScreenLocation, this.destScreenLocation);
        return ret;
    }

    private BufferedImage cropSelection() {
        int w = this.rSel.width;
        int h = this.rSel.height;
        if (w <= 0 || h <= 0) {
            return null;
        }
        int x = this.rSel.x;
        int y = this.rSel.y;
        if (!this.isLocalScreen && this.scr_img_scale != 1.0) {
            x = (int)((double)x / this.scr_img_scale);
            y = (int)((double)y / this.scr_img_scale);
            w = (int)((double)w / this.scr_img_scale);
            h = (int)((double)h / this.scr_img_scale);
        }
        BufferedImage crop = new BufferedImage(w, h, this.scr_img_type);
        Graphics2D crop_g2d = crop.createGraphics();
        try {
            crop_g2d.drawImage(this.scr_img_original.getImage().getSubimage(x, y, w, h), null, 0, 0);
        }
        catch (RasterFormatException e) {
            Debug.error("OverlayCapturePrompt: cropSelection: RasterFormatException", e.getMessage());
        }
        crop_g2d.dispose();
        return crop;
    }

    void drawMessage(Graphics2D g2d) {
        if (this.promptMsg == null) {
            return;
        }
        g2d.setFont(fontMsg);
        g2d.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        int sw = g2d.getFontMetrics().stringWidth(this.promptMsg);
        int sh = g2d.getFontMetrics().getMaxAscent();
        Rectangle ubound = this.scrOCP.getBounds();
        for (int i = 0; i < Screen.getNumberScreens(); ++i) {
            if (!Screen.getScreen(i).hasPrompt()) continue;
            Rectangle bound = Screen.getBounds(i);
            int cx = bound.x + (bound.width - sw) / 2 - ubound.x;
            int cy = bound.y + (bound.height - sh) / 2 - ubound.y;
            g2d.drawString(this.promptMsg, cx, cy);
        }
    }

    private void drawSelection(Graphics2D g2d) {
        if (this.srcx != this.destx || this.srcy != this.desty) {
            if (this.destx < this.destMinX) {
                this.destx = this.destMinX;
            } else if (this.destx > this.destMaxX) {
                this.destx = this.destMaxX;
            }
            if (this.desty < this.destMinY) {
                this.desty = this.destMinY;
            } else if (this.desty > this.destMaxY) {
                this.desty = this.destMaxY;
            }
            this.rSel.x = this.srcx < this.destx ? this.srcx : this.destx;
            this.rSel.y = this.srcy < this.desty ? this.srcy : this.desty;
            int xEnd = this.srcx > this.destx ? this.srcx : this.destx;
            int yEnd = this.srcy > this.desty ? this.srcy : this.desty;
            this.rSel.width = xEnd - this.rSel.x + 1;
            this.rSel.height = yEnd - this.rSel.y + 1;
            if (this.rSel.width > 0 && this.rSel.height > 0) {
                g2d.drawImage(this.scr_img.getSubimage(this.rSel.x, this.rSel.y, this.rSel.width, this.rSel.height), null, this.rSel.x, this.rSel.y);
            }
            g2d.setColor(selFrameColor);
            g2d.setStroke(bs);
            g2d.draw(this.rSel);
            int cx = (this.rSel.x + xEnd) / 2;
            int cy = (this.rSel.y + yEnd) / 2;
            g2d.setColor(selCrossColor);
            g2d.setStroke(_StrokeCross);
            g2d.drawLine(cx, this.rSel.y, cx, yEnd);
            g2d.drawLine(this.rSel.x, cy, xEnd, cy);
            if (this.isLocalScreen && Screen.getNumberScreens() > 1) {
                this.drawScreenFrame(g2d, this.srcScreenId);
            }
        }
    }

    private void drawScreenFrame(Graphics2D g2d, int scrId) {
        if (!this.isLocalScreen) {
            return;
        }
        g2d.setColor(screenFrameColor);
        g2d.setStroke(strokeScreenFrame);
        if (this.screenFrame == null) {
            this.screenFrame = Screen.getBounds(scrId);
            Rectangle ubound = this.scrOCP.getBounds();
            this.screenFrame.x -= ubound.x;
            this.screenFrame.y -= ubound.y;
            int sw = (int)(strokeScreenFrame.getLineWidth() / 2.0f);
            this.screenFrame.x += sw;
            this.screenFrame.y += sw;
            this.screenFrame.width -= sw * 2;
            this.screenFrame.height -= sw * 2;
        }
        g2d.draw(this.screenFrame);
    }

    @Override
    public void paint(Graphics g) {
        if (this.scr_img != null) {
            Graphics2D g2dWin = (Graphics2D)g;
            if (this.bi == null) {
                this.bi = new BufferedImage(this.scr_img_rect.width, this.scr_img_rect.height, this.scr_img_type);
            }
            Graphics2D bfG2 = this.bi.createGraphics();
            bfG2.drawImage((Image)this.scr_img_darker, 0, 0, this);
            this.drawMessage(bfG2);
            this.drawSelection(bfG2);
            g2dWin.drawImage((Image)this.bi, 0, 0, this);
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }
}

