/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runnerSupport;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import org.sikuli.basics.Debug;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Mouse;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.runnerSupport.IRunnerSupport;
import org.sikuli.script.support.RunTime;
import org.sikuli.script.support.Runner;

public class JavaScriptSupport
implements IRunnerSupport {
    private static int lvl = 2;
    int i = 0;
    private static Region scr = new Screen();
    private static Region scrSaved = null;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "Commands: " + message, args);
    }

    private static void logCmd(String cmd, Object ... args) {
        String msg = cmd + ": ";
        if (args.length == 0) {
            JavaScriptSupport.log(lvl, msg + "no-args", new Object[0]);
        } else {
            for (int i = 0; i < args.length; ++i) {
                msg = msg + "%s ";
            }
            JavaScriptSupport.log(lvl, msg, args);
        }
    }

    public static boolean isNashorn() {
        return RunTime.get().isJava8();
    }

    public static Object call(String function, Object ... args) {
        Object aObj;
        Method m = null;
        Object retVal = null;
        int count = 0;
        Object[] objectArray = args;
        int n = objectArray.length;
        for (int i = 0; !(i >= n || (aObj = objectArray[i]) == null || aObj.getClass().getName().endsWith("Undefined") || aObj instanceof String && ((String)aObj).contains("undefined")); ++i) {
            ++count;
        }
        Object[] newArgs = new Object[count];
        for (int n2 = 0; n2 < count; ++n2) {
            newArgs[n2] = args[n2];
        }
        try {
            m = JavaScriptSupport.class.getMethod(function, Object[].class);
            retVal = m.invoke(null, new Object[]{newArgs});
        }
        catch (Exception ex) {
            m = null;
        }
        return retVal;
    }

    public static Object run(Object ... args) {
        String script = args[0].toString();
        String[] scriptArgs = new String[args.length - 1];
        if (scriptArgs.length > 0) {
            for (int i = 1; i < args.length; ++i) {
                scriptArgs[i - 1] = args[i].toString();
            }
        }
        return Runner.run(script, scriptArgs, null);
    }

    public static Object circle(Object args) {
        return 0;
    }

    private static boolean isNumber(Object aObj) {
        return aObj instanceof Integer || aObj instanceof Long || aObj instanceof Float || aObj instanceof Double;
    }

    private static int getInteger(Object aObj, int deflt) {
        Integer val = deflt;
        if (aObj instanceof Integer || aObj instanceof Long) {
            val = (Integer)aObj;
        }
        if (aObj instanceof Float) {
            val = Math.round(((Float)aObj).floatValue());
        }
        if (aObj instanceof Double) {
            val = (int)Math.round((Double)aObj);
        }
        return val;
    }

    private static int getInteger(Object aObj) {
        return JavaScriptSupport.getInteger(aObj, 0);
    }

    private static double getNumber(Object aObj, Double deflt) {
        Double val = deflt;
        if (aObj instanceof Integer) {
            val = 0.0 + (double)((Integer)aObj).intValue();
        } else if (aObj instanceof Long) {
            val = 0.0 + (double)((Long)aObj).longValue();
        } else if (aObj instanceof Float) {
            val = 0.0 + (double)((Float)aObj).floatValue();
        } else if (aObj instanceof Double) {
            val = (Double)aObj;
        }
        return val;
    }

    private static double getNumber(Object aObj) {
        return JavaScriptSupport.getNumber(aObj, 0.0);
    }

    public static Region use(Object ... args) {
        JavaScriptSupport.logCmd("use", args);
        scrSaved = null;
        return JavaScriptSupport.usex(args);
    }

    public static Region use1(Object ... args) {
        JavaScriptSupport.logCmd("use1", args);
        scrSaved = scr;
        return JavaScriptSupport.usex(args);
    }

    public static void restoreUsed() {
        if (scrSaved != null) {
            scr = scrSaved;
            scrSaved = null;
            JavaScriptSupport.log(lvl, "restored: %s", scr);
        }
    }

    private static Region usex(Object ... args) {
        int len = args.length;
        int nScreen = -1;
        if (len == 0 || len > 1) {
            scr = new Screen();
            return scr;
        }
        nScreen = JavaScriptSupport.getInteger(args[0], -1);
        if (nScreen > -1) {
            scr = new Screen(nScreen);
        } else {
            Object oReg = args[0];
            if (oReg instanceof Region) {
                scr = (Region)oReg;
            }
        }
        return scr;
    }

    public static Match wait(Object ... args) throws FindFailed {
        JavaScriptSupport.logCmd("wait", args);
        Object[] realArgs = JavaScriptSupport.waitArgs(args);
        return JavaScriptSupport.waitx((String)realArgs[0], (Pattern)realArgs[1], (Double)realArgs[2], ((Float)realArgs[3]).floatValue());
    }

    private static Match waitx(String image, Pattern pimage, double timeout, float score) throws FindFailed {
        Object aPattern = null;
        if (image != null) {
            aPattern = score > 0.0f ? new Pattern(image).similar(score) : image;
        } else if (pimage != null) {
            aPattern = pimage;
        }
        if (aPattern != null) {
            if (timeout > -1.0) {
                return scr.wait(aPattern, timeout);
            }
            return scr.wait(aPattern);
        }
        return null;
    }

    private static Object[] waitArgs(Object ... args) {
        int len = args.length;
        String image = "";
        float score = 0.0f;
        double timeout = -1.0;
        boolean argsOK = true;
        Object[] realArgs = new Object[]{null, null, -1.0, Float.valueOf(0.0f)};
        if (len == 0 || len > 3) {
            argsOK = false;
        } else {
            Object aObj = args[0];
            if (aObj == null) {
                return realArgs;
            }
            if (JavaScriptSupport.isJSON(aObj)) {
                aObj = JavaScriptSupport.fromJSON(aObj);
            }
            if (aObj instanceof String) {
                realArgs[0] = aObj;
            } else if (aObj instanceof Pattern) {
                realArgs[1] = aObj;
                if (len > 1 && JavaScriptSupport.isNumber(args[1])) {
                    realArgs[2] = JavaScriptSupport.getNumber(args[1]);
                }
            } else {
                if (JavaScriptSupport.isNumber(aObj)) {
                    scr.wait(JavaScriptSupport.getNumber(aObj));
                    return null;
                }
                argsOK = false;
            }
        }
        if (argsOK && len > 1 && realArgs[1] == null) {
            if (len > 2 && JavaScriptSupport.isNumber(args[2])) {
                score = (float)JavaScriptSupport.getNumber(args[2]) / 100.0f;
                if ((double)score < 0.7) {
                    score = 0.7f;
                } else if ((double)score > 0.99) {
                    score = 0.99f;
                }
            }
            if (score > 0.0f) {
                realArgs[3] = Float.valueOf(score);
            }
            if (len > 1 && JavaScriptSupport.isNumber(args[1])) {
                realArgs[2] = JavaScriptSupport.getNumber(args[1]);
            }
        }
        if (!argsOK) {
            throw new UnsupportedOperationException("Commands.wait: parameters: String/Pattern:image, float:timeout, int:score");
        }
        return realArgs;
    }

    public static boolean waitVanish(Object ... args) {
        JavaScriptSupport.logCmd("waitVanish", args);
        Object[] realArgs = JavaScriptSupport.waitArgs(args);
        String image = (String)realArgs[0];
        Pattern pimage = (Pattern)realArgs[1];
        double timeout = (Double)realArgs[2];
        float score = ((Float)realArgs[3]).floatValue();
        Object aPattern = image != null ? (score > 0.0f ? new Pattern(image).similar(score) : image) : pimage;
        if (timeout > -1.0) {
            return scr.waitVanish(aPattern, timeout);
        }
        return scr.waitVanish(aPattern);
    }

    public static Match exists(Object ... args) {
        JavaScriptSupport.logCmd("exists", args);
        Match match = null;
        Object[] realArgs = JavaScriptSupport.waitArgs(args);
        if ((Double)realArgs[2] < 0.0) {
            realArgs[2] = 0.0;
        }
        try {
            match = JavaScriptSupport.waitx((String)realArgs[0], (Pattern)realArgs[1], (Double)realArgs[2], ((Float)realArgs[3]).floatValue());
        }
        catch (Exception ex) {
            return null;
        }
        return match;
    }

    public static Location hover(Object ... args) {
        JavaScriptSupport.logCmd("hover", args);
        return JavaScriptSupport.hoverx(args);
    }

    private static Location hoverx(Object ... args) {
        int len = args.length;
        if (len == 0 || args[0] == null) {
            Mouse.move(scr.checkMatch());
            return Mouse.at();
        }
        if (len < 4) {
            Object aObj = args[0];
            Location loc = null;
            if (JavaScriptSupport.isJSON(aObj)) {
                aObj = JavaScriptSupport.fromJSON(aObj);
            }
            if (aObj instanceof String || aObj instanceof Pattern) {
                try {
                    Match aMatch = JavaScriptSupport.wait(args);
                    Mouse.move(aMatch.getTarget());
                }
                catch (Exception ex) {
                    Mouse.move(scr.checkMatch());
                }
                return Mouse.at();
            }
            if (aObj instanceof Region) {
                loc = ((Region)aObj).getTarget();
            } else if (aObj instanceof Location) {
                loc = (Location)aObj;
            }
            if (len > 1) {
                if (JavaScriptSupport.isNumber(aObj) && JavaScriptSupport.isNumber(args[1])) {
                    Mouse.move(scr.checkMatch().offset(JavaScriptSupport.getInteger(aObj), JavaScriptSupport.getInteger(args[1])));
                    return Mouse.at();
                }
                if (len == 3 && loc != null && JavaScriptSupport.isNumber(args[1]) && JavaScriptSupport.isNumber(args[2])) {
                    Mouse.move(loc.offset(JavaScriptSupport.getInteger(args[1], 0), JavaScriptSupport.getInteger(args[2], 0)));
                    return Mouse.at();
                }
            }
            if (loc != null) {
                Mouse.move(loc);
                return Mouse.at();
            }
        }
        Mouse.move(scr.checkMatch());
        return Mouse.at();
    }

    public static Location click(Object ... args) {
        JavaScriptSupport.logCmd("click", args);
        Location loc = JavaScriptSupport.hoverx(args);
        Mouse.click(null, "L", new Integer[0]);
        return Mouse.at();
    }

    public static Location doubleClick(Object ... args) {
        JavaScriptSupport.logCmd("doubleClick", args);
        Location loc = JavaScriptSupport.hoverx(args);
        Mouse.click(null, "LD", new Integer[0]);
        return Mouse.at();
    }

    public static Location rightClick(Object ... args) {
        JavaScriptSupport.logCmd("rightClick", args);
        Location loc = JavaScriptSupport.hoverx(args);
        Mouse.click(null, "R", new Integer[0]);
        return Mouse.at();
    }

    public static boolean paste(Object ... args) {
        JavaScriptSupport.logCmd("paste", args);
        Object[] realArgs = JavaScriptSupport.typeArgs(args);
        return 0 < scr.paste((String)realArgs[0]);
    }

    public static boolean write(Object ... args) {
        JavaScriptSupport.logCmd("write", args);
        Object[] realArgs = JavaScriptSupport.typeArgs(args);
        return 0 < scr.write((String)realArgs[0]);
    }

    private static Object[] typeArgs(Object ... args) {
        Object[] realArgs = new Object[]{null};
        if (!(args[0] instanceof String)) {
            throw new UnsupportedOperationException("Commands.type/paste/write: parameters: String:text");
        }
        realArgs[0] = args[0];
        return realArgs;
    }

    public static boolean isJSON(Object aObj) {
        if (aObj instanceof String) {
            return ((String)aObj).startsWith("[\"");
        }
        return false;
    }

    public static Object fromJSON(Object aObj) {
        if (!JavaScriptSupport.isJSON(aObj)) {
            return aObj;
        }
        Object newObj = null;
        String[] json = ((String)aObj).split(",");
        String last = json[json.length - 1];
        if (!last.endsWith("]")) {
            return aObj;
        }
        json[json.length - 1] = last.substring(0, last.length() - 1);
        String oType = json[0].substring(2, 3);
        if (!"SRML".contains(oType)) {
            return aObj;
        }
        if ("S".equals(oType)) {
            aObj = new Screen(JavaScriptSupport.intFromJSON(json, 5));
            ((Screen)aObj).setRect(JavaScriptSupport.rectFromJSON(json));
        } else if ("R".equals(oType)) {
            newObj = new Region(JavaScriptSupport.rectFromJSON(json));
        } else if ("M".equals(oType)) {
            double score = JavaScriptSupport.dblFromJSON(json, 5) / 100.0;
            newObj = new Match(new Region(JavaScriptSupport.rectFromJSON(json)), score);
            ((Match)newObj).setTarget(JavaScriptSupport.intFromJSON(json, 6), JavaScriptSupport.intFromJSON(json, 7));
        } else if ("L".equals(oType)) {
            newObj = new Location(JavaScriptSupport.locFromJSON(json));
        } else if ("P".equals(oType)) {
            newObj = new Pattern(json[1]);
            ((Pattern)newObj).similar(JavaScriptSupport.fltFromJSON(json, 2));
            ((Pattern)newObj).targetOffset(JavaScriptSupport.intFromJSON(json, 3), JavaScriptSupport.intFromJSON(json, 4));
        }
        return newObj;
    }

    private static Rectangle rectFromJSON(String[] json) {
        int[] vals = new int[4];
        for (int n = 1; n < 5; ++n) {
            try {
                vals[n - 1] = Integer.parseInt(json[n].trim());
                continue;
            }
            catch (Exception ex) {
                vals[n - 1] = 0;
            }
        }
        return new Rectangle(vals[0], vals[1], vals[2], vals[3]);
    }

    private static Point locFromJSON(String[] json) {
        int[] vals = new int[2];
        for (int n = 1; n < 3; ++n) {
            try {
                vals[n - 1] = Integer.parseInt(json[n].trim());
                continue;
            }
            catch (Exception ex) {
                vals[n - 1] = 0;
            }
        }
        return new Point(vals[0], vals[1]);
    }

    private static int intFromJSON(String[] json, int pos) {
        try {
            return Integer.parseInt(json[pos].trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private static float fltFromJSON(String[] json, int pos) {
        try {
            return Float.parseFloat(json[pos].trim());
        }
        catch (Exception ex) {
            return 0.0f;
        }
    }

    private static double dblFromJSON(String[] json, int pos) {
        try {
            return Double.parseDouble(json[pos].trim());
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    @Override
    public boolean runObserveCallback(Object[] args) {
        return false;
    }
}

