/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sourceforge.tess4j.Tesseract1;
import net.sourceforge.tess4j.TesseractException;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.Finder;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.support.RunTime;

public class TextRecognizer {
    private static int lvl = 3;
    private static TextRecognizer textRecognizer = null;
    public static String versionTess4J = "4.4.1";
    public static String versionTesseract = "4.1.0";
    private int actualDPI = 72;
    public float optimumDPI = 192.0f;
    private Tesseract1 tess = null;
    private int oem = -1;
    private int psm = -1;
    private boolean dataPathProvided = false;
    private String dataPath = null;
    private String language = Settings.OcrLanguage;
    private boolean hasOsdTrData = false;

    private TextRecognizer() {
        Finder.Finder2.init();
    }

    public boolean isValid() {
        return this.tess != null;
    }

    public int getActualDPI() {
        return this.actualDPI;
    }

    private float factor() {
        return this.optimumDPI / (float)this.actualDPI;
    }

    public static TextRecognizer start() {
        block14: {
            if (textRecognizer == null) {
                textRecognizer = new TextRecognizer();
                Debug.log(lvl, "TextRecognizer: start: Tess4J %s using Tesseract %s", new Object[]{versionTess4J, versionTesseract});
                try {
                    TextRecognizer.textRecognizer.tess = new Tesseract1();
                    boolean tessdataOK = TextRecognizer.extractTessdata();
                    if (tessdataOK) {
                        Debug.log(lvl, "TextRecognizer: start: data folder: %s", TextRecognizer.textRecognizer.dataPath);
                        TextRecognizer.textRecognizer.tess.setDatapath(TextRecognizer.textRecognizer.dataPath);
                        if (!new File(TextRecognizer.textRecognizer.dataPath, TextRecognizer.textRecognizer.language + ".traineddata").exists()) {
                            textRecognizer = null;
                            Debug.error("TextRecognizer: start: no %s.traineddata - provide another language", TextRecognizer.textRecognizer.language);
                        } else {
                            Debug.log(lvl, "TextRecognizer: start: language: %s", TextRecognizer.textRecognizer.language);
                        }
                    } else {
                        textRecognizer = null;
                        if (TextRecognizer.textRecognizer.dataPathProvided) {
                            Debug.error("TextRecognizer: start: provided tessdata folder not found: %s", Settings.OcrDataPath);
                        } else {
                            Debug.error("TextRecognizer: start: no valid tesseract data folder", new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    textRecognizer = null;
                    Debug.error("TextRecognizer: start: %s", e.getMessage());
                }
                catch (UnsatisfiedLinkError e) {
                    textRecognizer = null;
                    Debug.error("TextRecognizer: start: Tesseract library problems: %s", e.getMessage());
                    String helpURL = RunTime.get().runningWindows ? "https://github.com/RaiMan/SikuliX1/wiki/Windows:-Problems-with-libraries-OpenCV-or-Tesseract" : "https://github.com/RaiMan/SikuliX1/wiki/macOS-Linux:-Support-libraries-for-Tess4J-Tesseract-4-OCR";
                    Debug.error("see: " + helpURL, new Object[0]);
                    if (!RunTime.isIDE()) break block14;
                    Debug.error("Save your work, correct the problem and restart the IDE!", new Object[0]);
                    try {
                        Desktop.getDesktop().browse(new URI(helpURL));
                    }
                    catch (IOException iOException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        if (null == textRecognizer) {
            throw new SikuliXception(String.format("fatal: TextRecognizer could not be initialized", new Object[0]));
        }
        textRecognizer.setLanguage(TextRecognizer.textRecognizer.language);
        return textRecognizer;
    }

    public static boolean extractTessdata() {
        boolean shouldExtract = false;
        File fTessDataPath = new File(RunTime.get().fSikulixAppPath, "SikulixTesseract/tessdata");
        if (fTessDataPath.exists()) {
            if (RunTime.get().shouldExport()) {
                shouldExtract = true;
                FileManager.deleteFileOrFolder(fTessDataPath);
            }
        } else {
            shouldExtract = true;
        }
        if (shouldExtract) {
            long tessdataStart = new Date().getTime();
            List<String> files = RunTime.get().extractResourcesToFolder("/tessdataSX", fTessDataPath, null);
            Debug.log("TextRecognizer: start: extracting tessdata took %d msec", new Date().getTime() - tessdataStart);
            if (files.size() == 0) {
                Debug.error("TextRecognizer: start: export tessdata not possible", new Object[0]);
            }
        }
        if (Settings.OcrDataPath != null) {
            fTessDataPath = new File(Settings.OcrDataPath, "tessdata");
            TextRecognizer.textRecognizer.dataPathProvided = true;
        }
        if (fTessDataPath.exists()) {
            TextRecognizer.textRecognizer.dataPath = fTessDataPath.getAbsolutePath();
            TextRecognizer.textRecognizer.hasOsdTrData = new File(TextRecognizer.textRecognizer.dataPath, "osd.traineddata").exists();
            return true;
        }
        return false;
    }

    public Tesseract1 getAPI() {
        return this.tess;
    }

    public TextRecognizer setOEM(OcrEngineMode oem) {
        return this.setOEM(oem.ordinal());
    }

    public TextRecognizer setOEM(int oem) {
        if (oem < 0 || oem > 3) {
            Debug.error("Tesseract: oem invalid (%d) - using default (3)", oem);
            oem = 3;
        }
        if (this.isValid()) {
            this.oem = oem;
            this.tess.setOcrEngineMode(this.oem);
        }
        return this;
    }

    public TextRecognizer setPSM(PageSegMode psm) {
        return this.setPSM(psm.ordinal());
    }

    public TextRecognizer setPSM(int psm) {
        if (psm < 0 || psm > 13) {
            Debug.error("Tesseract: psm invalid (%d) - using default (3)", psm);
            psm = 3;
        }
        if (this.isValid()) {
            if (!(psm != PageSegMode.OSD_ONLY.ordinal() && psm != PageSegMode.AUTO_OSD.ordinal() && psm != PageSegMode.SPARSE_TEXT_OSD.ordinal() || this.hasOsdTrData)) {
                String msg = String.format("TextRecognizer: setPSM(%d): needs OSD, but no osd.traineddata found in tessdata folder", psm);
                throw new SikuliXception(String.format("fatal: " + msg, new Object[0]));
            }
            this.psm = psm;
            this.tess.setPageSegMode(this.psm);
        }
        return this;
    }

    public TextRecognizer setDataPath(String newDataPath) {
        if (this.isValid() && new File(newDataPath).exists()) {
            if (new File(newDataPath, this.language + ".traineddata").exists()) {
                this.dataPath = newDataPath;
                this.tess.setDatapath(this.dataPath);
            } else {
                String msg = String.format("TextRecognizer: setDataPath: not valid - no %s.traineddata (%s)", this.language, newDataPath);
                throw new SikuliXception(String.format("fatal: " + msg, new Object[0]));
            }
        }
        return this;
    }

    public TextRecognizer setLanguage(String language) {
        if (this.isValid()) {
            if (new File(this.dataPath, language + ".traineddata").exists()) {
                this.language = language;
                this.tess.setLanguage(this.language);
            } else {
                String msg = String.format("TextRecognizer: setLanguage: no %s.traineddata in %s", language, this.dataPath);
                throw new SikuliXception(String.format("fatal: " + msg, new Object[0]));
            }
        }
        return this;
    }

    public TextRecognizer setVariable(String key, String value) {
        if (this.isValid()) {
            this.tess.setTessVariable(key, value);
        }
        return this;
    }

    public TextRecognizer setConfigs(String ... configs) {
        if (this.isValid()) {
            this.tess.setConfigs(Arrays.asList(configs));
        }
        return this;
    }

    public TextRecognizer setConfigs(List<String> configs) {
        if (this.isValid()) {
            this.tess.setConfigs(configs);
        }
        return this;
    }

    public static String doOCR(ScreenImage simg) {
        return TextRecognizer.doOCR(simg.getImage());
    }

    public static String doOCR(BufferedImage bimg) {
        String text = "";
        TextRecognizer tr = TextRecognizer.start();
        if (tr.isValid()) {
            text = tr.read(bimg);
        }
        return text;
    }

    private String read(BufferedImage bimg) {
        if (this.isValid()) {
            try {
                return this.tess.doOCR(this.optimize(bimg));
            }
            catch (TesseractException e) {
                Debug.error("TextRecognizer: read: Tess4J: doOCR: %s", e.getMessage());
            }
        } else {
            Debug.error("TextRecognizer: read: not valid", new Object[0]);
        }
        return "";
    }

    private Mat unsharpMask(Mat img, double sigma) {
        Mat blurred = new Mat();
        Imgproc.GaussianBlur(img, blurred, new Size(), sigma, sigma);
        Core.addWeighted(img, 1.5, blurred, -0.5, 0.0, img);
        return img;
    }

    public BufferedImage optimize(BufferedImage bimg) {
        Mat img = Finder.Finder2.makeMat(bimg);
        Imgproc.cvtColor(img, img, 6);
        img = this.unsharpMask(img, 3.0);
        this.actualDPI = Toolkit.getDefaultToolkit().getScreenResolution();
        float rFactor = this.factor();
        if (rFactor > 1.0f) {
            int newW = (int)(rFactor * (float)bimg.getWidth());
            int newH = (int)(rFactor * (float)bimg.getHeight());
            Imgproc.resize(img, img, new Size(newW, newH), 0.0, 0.0, 2);
        }
        img = this.unsharpMask(img, 5.0);
        if (Core.mean((Mat)img).val[0] < 127.0) {
            Core.bitwise_not(img, img);
        }
        this.setVariable("user_defined_dpi", "" + this.optimumDPI);
        return Finder.Finder2.getBufferedImage(img);
    }

    public Region rescale(Rectangle rect) {
        Region reg = new Region();
        reg.x = (int)(rect.getX() / (double)this.factor());
        reg.y = (int)(rect.getY() / (double)this.factor());
        reg.w = (int)(rect.getWidth() / (double)this.factor()) + 2;
        reg.h = (int)(rect.getHeight() / (double)this.factor()) + 2;
        return reg;
    }

    public Region relocate(Rectangle rect, Region base) {
        Region reg = this.rescale(rect);
        reg.x += base.x;
        reg.y += base.y;
        reg.setScreen(base.getScreen().getID());
        return reg;
    }

    public Rectangle relocateAsRectangle(Rectangle rect, Region base) {
        Region reg = this.relocate(rect, base);
        return new Rectangle(reg.x, reg.y, reg.w, reg.h);
    }

    @Deprecated
    public static TextRecognizer getInstance() {
        TextRecognizer tr = TextRecognizer.start();
        if (!tr.isValid()) {
            return null;
        }
        return tr;
    }

    public static void reset() {
        textRecognizer = null;
    }

    @Deprecated
    public String recognize(ScreenImage simg) {
        BufferedImage bimg = simg.getImage();
        return this.read(bimg);
    }

    @Deprecated
    public String recognize(BufferedImage bimg) {
        return this.read(bimg);
    }

    public static enum OcrEngineMode {
        TESSERACT_ONLY,
        LSTM_ONLY,
        TESSERACT_LSTM_COMBINED,
        DEFAULT;

    }

    public static enum PageSegMode {
        OSD_ONLY,
        AUTO_OSD,
        AUTO_ONLY,
        AUTO,
        SINGLE_COLUMN,
        SINGLE_BLOCK_VERT_TEXT,
        SINGLE_BLOCK,
        SINGLE_LINE,
        SINGLE_WORD,
        CIRCLE_WORD,
        SINGLE_CHAR,
        SPARSE_TEXT,
        SPARSE_TEXT_OSD,
        COUNT;

    }
}

