/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.sikuli.basics.Debug;
import org.sikuli.script.Mouse;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;

public class SX {
    private static Log log = new Log();

    private static boolean isVersion1() {
        return true;
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static void pause(double time) {
        try {
            Thread.sleep((int)(time * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String input(Object ... args) {
        if (!SX.isHeadless()) {
            return (String)SX.doPop(PopType.POPINPUT, args);
        }
        Log.error("running headless: input", new Object[0]);
        return null;
    }

    public static Boolean popup(Object ... args) {
        if (!SX.isHeadless()) {
            return (Boolean)SX.doPop(PopType.POPUP, args);
        }
        Log.error("running headless: popup", new Object[0]);
        return false;
    }

    public static Boolean popAsk(Object ... args) {
        if (!SX.isHeadless()) {
            return (Boolean)SX.doPop(PopType.POPASK, args);
        }
        Log.error("running headless: popAsk", new Object[0]);
        return false;
    }

    public static Boolean popError(Object ... args) {
        if (!SX.isHeadless()) {
            return (Boolean)SX.doPop(PopType.POPERROR, args);
        }
        Log.error("running headless: popError", new Object[0]);
        return false;
    }

    private static Object doPop(PopType popType, Object ... args) {
        class RunInput
        implements Runnable {
            PopType popType = PopType.POPUP;
            JFrame frame = null;
            String title = "";
            String message = "";
            String preset = "";
            Boolean hidden = false;
            Integer timeout = 0;
            boolean running = true;
            Map<String, Object> parameters = new HashMap<String, Object>();
            Object returnValue;
            JComponent toGetFocus = null;

            public RunInput(PopType popType, Object ... args) {
                this.popType = popType;
                this.parameters = SX.getPopParameters(args);
                this.title = (String)this.parameters.get("title");
                this.message = (String)this.parameters.get("message");
                this.preset = (String)this.parameters.get("preset");
                this.hidden = (Boolean)this.parameters.get("hidden");
                this.timeout = (Integer)this.parameters.get("timeout");
                this.frame = SX.getFrame(this.parameters.get("location"));
            }

            @Override
            public void run() {
                this.returnValue = null;
                if (PopType.POPUP.equals((Object)this.popType)) {
                    JOptionPane.showMessageDialog(this.frame, this.message, this.title, -1);
                    this.returnValue = Boolean.TRUE;
                } else if (PopType.POPASK.equals((Object)this.popType)) {
                    int ret = JOptionPane.showConfirmDialog(this.frame, this.message, this.title, 0);
                    this.returnValue = Boolean.TRUE;
                    if (ret == -1 || ret == 1) {
                        this.returnValue = Boolean.FALSE;
                    }
                } else if (PopType.POPERROR.equals((Object)this.popType)) {
                    JOptionPane.showMessageDialog(this.frame, this.message, this.title, 0);
                    this.returnValue = Boolean.TRUE;
                } else if (PopType.POPINPUT.equals((Object)this.popType)) {
                    if (!this.hidden.booleanValue()) {
                        if ("".equals(this.title)) {
                            this.title = "Sikuli input request";
                        }
                        this.returnValue = JOptionPane.showInputDialog(this.frame, this.message, this.title, -1, null, null, this.preset);
                    } else {
                        JTextArea messageText = new JTextArea(this.message);
                        messageText.setColumns(20);
                        messageText.setLineWrap(true);
                        messageText.setWrapStyleWord(true);
                        messageText.setEditable(false);
                        messageText.setBackground(new JLabel().getBackground());
                        JPasswordField passwordField = new JPasswordField(this.preset);
                        this.toGetFocus = passwordField;
                        JPanel panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 1));
                        panel.add(passwordField);
                        panel.add(Box.createVerticalStrut(10));
                        panel.add(messageText);
                        int retval = JOptionPane.showConfirmDialog(this.frame, panel, this.title, 2);
                        this.returnValue = "";
                        if (0 == retval) {
                            char[] pwchar = passwordField.getPassword();
                            for (int i = 0; i < pwchar.length; ++i) {
                                this.returnValue = (String)this.returnValue + pwchar[i];
                                pwchar[i] = '\u0000';
                            }
                        }
                    }
                }
                this.stop();
            }

            public void setFocus() {
                if (SX.isNotNull(this.toGetFocus)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            toGetFocus.requestFocusInWindow();
                        }
                    });
                }
            }

            public boolean isRunning() {
                return this.running;
            }

            public void stop() {
                this.frame.dispose();
                this.running = false;
            }

            public int getTimeout() {
                if (Integer.MAX_VALUE == this.timeout) {
                    return this.timeout;
                }
                return this.timeout * 1000;
            }

            public Object getReturnValue() {
                return this.returnValue;
            }
        }
        RunInput popRun = new RunInput(popType, args);
        new Thread(popRun).start();
        SX.pause(0.3);
        popRun.setFocus();
        long end = new Date().getTime() + (long)popRun.getTimeout();
        while (popRun.isRunning()) {
            SX.pause(0.3);
            if (end >= new Date().getTime()) continue;
            popRun.stop();
        }
        return popRun.getReturnValue();
    }

    private static Map<String, Object> getPopParameters(Object ... args) {
        String parameterNames = "message,title,preset,hidden,timeout,location";
        String parameterClass = "s,s,s,b,i,e";
        Object[] parameterDefault = new Object[]{"not set", "SikuliX", "", false, Integer.MAX_VALUE, SX.on()};
        return Parameters.get(parameterNames, parameterClass, parameterDefault, args);
    }

    private static JFrame getFrame(Object point) {
        int y;
        int x;
        if (point instanceof Point) {
            x = ((Point)point).x;
            y = ((Point)point).y;
        } else if (SX.isVersion1()) {
            x = ((Region)point).getCenter().x;
            y = ((Region)point).getCenter().y;
        } else {
            x = ((Element)point).getCenter().x;
            y = ((Element)point).getCenter().y;
        }
        JFrame anchor = new JFrame();
        anchor.setAlwaysOnTop(true);
        anchor.setUndecorated(true);
        anchor.setSize(1, 1);
        anchor.setLocation(x, y);
        anchor.setVisible(true);
        return anchor;
    }

    public static Region on() {
        return Screen.getPrimaryScreen();
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public void reset() {
        Debug.log(3, "SX.reset()", new Object[0]);
        Screen.resetMonitorsQuiet();
        Mouse.reset();
    }

    static class Element
    extends Region {
        Element() {
        }
    }

    private static class Parameters {
        private Map<String, String> parameterTypes = new HashMap<String, String>();
        private String[] parameterNames = null;
        private Object[] parameterDefaults = new Object[0];

        public Parameters(String theNames, String theClasses, Object[] theDefaults) {
            String[] names = theNames.split(",");
            String[] classes = theClasses.split(",");
            if (names.length == classes.length) {
                for (int n = 0; n < names.length; ++n) {
                    String clazz = classes[n];
                    if (clazz.length() == 1) {
                        if ("s".equals(clazz = clazz.toLowerCase())) {
                            clazz = "String";
                        } else if ("i".equals(clazz)) {
                            clazz = "Integer";
                        } else if ("d".equals(clazz)) {
                            clazz = "Double";
                        } else if ("b".equals(clazz)) {
                            clazz = "Boolean";
                        } else if ("e".equals(clazz)) {
                            if (SX.isVersion1()) {
                                clazz = "Region";
                            }
                            clazz = "Element";
                        }
                    }
                    if (!"String".equals(clazz) && !"Integer".equals(clazz) && !"Double".equals(clazz) && !"Boolean".equals(clazz) && !"Element".equals(clazz) && !"Region".equals(clazz)) continue;
                    this.parameterTypes.put(names[n], clazz);
                }
                this.parameterNames = names;
                this.parameterDefaults = theDefaults;
            } else {
                log;
                Log.error("Parameters: different length: names: %s classes: %s", theNames, theClasses);
            }
        }

        public static Map<String, Object> get(Object ... args) {
            String theNames = (String)args[0];
            String theClasses = (String)args[1];
            Object[] theDefaults = (Object[])args[2];
            Object[] theArgs = (Object[])args[3];
            Parameters theParameters = new Parameters(theNames, theClasses, theDefaults);
            return theParameters.getParameters(theArgs);
        }

        private Object getParameter(Object possibleValue, String parameterName) {
            String clazz = this.parameterTypes.get(parameterName);
            Object value = null;
            if ("String".equals(clazz)) {
                if (possibleValue instanceof String) {
                    value = possibleValue;
                }
            } else if ("Integer".equals(clazz)) {
                if (possibleValue instanceof Integer) {
                    value = possibleValue;
                }
            } else if ("Double".equals(clazz)) {
                if (possibleValue instanceof Double) {
                    value = possibleValue;
                }
            } else if ("Boolean".equals(clazz)) {
                if (possibleValue instanceof Boolean) {
                    value = possibleValue;
                }
            } else if ("Element".equals(clazz)) {
                if (SX.isVersion1()) {
                    if (possibleValue instanceof Region) {
                        value = possibleValue;
                    }
                } else if (possibleValue instanceof Element) {
                    value = possibleValue;
                }
            }
            return value;
        }

        public Map<String, Object> getParameters(Object[] args) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (SX.isNotNull(this.parameterNames)) {
                int n = 0;
                int argsn = 0;
                for (String parameterName : this.parameterNames) {
                    Object arg;
                    params.put(parameterName, this.parameterDefaults[n]);
                    if (args.length > 0 && argsn < args.length && SX.isNotNull(arg = this.getParameter(args[argsn], parameterName))) {
                        params.put(parameterName, arg);
                        ++argsn;
                    }
                    ++n;
                }
            }
            return params;
        }
    }

    private static enum PopType {
        POPUP,
        POPASK,
        POPERROR,
        POPINPUT;

    }

    public static class Log {
        public static void error(String msg, Object ... args) {
            Debug.error("SX: " + msg, args);
        }
    }
}

