/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.util.EventListener;
import org.sikuli.basics.Debug;
import org.sikuli.script.ObserveEvent;
import org.sikuli.script.runnerSupport.IRunnerSupport;
import org.sikuli.script.runnerSupport.JRubySupport;
import org.sikuli.script.runnerSupport.JythonSupport;

public class ObserverCallBack
implements EventListener {
    private Object callback = null;
    private IRunnerSupport scriptHelper = null;
    private String scriptRunnerType = null;
    private ObserveEvent.Type obsType = ObserveEvent.Type.GENERIC;

    public ObserverCallBack() {
    }

    public ObserverCallBack(Object callback, ObserveEvent.Type obsType) {
        this.callback = callback;
        this.obsType = obsType;
        if (callback.getClass().getName().contains("org.python")) {
            this.scriptRunnerType = "jython";
            this.scriptHelper = JythonSupport.get();
        } else if (callback.getClass().getName().contains("org.jruby")) {
            this.scriptRunnerType = "jruby";
            this.scriptHelper = JRubySupport.get();
        } else {
            Debug.error("ObserverCallBack: %s init: ScriptRunner not available for class %s", new Object[]{obsType, callback.getClass().getName()});
        }
    }

    public void setType(ObserveEvent.Type givenType) {
        this.obsType = givenType;
    }

    public ObserveEvent.Type getType() {
        return this.obsType;
    }

    public void appeared(ObserveEvent event) {
        if (this.scriptHelper != null && ObserveEvent.Type.APPEAR.equals((Object)this.obsType)) {
            this.run(event);
        }
    }

    public void vanished(ObserveEvent event) {
        if (this.scriptHelper != null && ObserveEvent.Type.VANISH.equals((Object)this.obsType)) {
            this.run(event);
        }
    }

    public void changed(ObserveEvent event) {
        if (this.scriptHelper != null && ObserveEvent.Type.CHANGE.equals((Object)this.obsType)) {
            this.run(event);
        }
    }

    public void findfailed(ObserveEvent event) {
        if (this.scriptHelper != null && ObserveEvent.Type.FINDFAILED.equals((Object)this.obsType)) {
            this.run(event);
        }
    }

    public void missing(ObserveEvent event) {
        if (this.scriptHelper != null && ObserveEvent.Type.MISSING.equals((Object)this.obsType)) {
            this.run(event);
        }
    }

    public void happened(ObserveEvent event) {
        if (this.scriptHelper != null && ObserveEvent.Type.GENERIC.equals((Object)this.obsType)) {
            this.run(event);
        }
    }

    private void run(ObserveEvent e) {
        boolean success = true;
        Object[] args = new Object[]{this.callback, e};
        if (this.scriptHelper != null && !(success = this.scriptHelper.runObserveCallback(args))) {
            Debug.error("ObserverCallBack: problem with scripting handler: %s\n%s", this.scriptHelper.getClass().getName(), this.callback.getClass().getName());
        }
    }
}

