/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.jr.ob.api;

import com.signalfx.shaded.fasterxml.jackson.core.JsonParser;
import com.signalfx.shaded.fasterxml.jackson.core.JsonToken;
import com.signalfx.shaded.fasterxml.jackson.jr.ob.impl.JSONReader;
import java.io.IOException;

public abstract class ValueReader {
    protected final Class<?> _valueType;

    protected ValueReader(Class<?> clazz) {
        this._valueType = clazz;
    }

    public abstract Object read(JSONReader var1, JsonParser var2) throws IOException;

    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        jsonParser.nextToken();
        return this.read(jSONReader, jsonParser);
    }

    public Class<?> valueType() {
        return this._valueType;
    }

    public static String _tokenDesc(JsonParser jsonParser) throws IOException {
        return ValueReader._tokenDesc(jsonParser, jsonParser.currentToken());
    }

    public static String _tokenDesc(JsonParser jsonParser, JsonToken jsonToken) throws IOException {
        if (jsonToken == null) {
            return "NULL";
        }
        switch (jsonToken) {
            case FIELD_NAME: {
                return "JSON Field name '" + jsonParser.currentName() + "'";
            }
            case START_ARRAY: {
                return "JSON Array";
            }
            case START_OBJECT: {
                return "JSON Object";
            }
            case VALUE_FALSE: {
                return "`false`";
            }
            case VALUE_NULL: {
                return "'null'";
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return "JSON Number";
            }
            case VALUE_STRING: {
                return "JSON String";
            }
            case VALUE_TRUE: {
                return "`true`";
            }
            case VALUE_EMBEDDED_OBJECT: {
                Object object = jsonParser.getEmbeddedObject();
                if (object == null) {
                    return "EMBEDDED_OBJECT `null`";
                }
                return "EMBEDDED_OBJECT of type " + jsonParser.getClass().getName();
            }
        }
        return jsonToken.toString();
    }
}

