/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.jr.ob.impl;

import com.signalfx.shaded.fasterxml.jackson.jr.ob.impl.POJODefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public final class RecordsHelpers {
    private static boolean supportsRecords;
    private static Method getRecordComponentsMethod;
    private static Method getComponentTypeMethod;

    private RecordsHelpers() {
    }

    static Constructor<?> findCanonicalConstructor(Class<?> clazz) {
        if (!supportsRecords || !RecordsHelpers.isRecordType(clazz)) {
            return null;
        }
        try {
            Object[] objectArray = RecordsHelpers.componentTypes(clazz);
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Object[] objectArray2 = constructor.getParameterTypes();
                if (objectArray2.length != objectArray.length || !Arrays.equals(objectArray2, objectArray)) continue;
                return constructor;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    static boolean isRecordConstructor(Class<?> clazz, Constructor<?> constructor, Map<String, POJODefinition.PropBuilder> map) {
        if (!supportsRecords || !RecordsHelpers.isRecordType(clazz)) {
            return false;
        }
        Object[] objectArray = constructor.getParameterTypes();
        if (objectArray.length != map.size()) {
            return false;
        }
        try {
            Object[] objectArray2 = RecordsHelpers.componentTypes(clazz);
            return Arrays.equals(objectArray, objectArray2);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return false;
        }
    }

    static boolean isRecordType(Class<?> clazz) {
        Class<?> clazz2 = clazz.getSuperclass();
        return clazz2 != null && "java.lang.Record".equals(clazz2.getName());
    }

    private static Class<?>[] componentTypes(Class<?> clazz) throws ReflectiveOperationException {
        Object[] objectArray = (Object[])getRecordComponentsMethod.invoke(clazz, new Object[0]);
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Class clazz2;
            Object object = objectArray[i];
            classArray[i] = clazz2 = (Class)getComponentTypeMethod.invoke(object, new Object[0]);
        }
        return classArray;
    }

    static {
        try {
            getRecordComponentsMethod = Class.class.getMethod("getRecordComponents", new Class[0]);
            Class<?> clazz = Class.forName("java.lang.reflect.RecordComponent");
            getComponentTypeMethod = clazz.getMethod("getType", new Class[0]);
            supportsRecords = true;
        }
        catch (Throwable throwable) {
            supportsRecords = false;
        }
    }
}

