/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.jr.ob.impl;

import com.signalfx.shaded.fasterxml.jackson.jr.ob.JSON;
import com.signalfx.shaded.fasterxml.jackson.jr.ob.impl.BeanConstructors;
import com.signalfx.shaded.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.signalfx.shaded.fasterxml.jackson.jr.ob.impl.JSONWriter;
import com.signalfx.shaded.fasterxml.jackson.jr.ob.impl.POJODefinition;
import com.signalfx.shaded.fasterxml.jackson.jr.ob.impl.RecordsHelpers;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class BeanPropertyIntrospector {
    protected static final POJODefinition.Prop[] NO_PROPS = new POJODefinition.Prop[0];
    private static final BeanPropertyIntrospector INSTANCE = new BeanPropertyIntrospector();

    public static BeanPropertyIntrospector instance() {
        return INSTANCE;
    }

    public POJODefinition pojoDefinitionForDeserialization(JSONReader jSONReader, Class<?> clazz) {
        return this._introspectDefinition(clazz, false, jSONReader.features());
    }

    public POJODefinition pojoDefinitionForSerialization(JSONWriter jSONWriter, Class<?> clazz) {
        return this._introspectDefinition(clazz, true, jSONWriter.features());
    }

    private POJODefinition _introspectDefinition(Class<?> clazz, boolean bl, int n) {
        POJODefinition.Prop[] propArray;
        BeanConstructors beanConstructors;
        TreeMap<String, POJODefinition.PropBuilder> treeMap = new TreeMap<String, POJODefinition.PropBuilder>();
        BeanPropertyIntrospector._introspect(clazz, treeMap, n);
        if (bl) {
            beanConstructors = null;
        } else {
            beanConstructors = new BeanConstructors(clazz);
            if (RecordsHelpers.isRecordType(clazz)) {
                Constructor<?>[] constructorArray = RecordsHelpers.findCanonicalConstructor(clazz);
                if (constructorArray == null) {
                    throw new IllegalArgumentException("Unable to find canonical constructor of Record type `" + clazz.getClass().getName() + "`");
                }
                beanConstructors.addRecordConstructor((Constructor<?>)constructorArray);
            } else {
                for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                    Class<?>[] classArray = constructor.getParameterTypes();
                    if (classArray.length == 0) {
                        beanConstructors.addNoArgsConstructor(constructor);
                        continue;
                    }
                    if (classArray.length != 1) continue;
                    Class<?> clazz2 = classArray[0];
                    if (clazz2 == String.class) {
                        beanConstructors.addStringConstructor(constructor);
                        continue;
                    }
                    if (clazz2 == Integer.class || clazz2 == Integer.TYPE) {
                        beanConstructors.addIntConstructor(constructor);
                        continue;
                    }
                    if (clazz2 != Long.class && clazz2 != Long.TYPE) continue;
                    beanConstructors.addLongConstructor(constructor);
                }
            }
        }
        int n2 = treeMap.size();
        if (n2 == 0) {
            propArray = NO_PROPS;
        } else {
            propArray = new POJODefinition.Prop[n2];
            int n3 = 0;
            for (Class<?>[] classArray : treeMap.values()) {
                propArray[n3++] = classArray.build();
            }
        }
        return new POJODefinition(clazz, propArray, beanConstructors);
    }

    private static void _introspect(Class<?> clazz, Map<String, POJODefinition.PropBuilder> map, int n) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        BeanPropertyIntrospector._introspect(clazz.getSuperclass(), map, n);
        boolean bl = JSON.Feature.INCLUDE_STATIC_FIELDS.isDisabled(n);
        boolean bl2 = JSON.Feature.USE_FIELD_MATCHING_GETTERS.isEnabled(n) || RecordsHelpers.isRecordType(clazz);
        HashMap<String, Field> hashMap = bl2 ? new HashMap<String, Field>() : null;
        for (Field accessibleObject : clazz.getDeclaredFields()) {
            if (hashMap != null) {
                hashMap.put(accessibleObject.getName(), accessibleObject);
            }
            if (!Modifier.isPublic(accessibleObject.getModifiers()) || accessibleObject.isEnumConstant() || accessibleObject.isSynthetic() || Modifier.isStatic(accessibleObject.getModifiers()) && (bl || Modifier.isFinal(accessibleObject.getModifiers()))) continue;
            BeanPropertyIntrospector._propFrom(map, accessibleObject.getName()).withField(accessibleObject);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Object object;
            int n2 = ((Method)accessibleObject).getModifiers();
            if (Modifier.isStatic(n2) || ((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge() || BeanPropertyIntrospector.isGroovyMetaClass(((Method)accessibleObject).getReturnType())) continue;
            Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
            if (classArray.length == 0) {
                Field field;
                if (!Modifier.isPublic(n2) || (object = ((Method)accessibleObject).getReturnType()) == Void.class) continue;
                String string = ((Method)accessibleObject).getName();
                if (string.startsWith("get")) {
                    if (string.length() <= 3) continue;
                    string = BeanPropertyIntrospector.decap(string.substring(3));
                    BeanPropertyIntrospector._propFrom(map, string).withGetter((Method)accessibleObject);
                    continue;
                }
                if (string.startsWith("is")) {
                    if (string.length() <= 2) continue;
                    string = BeanPropertyIntrospector.decap(string.substring(2));
                    BeanPropertyIntrospector._propFrom(map, string).withIsGetter((Method)accessibleObject);
                    continue;
                }
                if (!bl2 || (field = (Field)hashMap.get(string)) == null || !Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !((Method)accessibleObject).getReturnType().equals(field.getType())) continue;
                BeanPropertyIntrospector._propFrom(map, string).withGetter((Method)accessibleObject);
                continue;
            }
            if (classArray.length != 1 || !((String)(object = ((Method)accessibleObject).getName())).startsWith("set") || ((String)object).length() == 3) continue;
            object = BeanPropertyIntrospector.decap(((String)object).substring(3));
            BeanPropertyIntrospector._propFrom(map, (String)object).withSetter((Method)accessibleObject);
        }
    }

    private static POJODefinition.PropBuilder _propFrom(Map<String, POJODefinition.PropBuilder> map, String string) {
        return map.computeIfAbsent(string, POJODefinition.Prop::builder);
    }

    private static String decap(String string) {
        char c;
        char c2 = string.charAt(0);
        if (!(c2 == (c = Character.toLowerCase(c2)) || string.length() != 1 && Character.isUpperCase(string.charAt(1)))) {
            char[] cArray = string.toCharArray();
            cArray[0] = c;
            return new String(cArray);
        }
        return string;
    }

    protected static boolean isGroovyMetaClass(Class<?> clazz) {
        return "groovy.lang.MetaClass".equals(clazz.getName());
    }
}

