/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.connection;

import com.signalfx.connection.RetryDefaults;
import com.signalfx.connection.RetryHandler;
import com.signalfx.connection.RetryStrategy;
import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.shaded.apache.http.HttpEntity;
import com.signalfx.shaded.apache.http.HttpHost;
import com.signalfx.shaded.apache.http.client.config.RequestConfig;
import com.signalfx.shaded.apache.http.client.entity.GzipCompressingEntity;
import com.signalfx.shaded.apache.http.client.methods.CloseableHttpResponse;
import com.signalfx.shaded.apache.http.client.methods.HttpPost;
import com.signalfx.shaded.apache.http.conn.HttpClientConnectionManager;
import com.signalfx.shaded.apache.http.entity.ContentType;
import com.signalfx.shaded.apache.http.impl.client.CloseableHttpClient;
import com.signalfx.shaded.apache.http.impl.client.HttpClientBuilder;
import com.signalfx.shaded.apache.http.util.EntityUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpReceiverConnection {
    protected static final Logger log = LoggerFactory.getLogger(AbstractHttpReceiverConnection.class);
    public static final String VERSION_NUMBER = "1.0.40";
    public static final String USER_AGENT = "SignalFx-java-client/1.0.40";
    public static final String DISABLE_COMPRESSION_PROPERTY = "com.signalfx.public.java.disableHttpCompression";
    protected static final ContentType JSON_TYPE = ContentType.APPLICATION_JSON;
    protected final CloseableHttpClient client;
    protected final HttpHost host;
    protected final RequestConfig requestConfig;

    protected AbstractHttpReceiverConnection(SignalFxReceiverEndpoint endpoint, int timeoutMs, HttpClientConnectionManager httpClientConnectionManager) {
        this(endpoint, timeoutMs, 3, httpClientConnectionManager);
    }

    protected AbstractHttpReceiverConnection(SignalFxReceiverEndpoint endpoint, int timeoutMs, int maxRetries, HttpClientConnectionManager httpClientConnectionManager) {
        this(endpoint, timeoutMs, 3, httpClientConnectionManager, RetryDefaults.DEFAULT_NON_RETRYABLE_EXCEPTIONS);
    }

    protected AbstractHttpReceiverConnection(SignalFxReceiverEndpoint endpoint, int timeoutMs, int maxRetries, HttpClientConnectionManager httpClientConnectionManager, List<Class<? extends IOException>> nonRetryableExceptions) {
        this.client = HttpClientBuilder.create().setConnectionManager(httpClientConnectionManager).setRetryHandler(new RetryHandler(maxRetries, nonRetryableExceptions)).setServiceUnavailableRetryStrategy(new RetryStrategy(maxRetries)).build();
        this.host = new HttpHost(endpoint.getHostname(), endpoint.getPort(), endpoint.getScheme());
        HttpHost proxy = this.createHttpProxyFromSystemProperties(endpoint.getHostname());
        this.requestConfig = RequestConfig.custom().setSocketTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).setConnectTimeout(timeoutMs).setProxy(proxy).build();
    }

    protected CloseableHttpResponse postToEndpoint(String auth, HttpEntity entity, String endpoint, boolean compress) throws IOException {
        if (compress) {
            entity = new GzipCompressingEntity(entity);
        }
        HttpPost post = new HttpPost(String.format("%s%s", this.host.toURI(), endpoint));
        post.setConfig(this.requestConfig);
        if (auth != null) {
            post.setHeader("X-SF-TOKEN", auth);
        }
        post.setHeader("User-Agent", USER_AGENT);
        post.setEntity(entity);
        try {
            log.trace("Talking to endpoint {}", (Object)post);
            return this.client.execute(post);
        }
        catch (IOException e) {
            log.trace("Exception trying to execute {}", (Object)post, (Object)e);
            throw e;
        }
    }

    protected void checkHttpResponse(CloseableHttpResponse resp) {
        String body;
        try {
            body = EntityUtils.toString(resp.getEntity(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get response content", e);
        }
        if (resp.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("Invalid status code " + resp.getStatusLine().getStatusCode() + ": " + body);
        }
        if (!"\"OK\"".equals(body)) {
            throw new RuntimeException("Invalid response body: " + body);
        }
    }

    protected HttpHost createHttpProxyFromSystemProperties(String endpointHostname) {
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            String proxyPort;
            String nonProxyHosts = System.getProperty("http.nonProxyHosts");
            if (nonProxyHosts != null) {
                nonProxyHosts = nonProxyHosts.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*?");
                nonProxyHosts = "(" + nonProxyHosts.replaceAll("\\|", ")|(") + ")";
                Pattern pattern = Pattern.compile(nonProxyHosts);
                if (pattern.matcher(endpointHostname).find()) {
                    return null;
                }
            }
            if ((proxyPort = System.getProperty("http.proxyPort")) == null || proxyPort.trim().length() == 0) {
                proxyPort = "80";
            }
            return new HttpHost(proxyHost.trim(), Integer.parseInt(proxyPort.trim()), "http");
        }
        return null;
    }
}

