/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.commons.io.build;

import com.signalfx.shaded.apache.commons.io.build.AbstractSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public abstract class AbstractOrigin<T, B extends AbstractOrigin<T, B>>
extends AbstractSupplier<T, B> {
    final T origin;

    protected AbstractOrigin(T origin) {
        this.origin = Objects.requireNonNull(origin, "origin");
    }

    @Override
    public T get() {
        return this.origin;
    }

    public byte[] getByteArray() throws IOException {
        return Files.readAllBytes(this.getPath());
    }

    public File getFile() {
        throw new UnsupportedOperationException(this.origin.toString());
    }

    public InputStream getInputStream(OpenOption ... options) throws IOException {
        return Files.newInputStream(this.getPath(), options);
    }

    public OutputStream getOutputStream(OpenOption ... options) throws IOException {
        return Files.newOutputStream(this.getPath(), options);
    }

    public Path getPath() {
        throw new UnsupportedOperationException(this.origin.toString());
    }

    public Reader getReader(Charset charset) throws IOException {
        return Files.newBufferedReader(this.getPath(), charset);
    }

    public Writer getWriter(Charset charset, OpenOption ... options) throws IOException {
        return Files.newBufferedWriter(this.getPath(), charset, options);
    }

    public String toString() {
        return this.origin.toString();
    }

    public static class WriterOrigin
    extends AbstractOrigin<Writer, WriterOrigin> {
        public WriterOrigin(Writer origin) {
            super(origin);
        }

        @Override
        public Writer getWriter(Charset charset, OpenOption ... options) throws IOException {
            return (Writer)this.get();
        }
    }

    public static class URIOrigin
    extends AbstractOrigin<URI, URIOrigin> {
        public URIOrigin(URI origin) {
            super(origin);
        }

        @Override
        public File getFile() {
            return this.getPath().toFile();
        }

        @Override
        public Path getPath() {
            return Paths.get((URI)this.get());
        }
    }

    public static class ReaderOrigin
    extends AbstractOrigin<Reader, ReaderOrigin> {
        public ReaderOrigin(Reader origin) {
            super(origin);
        }

        @Override
        public Reader getReader(Charset charset) throws IOException {
            return (Reader)this.get();
        }
    }

    public static class PathOrigin
    extends AbstractOrigin<Path, PathOrigin> {
        public PathOrigin(Path origin) {
            super(origin);
        }

        @Override
        public File getFile() {
            return ((Path)this.get()).toFile();
        }

        @Override
        public Path getPath() {
            return (Path)this.get();
        }
    }

    public static class OutputStreamOrigin
    extends AbstractOrigin<OutputStream, OutputStreamOrigin> {
        public OutputStreamOrigin(OutputStream origin) {
            super(origin);
        }

        @Override
        public OutputStream getOutputStream(OpenOption ... options) {
            return (OutputStream)this.get();
        }
    }

    public static class InputStreamOrigin
    extends AbstractOrigin<InputStream, InputStreamOrigin> {
        public InputStreamOrigin(InputStream origin) {
            super(origin);
        }

        @Override
        public InputStream getInputStream(OpenOption ... options) {
            return (InputStream)this.get();
        }
    }

    public static class FileOrigin
    extends AbstractOrigin<File, FileOrigin> {
        public FileOrigin(File origin) {
            super(origin);
        }

        @Override
        public File getFile() {
            return (File)this.get();
        }

        @Override
        public Path getPath() {
            return ((File)this.get()).toPath();
        }
    }

    public static class ByteArrayOrigin
    extends AbstractOrigin<byte[], ByteArrayOrigin> {
        public ByteArrayOrigin(byte[] origin) {
            super(origin);
        }

        @Override
        public byte[] getByteArray() {
            return (byte[])this.get();
        }
    }
}

