/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.connection;

import com.signalfx.common.proto.ProtocolBufferStreamingInputStream;
import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.metrics.SignalFxMetricsException;
import com.signalfx.metrics.connection.AbstractHttpDataPointProtobufReceiverConnection;
import com.signalfx.metrics.protobuf.SignalFxProtocolBuffers;
import com.signalfx.shaded.apache.commons.io.IOUtils;
import com.signalfx.shaded.apache.http.HttpEntity;
import com.signalfx.shaded.apache.http.conn.HttpClientConnectionManager;
import com.signalfx.shaded.apache.http.entity.ByteArrayEntity;
import com.signalfx.shaded.apache.http.entity.InputStreamEntity;
import com.signalfx.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.signalfx.shaded.fasterxml.jackson.core.type.TypeReference;
import com.signalfx.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.signalfx.shaded.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpDataPointProtobufReceiverConnection
extends AbstractHttpDataPointProtobufReceiverConnection {
    public HttpDataPointProtobufReceiverConnection(SignalFxReceiverEndpoint endpoint, int timeoutMs, HttpClientConnectionManager httpClientConnectionManager) {
        super(endpoint, timeoutMs, httpClientConnectionManager);
    }

    @Override
    protected HttpEntity getEntityForVersion(List<SignalFxProtocolBuffers.DataPoint> dataPoints) {
        return new InputStreamEntity(new ProtocolBufferStreamingInputStream<SignalFxProtocolBuffers.DataPoint>(dataPoints.iterator()), PROTO_TYPE);
    }

    @Override
    protected String getEndpointForAddDatapoints() {
        return "/v1/datapoint";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Boolean> registerMetrics(String auth, Map<String, SignalFxProtocolBuffers.MetricType> metricTypes) throws SignalFxMetricsException {
        byte[] byArray;
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        for (Map.Entry<String, SignalFxProtocolBuffers.MetricType> entry : metricTypes.entrySet()) {
            res.put(entry.getKey(), false);
        }
        if (metricTypes.isEmpty()) {
            return res;
        }
        ArrayList<ImmutableMap<String, String>> postBodyList = new ArrayList<ImmutableMap<String, String>>(metricTypes.size());
        for (Map.Entry<String, SignalFxProtocolBuffers.MetricType> entry : metricTypes.entrySet()) {
            postBodyList.add(ImmutableMap.of("sf_metric", entry.getKey(), "sf_metricType", entry.getValue().toString()));
        }
        try {
            byArray = MAPPER.writeValueAsBytes(postBodyList);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new SignalFxMetricsException("Unable to write protocol buffer", jsonProcessingException);
        }
        String string = "";
        try (Closeable resp = null;){
            String string2;
            resp = this.postToEndpoint(auth, new ByteArrayEntity(byArray, JSON_TYPE), "/v1/metric?bulkupdate=true", false);
            try {
                string2 = IOUtils.toString(resp.getEntity().getContent());
            }
            catch (IOException e) {
                throw new SignalFxMetricsException("Unable to get reponse content", e);
            }
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new SignalFxMetricsException("Invalid status code " + resp.getStatusLine().getStatusCode() + ": " + string2);
            }
            List<Map<String, String>> respObject = new ObjectMapper().readValue(string2.getBytes(), new TypeReference<List<Map<String, String>>>(){});
            if (respObject.size() != metricTypes.size()) {
                throw new SignalFxMetricsException(String.format("json map mismatch: post_body=%s, resp=%s", new String(byArray), string2));
            }
            for (int i = 0; i < respObject.size(); ++i) {
                Map<String, String> m = respObject.get(i);
                if (m.containsKey("code") && !"409".equals(m.get("code").toString())) continue;
                res.put((String)((Map)postBodyList.get(i)).get("sf_metric"), true);
            }
        }
        catch (IOException e) {
            throw new SignalFxMetricsException(String.format("post_body=%s, resp=%s", new String(byArray), string), e);
        }
        return res;
    }
}

