/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.client.http;

import com.signalfx.shaded.jetty.client.AbstractConnectorHttpClientTransport;
import com.signalfx.shaded.jetty.client.DuplexConnectionPool;
import com.signalfx.shaded.jetty.client.HttpDestination;
import com.signalfx.shaded.jetty.client.Origin;
import com.signalfx.shaded.jetty.client.api.Connection;
import com.signalfx.shaded.jetty.client.http.HttpConnectionOverHTTP;
import com.signalfx.shaded.jetty.client.http.HttpDestinationOverHTTP;
import com.signalfx.shaded.jetty.io.EndPoint;
import com.signalfx.shaded.jetty.util.Callback;
import com.signalfx.shaded.jetty.util.ProcessorUtils;
import com.signalfx.shaded.jetty.util.Promise;
import com.signalfx.shaded.jetty.util.annotation.ManagedAttribute;
import com.signalfx.shaded.jetty.util.annotation.ManagedObject;
import java.io.IOException;
import java.util.Map;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)destination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public com.signalfx.shaded.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }
}

