/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.connection;

import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.metrics.SignalFxMetricsException;
import com.signalfx.metrics.connection.DataPointReceiver;
import com.signalfx.metrics.connection.DataPointReceiverFactory;
import com.signalfx.metrics.connection.HttpClientConnectionManagerFactory;
import com.signalfx.metrics.connection.HttpDataPointProtobufReceiverConnection;
import com.signalfx.metrics.connection.HttpDataPointProtobufReceiverConnectionV2;
import com.signalfx.shaded.apache.http.conn.HttpClientConnectionManager;
import com.signalfx.shaded.google.common.base.MoreObjects;

public class HttpDataPointProtobufReceiverFactory
implements DataPointReceiverFactory {
    public static final int DEFAULT_TIMEOUT_MS = 2000;
    public static final int DEFAULT_VERSION = 2;
    public static final int DEFAULT_MAX_RETRIES = 3;
    private final SignalFxReceiverEndpoint endpoint;
    private HttpClientConnectionManager httpClientConnectionManager;
    private HttpClientConnectionManager explicitHttpClientConnectionManager;
    private int timeoutMs = 2000;
    private int version = 2;
    private int maxRetries = 3;

    public HttpDataPointProtobufReceiverFactory(SignalFxReceiverEndpoint endpoint) {
        this.endpoint = endpoint;
        this.httpClientConnectionManager = HttpClientConnectionManagerFactory.withTimeoutMs(2000);
        this.explicitHttpClientConnectionManager = null;
    }

    public HttpDataPointProtobufReceiverFactory setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.httpClientConnectionManager = HttpClientConnectionManagerFactory.withTimeoutMs(timeoutMs);
        return this;
    }

    public HttpDataPointProtobufReceiverFactory setVersion(int version) {
        this.version = version;
        return this;
    }

    public HttpDataPointProtobufReceiverFactory setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public void setHttpClientConnectionManager(HttpClientConnectionManager httpClientConnectionManager) {
        this.explicitHttpClientConnectionManager = httpClientConnectionManager;
    }

    @Override
    public DataPointReceiver createDataPointReceiver() throws SignalFxMetricsException {
        if (this.version == 1) {
            return new HttpDataPointProtobufReceiverConnection(this.endpoint, this.timeoutMs, this.maxRetries, this.resolveHttpClientConnectionManager());
        }
        return new HttpDataPointProtobufReceiverConnectionV2(this.endpoint, this.timeoutMs, this.maxRetries, this.resolveHttpClientConnectionManager());
    }

    private HttpClientConnectionManager resolveHttpClientConnectionManager() {
        return MoreObjects.firstNonNull(this.explicitHttpClientConnectionManager, this.httpClientConnectionManager);
    }
}

